/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.vlayout.extend;

import android.support.annotation.NonNull;
import android.view.View;
import com.alibaba.android.vlayout.VirtualLayoutManager;
import com.alibaba.android.vlayout.extend.ViewLifeCycleListener;
import java.util.HashMap;

public class ViewLifeCycleHelper {
    private HashMap<View, STATUS> mViewStatusMap = new HashMap();
    private ViewLifeCycleListener mViewLifeCycleListener;
    private VirtualLayoutManager mVirtualLayoutManager;
    private int scrHeight;

    public ViewLifeCycleHelper(VirtualLayoutManager virtualLayoutManager, @NonNull ViewLifeCycleListener mViewLifeCycleListener) {
        this.mViewLifeCycleListener = mViewLifeCycleListener;
        this.mVirtualLayoutManager = virtualLayoutManager;
    }

    public void checkViewStatusInScreen() {
        for (int i = 0; i < this.mVirtualLayoutManager.getChildCount(); ++i) {
            View view = this.mVirtualLayoutManager.getChildAt(i);
            if (this.scrHeight == 0) {
                this.scrHeight = view.getContext().getResources().getDisplayMetrics().heightPixels;
            }
            if (this.mVirtualLayoutManager.getVirtualLayoutDirection() == 1) {
                if (view.getTop() <= 0 && view.getBottom() >= 0 && this.isViewReadyDisAppearing(view)) {
                    this.setViewDisappearing(view);
                } else if (view.getTop() <= this.scrHeight && view.getBottom() >= this.scrHeight && this.isViewReadyAppearing(view)) {
                    this.setViewAppearing(view);
                }
            } else if (view.getTop() <= 0 && view.getBottom() >= 0 && this.isViewReadyAppearing(view)) {
                this.setViewAppearing(view);
            } else if (view.getTop() <= this.scrHeight && view.getBottom() >= this.scrHeight && this.isViewReadyDisAppearing(view)) {
                this.setViewDisappearing(view);
            }
            if (view.getTop() >= 0 && view.getBottom() <= this.scrHeight) {
                if (this.isViewReadyAppearing(view)) {
                    this.setViewAppearing(view);
                    continue;
                }
                if (!this.isViewReadyAppeared(view)) continue;
                this.setViewAppeared(view);
                continue;
            }
            if (view.getBottom() > 0 && view.getTop() < this.scrHeight) continue;
            if (this.isViewReadyDisAppearing(view)) {
                this.setViewDisappearing(view);
                continue;
            }
            if (!this.isViewReadyDisAppeared(view)) continue;
            this.setViewDisappeared(view);
        }
    }

    private STATUS getViewStatus(View view) {
        if (!this.mViewStatusMap.containsKey(view)) {
            this.mViewStatusMap.put(view, STATUS.DISAPPEARED);
            return STATUS.DISAPPEARED;
        }
        return this.mViewStatusMap.get(view);
    }

    private void setViewstatus(View view, STATUS status) {
        this.mViewStatusMap.put(view, status);
    }

    private boolean isViewReadyAppearing(View view) {
        return this.getViewStatus(view) == STATUS.DISAPPEARED;
    }

    private void setViewAppearing(View view) {
        if (this.getViewStatus(view) == STATUS.APPEARING) {
            return;
        }
        this.setViewstatus(view, STATUS.APPEARING);
        if (null != this.mViewLifeCycleListener) {
            this.mViewLifeCycleListener.onAppearing(view);
        }
    }

    private boolean isViewReadyAppeared(View view) {
        return this.getViewStatus(view) == STATUS.APPEARING;
    }

    private void setViewAppeared(View view) {
        if (this.getViewStatus(view) == STATUS.APPEARED) {
            return;
        }
        this.setViewstatus(view, STATUS.APPEARED);
        if (null != this.mViewLifeCycleListener) {
            this.mViewLifeCycleListener.onAppeared(view);
        }
    }

    private boolean isViewReadyDisAppearing(View view) {
        return this.getViewStatus(view) == STATUS.APPEARED;
    }

    private void setViewDisappearing(View view) {
        if (this.getViewStatus(view) == STATUS.DISAPPEARING) {
            return;
        }
        this.setViewstatus(view, STATUS.DISAPPEARING);
        if (null != this.mViewLifeCycleListener) {
            this.mViewLifeCycleListener.onDisappearing(view);
        }
    }

    private boolean isViewReadyDisAppeared(View view) {
        return this.getViewStatus(view) == STATUS.DISAPPEARING;
    }

    private void setViewDisappeared(View view) {
        if (this.getViewStatus(view) == STATUS.DISAPPEARED) {
            return;
        }
        this.setViewstatus(view, STATUS.DISAPPEARED);
        if (null != this.mViewLifeCycleListener) {
            this.mViewLifeCycleListener.onDisappeared(view);
        }
    }

    public static enum STATUS {
        APPEARING,
        APPEARED,
        DISAPPEARING,
        DISAPPEARED;

    }
}

