/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.vlayout.layout;

import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.alibaba.android.vlayout.LayoutManagerHelper;
import com.alibaba.android.vlayout.Range;
import com.alibaba.android.vlayout.VirtualLayoutManager;
import com.alibaba.android.vlayout.layout.BaseLayoutHelper;
import com.alibaba.android.vlayout.layout.LayoutChunkResult;

public abstract class AbstractFullFillLayoutHelper
extends BaseLayoutHelper {
    private static final String TAG = "FullFillLayoutHelper";
    protected boolean hasHeader = false;
    protected boolean hasFooter = false;
    protected boolean mLayoutWithAnchor = false;
    private LayoutManagerHelper mTempLayoutHelper;

    protected int getAllChildren(View[] toFill, RecyclerView.Recycler recycler, VirtualLayoutManager.LayoutStateWrapper layoutState, LayoutChunkResult result, LayoutManagerHelper helper) {
        View view;
        boolean layingOutInPrimaryDirection = layoutState.getItemDirection() == 1;
        int count = 0;
        int firstPos = layingOutInPrimaryDirection ? this.getRange().getLower() : this.getRange().getUpper();
        int curPos = layoutState.getCurrentPosition();
        if (layingOutInPrimaryDirection ? curPos > firstPos : curPos > firstPos) {
            Log.w((String)TAG, (String)"Please handle strange order views carefully");
        }
        while (count < toFill.length && !this.isOutOfRange(layoutState.getCurrentPosition()) && (view = this.nextView(recycler, layoutState, helper, result)) != null) {
            toFill[count] = view;
            ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
            if (layoutParams == null) {
                view.setLayoutParams(this.generateDefaultLayoutParams());
            } else if (!this.checkLayoutParams(layoutParams)) {
                view.setLayoutParams(this.generateLayoutParams(layoutParams));
            }
            ++count;
        }
        if (count > 0 && !layingOutInPrimaryDirection) {
            int s = 0;
            for (int e = count - 1; s < e; ++s, --e) {
                View temp = toFill[s];
                toFill[s] = toFill[e];
                toFill[e] = temp;
            }
        }
        return count;
    }

    @Override
    public void layoutViews(RecyclerView.Recycler recycler, RecyclerView.State state, VirtualLayoutManager.LayoutStateWrapper layoutState, LayoutChunkResult result, LayoutManagerHelper helper) {
        this.mTempLayoutHelper = helper;
        this.doLayoutView(recycler, state, layoutState, result, helper);
        this.mTempLayoutHelper = null;
    }

    protected void doLayoutView(RecyclerView.Recycler recycler, RecyclerView.State state, VirtualLayoutManager.LayoutStateWrapper layoutState, LayoutChunkResult result, LayoutManagerHelper helper) {
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
    }

    protected final void setMeasuredDimension(int measuredWidth, int measuredHeight) {
    }

    @Override
    public void checkAnchorInfo(RecyclerView.State state, VirtualLayoutManager.AnchorInfoWrapper anchorInfo, LayoutManagerHelper helper) {
        if (anchorInfo.layoutFromEnd) {
            if (!this.hasFooter) {
                anchorInfo.position = this.getRange().getUpper();
            }
        } else if (!this.hasHeader) {
            anchorInfo.position = this.getRange().getLower();
        }
        this.mLayoutWithAnchor = true;
    }

    @Override
    public void afterLayout(RecyclerView.Recycler recycler, RecyclerView.State state, int startPosition, int endPosition, int scrolled, LayoutManagerHelper helper) {
        super.afterLayout(recycler, state, startPosition, endPosition, scrolled, helper);
        this.mLayoutWithAnchor = false;
    }

    @Override
    public int computeAlignOffset(int offset, boolean isLayoutEnd, boolean useAnchor, LayoutManagerHelper helper) {
        boolean layoutInVertical;
        boolean bl = layoutInVertical = helper.getOrientation() == 1;
        if (layoutInVertical) {
            if (isLayoutEnd) {
                return this.mMarginBottom + this.mPaddingBottom;
            }
            return -this.mMarginTop - this.mPaddingTop;
        }
        if (isLayoutEnd) {
            return this.mMarginRight + this.mPaddingRight;
        }
        return -this.mMarginLeft - this.mPaddingLeft;
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return true;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.LayoutParams(-1, -2);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new ViewGroup.LayoutParams(p);
    }

    @Override
    public boolean isRecyclable(int childPos, int startIndex, int endIndex, LayoutManagerHelper helper, boolean fromStart) {
        Range<Integer> range = this.getRange();
        if (range.contains(childPos)) {
            if (this.hasHeader && childPos == this.getRange().getLower()) {
                return true;
            }
            if (this.hasFooter && childPos == this.getRange().getUpper()) {
                return true;
            }
            Range<Integer> childRange = Range.create(range.getLower() + (this.hasHeader ? 1 : 0), range.getUpper() - (this.hasFooter ? 1 : 0));
            return Range.create(startIndex, endIndex).contains(childRange);
        }
        Log.w((String)TAG, (String)"Child item not match");
        return true;
    }

    public void setHasHeader(boolean hasHeader) {
        this.hasHeader = hasHeader;
    }

    public void setHasFooter(boolean hasFooter) {
        this.hasFooter = hasFooter;
    }

    protected void calculateRect(int mainAxisSize, Rect areaRect, VirtualLayoutManager.LayoutStateWrapper layoutState, LayoutManagerHelper helper) {
        if (helper.getOrientation() == 1) {
            areaRect.left = helper.getPaddingLeft() + this.mMarginLeft + this.mPaddingLeft;
            areaRect.right = helper.getContentWidth() - helper.getPaddingRight() - this.mMarginRight - this.mPaddingRight;
            if (layoutState.getLayoutDirection() == -1) {
                areaRect.bottom = layoutState.getOffset() - (this.mLayoutWithAnchor ? this.mMarginBottom + this.mPaddingBottom : (this.hasFooter ? 0 : this.mMarginBottom + this.mPaddingBottom));
                areaRect.top = areaRect.bottom - mainAxisSize;
            } else {
                areaRect.top = layoutState.getOffset() + (this.mLayoutWithAnchor ? this.mMarginTop + this.mPaddingTop : (this.hasHeader ? 0 : this.mMarginTop + this.mPaddingTop));
                areaRect.bottom = areaRect.top + mainAxisSize;
            }
        } else {
            areaRect.top = helper.getPaddingTop() + this.mMarginTop + this.mPaddingTop;
            areaRect.bottom = helper.getContentHeight() - helper.getPaddingBottom() - this.mMarginBottom - this.mPaddingBottom;
            if (layoutState.getLayoutDirection() == -1) {
                areaRect.right = layoutState.getOffset() - (this.mLayoutWithAnchor ? this.mMarginRight + this.mPaddingRight : (this.hasFooter ? 0 : this.mMarginRight + this.mPaddingRight));
                areaRect.left = areaRect.right - mainAxisSize;
            } else {
                areaRect.left = layoutState.getOffset() + (this.mLayoutWithAnchor ? this.mMarginLeft + this.mPaddingLeft : (this.hasHeader ? 0 : this.mMarginLeft + this.mPaddingLeft));
                areaRect.right = areaRect.left + mainAxisSize;
            }
        }
    }
}

