/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.vlayout.layout;

import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.alibaba.android.vlayout.LayoutManagerHelper;
import com.alibaba.android.vlayout.OrientationHelperEx;
import com.alibaba.android.vlayout.VirtualLayoutManager;
import com.alibaba.android.vlayout.layout.AbstractFullFillLayoutHelper;
import com.alibaba.android.vlayout.layout.LayoutChunkResult;
import java.util.Arrays;

public class ColumnLayoutHelper
extends AbstractFullFillLayoutHelper {
    private View[] mEqViews;
    private View[] mViews;
    private Rect mTempArea = new Rect();
    private float[] mWeights = new float[0];

    public void setWeights(float[] weights) {
        this.mWeights = weights != null ? Arrays.copyOf(weights, weights.length) : new float[0];
    }

    @Override
    public void layoutViews(RecyclerView.Recycler recycler, RecyclerView.State state, VirtualLayoutManager.LayoutStateWrapper layoutState, LayoutChunkResult result, LayoutManagerHelper helper) {
        if (this.isOutOfRange(layoutState.getCurrentPosition())) {
            return;
        }
        boolean layoutInVertical = helper.getOrientation() == 1;
        OrientationHelperEx orientationHelper = helper.getMainOrientationHelper();
        int itemCount = this.getItemCount();
        if (this.mViews == null || this.mViews.length != itemCount) {
            this.mViews = new View[itemCount];
        }
        if (this.mEqViews == null || this.mEqViews.length != itemCount) {
            this.mEqViews = new View[itemCount];
        } else {
            Arrays.fill(this.mEqViews, null);
        }
        int count = this.getAllChildren(this.mViews, recycler, layoutState, result, helper);
        if (layoutInVertical) {
            int specialHeight;
            int resizeWidth;
            int heightSpec;
            VirtualLayoutManager.LayoutParams params;
            View view;
            int i;
            int maxVMargin = 0;
            int lastHMargin = 0;
            int totalMargin = 0;
            for (int i2 = 0; i2 < count; ++i2) {
                View view2 = this.mViews[i2];
                ViewGroup.LayoutParams layoutParams = view2.getLayoutParams();
                if (!(layoutParams instanceof RecyclerView.LayoutParams)) continue;
                RecyclerView.LayoutParams params2 = (RecyclerView.LayoutParams)layoutParams;
                params2.leftMargin = Math.max(lastHMargin, params2.leftMargin);
                totalMargin += params2.leftMargin;
                if (i2 != count - 1) {
                    lastHMargin = params2.rightMargin;
                    params2.rightMargin = 0;
                } else {
                    totalMargin += params2.rightMargin;
                }
                maxVMargin = Math.max(maxVMargin, params2.topMargin + params2.bottomMargin);
            }
            int totalWidth = helper.getContentWidth() - helper.getPaddingLeft() - helper.getPaddingRight() - this.getHorizontalMargin() - this.getHorizontalPadding();
            int availableWidth = totalWidth - totalMargin;
            int usedWidth = 0;
            int minHeight = Integer.MAX_VALUE;
            int uniformHeight = -1;
            if (!Float.isNaN(this.mAspectRatio)) {
                uniformHeight = (int)((float)totalWidth / this.mAspectRatio + 0.5f);
            }
            int eqSize = 0;
            for (i = 0; i < count; ++i) {
                view = this.mViews[i];
                params = (VirtualLayoutManager.LayoutParams)view.getLayoutParams();
                heightSpec = helper.getChildMeasureSpec(helper.getContentHeight() - helper.getPaddingTop() - helper.getPaddingBottom(), uniformHeight > 0 ? uniformHeight : params.height, true);
                if (this.mWeights != null && i < this.mWeights.length && !Float.isNaN(this.mWeights[i]) && this.mWeights[i] >= 0.0f) {
                    resizeWidth = (int)(this.mWeights[i] * 1.0f / 100.0f * (float)availableWidth + 0.5f);
                    if (!Float.isNaN(params.mAspectRatio)) {
                        specialHeight = (int)((float)resizeWidth / params.mAspectRatio + 0.5f);
                        heightSpec = View.MeasureSpec.makeMeasureSpec((int)specialHeight, (int)0x40000000);
                    }
                    helper.measureChildWithMargins(view, View.MeasureSpec.makeMeasureSpec((int)resizeWidth, (int)0x40000000), heightSpec);
                    usedWidth += resizeWidth;
                    minHeight = Math.min(minHeight, view.getMeasuredHeight());
                    continue;
                }
                this.mEqViews[eqSize++] = view;
            }
            for (i = 0; i < eqSize; ++i) {
                view = this.mEqViews[i];
                params = (VirtualLayoutManager.LayoutParams)view.getLayoutParams();
                resizeWidth = (int)((float)(availableWidth - usedWidth) * 1.0f / (float)eqSize + 0.5f);
                if (!Float.isNaN(params.mAspectRatio)) {
                    specialHeight = (int)((float)resizeWidth / params.mAspectRatio + 0.5f);
                    heightSpec = View.MeasureSpec.makeMeasureSpec((int)specialHeight, (int)0x40000000);
                } else {
                    heightSpec = helper.getChildMeasureSpec(helper.getContentHeight() - helper.getPaddingTop() - helper.getPaddingBottom(), uniformHeight > 0 ? uniformHeight : params.height, true);
                }
                helper.measureChildWithMargins(view, View.MeasureSpec.makeMeasureSpec((int)resizeWidth, (int)0x40000000), heightSpec);
                minHeight = Math.min(minHeight, view.getMeasuredHeight());
            }
            for (i = 0; i < count; ++i) {
                view = this.mViews[i];
                if (view.getMeasuredHeight() == minHeight) continue;
                helper.measureChildWithMargins(view, View.MeasureSpec.makeMeasureSpec((int)view.getMeasuredWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)minHeight, (int)0x40000000));
            }
            result.mConsumed = minHeight + maxVMargin + this.getVerticalMargin() + this.getVerticalPadding();
            this.calculateRect(minHeight + maxVMargin, this.mTempArea, layoutState, helper);
            int left = this.mTempArea.left;
            for (int i3 = 0; i3 < count; ++i3) {
                View view3 = this.mViews[i3];
                int top = this.mTempArea.top;
                int bottom = this.mTempArea.bottom;
                int right = left + orientationHelper.getDecoratedMeasurementInOther(view3);
                this.layoutChildWithMargin(view3, left, top, right, bottom, helper);
                left = right;
            }
        }
        Arrays.fill(this.mViews, null);
        Arrays.fill(this.mEqViews, null);
    }

    @Override
    public void checkAnchorInfo(RecyclerView.State state, VirtualLayoutManager.AnchorInfoWrapper anchorInfo, LayoutManagerHelper helper) {
        anchorInfo.position = anchorInfo.layoutFromEnd ? this.getRange().getUpper().intValue() : this.getRange().getLower().intValue();
    }
}

