/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.vlayout.layout;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Rect;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import com.alibaba.android.vlayout.LayoutManagerHelper;
import com.alibaba.android.vlayout.OrientationHelperEx;
import com.alibaba.android.vlayout.VirtualLayoutManager;
import com.alibaba.android.vlayout.layout.FixAreaLayoutHelper;
import com.alibaba.android.vlayout.layout.LayoutChunkResult;

public class FloatLayoutHelper
extends FixAreaLayoutHelper {
    private static final String TAG = "FloatLayoutHelper";
    private int mTransitionX = 0;
    private int mTransitionY = 0;
    private boolean dragEnable = true;
    private int mZIndex = 1;
    private int mPos = -1;
    protected View mFixView = null;
    protected boolean mDoNormalHandle = false;
    private int mX = 0;
    private int mY = 0;
    private int mAlignType = 0;
    private final View.OnTouchListener touchDragListener = new View.OnTouchListener(){
        private boolean isDrag;
        private int mTouchSlop;
        private int lastPosX;
        private int lastPosY;
        private int parentViewHeight;
        private int parentViewWidth;
        private int leftMargin;
        private int topMargin;
        private int rightMargin;
        private int bottomMargin;
        private final Rect parentLoction = new Rect();

        public boolean onTouch(View v, MotionEvent event) {
            if (this.mTouchSlop == 0) {
                ViewConfiguration configuration = ViewConfiguration.get((Context)v.getContext());
                this.mTouchSlop = configuration.getScaledTouchSlop();
                this.parentViewHeight = ((View)v.getParent()).getHeight();
                this.parentViewWidth = ((View)v.getParent()).getWidth();
                ((View)v.getParent()).getGlobalVisibleRect(this.parentLoction);
                ViewGroup.LayoutParams layoutParams = v.getLayoutParams();
                if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
                    ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)layoutParams;
                    this.leftMargin = params.leftMargin;
                    this.topMargin = params.topMargin;
                    this.rightMargin = params.rightMargin;
                    this.bottomMargin = params.bottomMargin;
                }
            }
            int action = event.getAction();
            switch (action) {
                case 0: {
                    this.isDrag = false;
                    v.getParent().requestDisallowInterceptTouchEvent(true);
                    this.lastPosX = (int)event.getX();
                    this.lastPosY = (int)event.getY();
                    break;
                }
                case 2: {
                    if (Math.abs(event.getX() - (float)this.lastPosX) > (float)this.mTouchSlop || Math.abs(event.getY() - (float)this.lastPosY) > (float)this.mTouchSlop) {
                        this.isDrag = true;
                    }
                    if (!this.isDrag) break;
                    int posX = (int)event.getRawX();
                    int posY = (int)event.getRawY();
                    int rParentX = posX - this.parentLoction.left;
                    int rParentY = posY - this.parentLoction.top;
                    int width = v.getWidth();
                    int height = v.getHeight();
                    int translateY = rParentY - height / 2;
                    int translateX = rParentX - width / 2;
                    int curTranslateX = translateX - v.getLeft() - this.leftMargin - FloatLayoutHelper.this.mAdjuster.left;
                    v.setTranslationX((float)curTranslateX);
                    int curTranslateY = translateY - v.getTop() - this.topMargin;
                    if (curTranslateY + v.getHeight() + v.getTop() + this.bottomMargin > this.parentViewHeight) {
                        curTranslateY = this.parentViewHeight - v.getHeight() - v.getTop() - this.bottomMargin;
                    }
                    if (curTranslateY + v.getTop() - this.topMargin < 0) {
                        curTranslateY = -v.getTop() + this.topMargin;
                    }
                    v.setTranslationY((float)curTranslateY);
                    break;
                }
                case 1: 
                case 3: {
                    this.doPullOverAnimation(v);
                    v.getParent().requestDisallowInterceptTouchEvent(false);
                    v.setPressed(false);
                }
            }
            return this.isDrag;
        }

        private void doPullOverAnimation(View v) {
            ObjectAnimator animator;
            if (v.getTranslationX() + (float)(v.getWidth() / 2) + (float)v.getLeft() > (float)(this.parentViewWidth / 2)) {
                animator = ObjectAnimator.ofFloat((Object)v, (String)"translationX", (float[])new float[]{v.getTranslationX(), this.parentViewWidth - v.getWidth() - v.getLeft() - this.rightMargin - FloatLayoutHelper.this.mAdjuster.right});
                FloatLayoutHelper.this.mTransitionX = this.parentViewWidth - v.getWidth() - v.getLeft() - this.rightMargin - FloatLayoutHelper.this.mAdjuster.right;
            } else {
                animator = ObjectAnimator.ofFloat((Object)v, (String)"translationX", (float[])new float[]{v.getTranslationX(), -v.getLeft() + this.leftMargin + FloatLayoutHelper.this.mAdjuster.left});
                FloatLayoutHelper.this.mTransitionX = -v.getLeft() + this.leftMargin + FloatLayoutHelper.this.mAdjuster.left;
            }
            FloatLayoutHelper.this.mTransitionY = (int)v.getTranslationY();
            animator.setDuration(200L);
            animator.start();
        }
    };

    public void setDefaultLocation(int x, int y) {
        this.mX = x;
        this.mY = y;
    }

    public void setX(int x) {
        this.mX = x;
    }

    public void setY(int y) {
        this.mY = y;
    }

    public void setAlignType(int alignType) {
        this.mAlignType = alignType;
    }

    @Override
    public void setItemCount(int itemCount) {
        if (itemCount > 0) {
            super.setItemCount(1);
        } else {
            super.setItemCount(0);
        }
    }

    @Override
    public void onRangeChange(int start, int end) {
        this.mPos = start;
    }

    @Override
    public void layoutViews(RecyclerView.Recycler recycler, RecyclerView.State state, VirtualLayoutManager.LayoutStateWrapper layoutState, LayoutChunkResult result, LayoutManagerHelper helper) {
        if (this.isOutOfRange(layoutState.getCurrentPosition())) {
            return;
        }
        View view = this.mFixView;
        if (view == null) {
            view = layoutState.next(recycler);
        } else {
            layoutState.skipCurrentPosition();
        }
        if (view == null) {
            result.mFinished = true;
            return;
        }
        helper.getChildViewHolder(view).setIsRecyclable(false);
        this.mDoNormalHandle = state.isPreLayout();
        if (this.mDoNormalHandle) {
            helper.addChildView(layoutState, view);
        }
        this.mFixView = view;
        this.mFixView.setClickable(true);
        this.doMeasureAndLayout(view, helper);
        result.mConsumed = 0;
        result.mIgnoreConsumed = true;
        this.handleStateOnResult(result, view);
    }

    @Override
    public void setBgColor(int bgColor) {
    }

    @Override
    public boolean requireLayoutView() {
        return false;
    }

    @Override
    public void beforeLayout(RecyclerView.Recycler recycler, RecyclerView.State state, LayoutManagerHelper helper) {
        super.beforeLayout(recycler, state, helper);
        if (this.mFixView != null && helper.isViewHolderUpdated(this.mFixView)) {
            helper.removeChildView(this.mFixView);
            helper.recycleView(this.mFixView);
            this.mFixView.setOnTouchListener(null);
            this.mFixView = null;
        }
        this.mDoNormalHandle = false;
    }

    @Override
    public void afterLayout(RecyclerView.Recycler recycler, RecyclerView.State state, int startPosition, int endPosition, int scrolled, LayoutManagerHelper helper) {
        super.afterLayout(recycler, state, startPosition, endPosition, scrolled, helper);
        if (this.mPos < 0) {
            return;
        }
        if (this.mDoNormalHandle) {
            this.mFixView = null;
            return;
        }
        if (this.shouldBeDraw(startPosition, endPosition)) {
            if (this.mFixView != null) {
                if (this.mFixView.getParent() == null) {
                    helper.addFixedView(this.mFixView);
                    if (this.dragEnable) {
                        this.mFixView.setOnTouchListener(this.touchDragListener);
                    }
                    this.mFixView.setTranslationX((float)this.mTransitionX);
                    this.mFixView.setTranslationY((float)this.mTransitionY);
                } else {
                    helper.showView(this.mFixView);
                    if (this.dragEnable) {
                        this.mFixView.setOnTouchListener(this.touchDragListener);
                    }
                    helper.addFixedView(this.mFixView);
                }
            } else {
                this.mFixView = recycler.getViewForPosition(this.mPos);
                helper.getChildViewHolder(this.mFixView).setIsRecyclable(false);
                this.doMeasureAndLayout(this.mFixView, helper);
                helper.addFixedView(this.mFixView);
                this.mFixView.setTranslationX((float)this.mTransitionX);
                this.mFixView.setTranslationY((float)this.mTransitionY);
                if (this.dragEnable) {
                    this.mFixView.setOnTouchListener(this.touchDragListener);
                }
            }
        }
    }

    protected boolean shouldBeDraw(int startPosition, int endPosition) {
        return true;
    }

    @Override
    @Nullable
    public View getFixedView() {
        return this.mFixView;
    }

    @Override
    public void onClear(LayoutManagerHelper helper) {
        super.onClear(helper);
        if (this.mFixView != null) {
            this.mFixView.setOnTouchListener(null);
            helper.removeChildView(this.mFixView);
            helper.recycleView(this.mFixView);
            this.mFixView = null;
        }
    }

    private void doMeasureAndLayout(View view, LayoutManagerHelper helper) {
        int bottom;
        int left;
        int right;
        int top;
        int heightSpec;
        int widthSpec;
        boolean layoutInVertical;
        if (view == null || helper == null) {
            return;
        }
        VirtualLayoutManager.LayoutParams params = (VirtualLayoutManager.LayoutParams)view.getLayoutParams();
        boolean bl = layoutInVertical = helper.getOrientation() == 1;
        if (layoutInVertical) {
            widthSpec = helper.getChildMeasureSpec(helper.getContentWidth() - helper.getPaddingLeft() - helper.getPaddingRight(), params.width, !layoutInVertical);
            heightSpec = !Float.isNaN(params.mAspectRatio) && params.mAspectRatio > 0.0f ? helper.getChildMeasureSpec(helper.getContentHeight() - helper.getPaddingTop() - helper.getPaddingBottom(), (int)((float)View.MeasureSpec.getSize((int)widthSpec) / params.mAspectRatio + 0.5f), layoutInVertical) : (!Float.isNaN(this.mAspectRatio) && this.mAspectRatio > 0.0f ? helper.getChildMeasureSpec(helper.getContentHeight() - helper.getPaddingTop() - helper.getPaddingBottom(), (int)((float)View.MeasureSpec.getSize((int)widthSpec) / this.mAspectRatio + 0.5f), layoutInVertical) : helper.getChildMeasureSpec(helper.getContentHeight() - helper.getPaddingTop() - helper.getPaddingBottom(), params.height, layoutInVertical));
            helper.measureChild(view, widthSpec, heightSpec);
        } else {
            heightSpec = helper.getChildMeasureSpec(helper.getContentHeight() - helper.getPaddingTop() - helper.getPaddingBottom(), params.height, layoutInVertical);
            widthSpec = !Float.isNaN(params.mAspectRatio) && params.mAspectRatio > 0.0f ? helper.getChildMeasureSpec(helper.getContentWidth() - helper.getPaddingLeft() - helper.getPaddingRight(), (int)((float)View.MeasureSpec.getSize((int)heightSpec) * params.mAspectRatio + 0.5f), !layoutInVertical) : (!Float.isNaN(this.mAspectRatio) && this.mAspectRatio > 0.0f ? helper.getChildMeasureSpec(helper.getContentWidth() - helper.getPaddingLeft() - helper.getPaddingRight(), (int)((float)View.MeasureSpec.getSize((int)heightSpec) * this.mAspectRatio + 0.5f), !layoutInVertical) : helper.getChildMeasureSpec(helper.getContentWidth() - helper.getPaddingLeft() - helper.getPaddingRight(), params.width, !layoutInVertical));
            helper.measureChild(view, widthSpec, heightSpec);
        }
        OrientationHelperEx orientationHelper = helper.getMainOrientationHelper();
        if (this.mAlignType == 1) {
            top = helper.getPaddingTop() + this.mY + this.mAdjuster.top;
            right = helper.getContentWidth() - helper.getPaddingRight() - this.mX - this.mAdjuster.right;
            left = right - params.leftMargin - params.rightMargin - view.getMeasuredWidth();
            bottom = top + params.topMargin + params.bottomMargin + view.getMeasuredHeight();
        } else if (this.mAlignType == 2) {
            left = helper.getPaddingLeft() + this.mX + this.mAdjuster.left;
            bottom = helper.getContentHeight() - helper.getPaddingBottom() - this.mY - this.mAdjuster.bottom;
            right = left + params.leftMargin + params.rightMargin + view.getMeasuredWidth();
            top = bottom - view.getMeasuredHeight() - params.topMargin - params.bottomMargin;
        } else if (this.mAlignType == 3) {
            right = helper.getContentWidth() - helper.getPaddingRight() - this.mX - this.mAdjuster.right;
            bottom = helper.getContentHeight() - helper.getPaddingBottom() - this.mY - this.mAdjuster.bottom;
            left = right - (layoutInVertical ? orientationHelper.getDecoratedMeasurementInOther(view) : orientationHelper.getDecoratedMeasurement(view));
            top = bottom - (layoutInVertical ? orientationHelper.getDecoratedMeasurement(view) : orientationHelper.getDecoratedMeasurementInOther(view));
        } else {
            left = helper.getPaddingLeft() + this.mX + this.mAdjuster.left;
            top = helper.getPaddingTop() + this.mY + this.mAdjuster.top;
            right = left + (layoutInVertical ? orientationHelper.getDecoratedMeasurementInOther(view) : orientationHelper.getDecoratedMeasurement(view));
            bottom = top + (layoutInVertical ? orientationHelper.getDecoratedMeasurement(view) : orientationHelper.getDecoratedMeasurementInOther(view));
        }
        if (left < helper.getPaddingLeft() + this.mAdjuster.left) {
            left = helper.getPaddingLeft() + this.mAdjuster.left;
            right = left + (layoutInVertical ? orientationHelper.getDecoratedMeasurementInOther(view) : orientationHelper.getDecoratedMeasurement(view));
        }
        if (right > helper.getContentWidth() - helper.getPaddingRight() - this.mAdjuster.right) {
            right = helper.getContentWidth() - helper.getPaddingRight() - this.mAdjuster.right;
            left = right - params.leftMargin - params.rightMargin - view.getMeasuredWidth();
        }
        if (top < helper.getPaddingTop() + this.mAdjuster.top) {
            top = helper.getPaddingTop() + this.mAdjuster.top;
            bottom = top + (layoutInVertical ? orientationHelper.getDecoratedMeasurement(view) : orientationHelper.getDecoratedMeasurementInOther(view));
        }
        if (bottom > helper.getContentHeight() - helper.getPaddingBottom() - this.mAdjuster.bottom) {
            bottom = helper.getContentHeight() - helper.getPaddingBottom() - this.mAdjuster.bottom;
            top = bottom - (layoutInVertical ? orientationHelper.getDecoratedMeasurement(view) : orientationHelper.getDecoratedMeasurementInOther(view));
        }
        this.layoutChildWithMargin(view, left, top, right, bottom, helper);
    }

    public void setDragEnable(boolean dragEnable) {
        this.dragEnable = dragEnable;
        if (null != this.mFixView) {
            this.mFixView.setOnTouchListener(dragEnable ? this.touchDragListener : null);
        }
    }
}

