/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.vlayout.layout;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.View;
import android.widget.TextView;
import com.alibaba.android.vlayout.LayoutManagerHelper;
import com.alibaba.android.vlayout.OrientationHelperEx;
import com.alibaba.android.vlayout.VirtualLayoutManager;
import com.alibaba.android.vlayout.layout.BaseLayoutHelper;
import com.alibaba.android.vlayout.layout.LayoutChunkResult;
import java.util.Arrays;

public class GridLayoutHelper
extends BaseLayoutHelper {
    private static final String TAG = "GridLayoutHelper";
    private static boolean DEBUG = false;
    private int mSpanCount = 4;
    private int mSizePerSpan = 0;
    private int mTotalSize = 0;
    private boolean mIsAutoExpand = true;
    private boolean mIgnoreExtra = false;
    @NonNull
    private SpanSizeLookup mSpanSizeLookup = new DefaultSpanSizeLookup();
    private int mVGap = 0;
    private int mHGap = 0;
    private float[] mWeights = new float[0];
    private View[] mSet;
    private int[] mSpanIndices;
    private int[] mSpanCols;
    private static final int MAIN_DIR_SPEC = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
    private boolean mLayoutWithAnchor = false;

    public GridLayoutHelper(int spanCount) {
        this(spanCount, -1, -1);
    }

    public GridLayoutHelper(int spanCount, int itemCount) {
        this(spanCount, itemCount, 0);
    }

    public GridLayoutHelper(int spanCount, int itemCount, int gap) {
        this(spanCount, itemCount, gap, gap);
    }

    public GridLayoutHelper(int spanCount, int itemCount, int vGap, int hGap) {
        this.setSpanCount(spanCount);
        this.mSpanSizeLookup.setSpanIndexCacheEnabled(true);
        this.setItemCount(itemCount);
        this.setVGap(vGap);
        this.setHGap(hGap);
    }

    public void setWeights(float[] weights) {
        this.mWeights = weights != null ? Arrays.copyOf(weights, weights.length) : new float[0];
    }

    public void setSpanSizeLookup(SpanSizeLookup spanSizeLookup) {
        if (spanSizeLookup != null) {
            spanSizeLookup.setStartPosition(this.mSpanSizeLookup.getStartPosition());
            this.mSpanSizeLookup = spanSizeLookup;
        }
    }

    public void setAutoExpand(boolean isAutoExpand) {
        this.mIsAutoExpand = isAutoExpand;
    }

    public void setIgnoreExtra(boolean ignoreExtra) {
        this.mIgnoreExtra = ignoreExtra;
    }

    public void setSpanCount(int spanCount) {
        if (spanCount == this.mSpanCount) {
            return;
        }
        if (spanCount < 1) {
            throw new IllegalArgumentException("Span count should be at least 1. Provided " + spanCount);
        }
        this.mSpanCount = spanCount;
        this.mSpanSizeLookup.invalidateSpanIndexCache();
        this.ensureSpanCount();
    }

    public int getVGap() {
        return this.mVGap;
    }

    public int getHGap() {
        return this.mHGap;
    }

    public int getSpanCount() {
        return this.mSpanCount;
    }

    @Override
    public void onRangeChange(int start, int end) {
        this.mSpanSizeLookup.setStartPosition(start);
        this.mSpanSizeLookup.invalidateSpanIndexCache();
    }

    public void setGap(int gap) {
        this.setVGap(gap);
        this.setHGap(gap);
    }

    public void setVGap(int vGap) {
        if (vGap < 0) {
            vGap = 0;
        }
        this.mVGap = vGap;
    }

    public void setHGap(int hGap) {
        if (hGap < 0) {
            hGap = 0;
        }
        this.mHGap = hGap;
    }

    @Override
    public void layoutViews(RecyclerView.Recycler recycler, RecyclerView.State state, VirtualLayoutManager.LayoutStateWrapper layoutState, LayoutChunkResult result, LayoutManagerHelper helper) {
        boolean layoutStart;
        int spanSize;
        int count;
        boolean layoutInVertical;
        if (this.isOutOfRange(layoutState.getCurrentPosition())) {
            return;
        }
        boolean isStartLine = false;
        boolean isEndLine = false;
        int currentPosition = layoutState.getCurrentPosition();
        boolean isOverLapMargin = helper.isEnableMarginOverLap();
        int itemDirection = layoutState.getItemDirection();
        boolean layingOutInPrimaryDirection = itemDirection == 1;
        OrientationHelperEx orientationHelper = helper.getMainOrientationHelper();
        boolean bl = layoutInVertical = helper.getOrientation() == 1;
        if (layoutInVertical) {
            this.mTotalSize = helper.getContentWidth() - helper.getPaddingRight() - helper.getPaddingLeft() - this.getHorizontalMargin() - this.getHorizontalPadding();
            this.mSizePerSpan = (int)((float)(this.mTotalSize - (this.mSpanCount - 1) * this.mHGap) * 1.0f / (float)this.mSpanCount + 0.5f);
        } else {
            this.mTotalSize = helper.getContentHeight() - helper.getPaddingBottom() - helper.getPaddingTop() - this.getVerticalMargin() - this.getVerticalPadding();
            this.mSizePerSpan = (int)((float)(this.mTotalSize - (this.mSpanCount - 1) * this.mVGap) * 1.0f / (float)this.mSpanCount + 0.5f);
        }
        int consumedSpanCount = 0;
        int remainingSpan = this.mSpanCount;
        this.ensureSpanCount();
        if (!layingOutInPrimaryDirection) {
            int itemSpanIndex = this.getSpanIndex(recycler, state, layoutState.getCurrentPosition());
            int itemSpanSize = this.getSpanSize(recycler, state, layoutState.getCurrentPosition());
            remainingSpan = itemSpanIndex + itemSpanSize;
            if (itemSpanIndex != this.mSpanCount - 1) {
                int index = layoutState.getCurrentPosition();
                int revRemainingSpan = this.mSpanCount - remainingSpan;
                for (count = 0; count < this.mSpanCount && revRemainingSpan > 0 && !this.isOutOfRange(index -= itemDirection); ++count) {
                    spanSize = this.getSpanSize(recycler, state, index);
                    if (spanSize > this.mSpanCount) {
                        throw new IllegalArgumentException("Item at position " + index + " requires " + spanSize + " spans but GridLayoutManager has only " + this.mSpanCount + " spans.");
                    }
                    View view = layoutState.retrieve(recycler, index);
                    if (view == null) break;
                    if (!isStartLine) {
                        boolean bl2 = helper.getReverseLayout() ? index == this.getRange().getUpper() : (isStartLine = index == this.getRange().getLower());
                    }
                    if (!isEndLine) {
                        boolean bl3 = helper.getReverseLayout() ? index == this.getRange().getLower() : (isEndLine = index == this.getRange().getUpper());
                    }
                    if ((revRemainingSpan -= spanSize) < 0) break;
                    consumedSpanCount += spanSize;
                    this.mSet[count] = view;
                }
                if (count > 0) {
                    int s = 0;
                    for (int e = count - 1; s < e; ++s, --e) {
                        View temp = this.mSet[s];
                        this.mSet[s] = this.mSet[e];
                        this.mSet[e] = temp;
                    }
                }
            }
        }
        while (count < this.mSpanCount && layoutState.hasMore(state) && remainingSpan > 0) {
            View view;
            int pos = layoutState.getCurrentPosition();
            if (this.isOutOfRange(pos)) {
                if (!DEBUG) break;
                Log.d((String)TAG, (String)("pos [" + pos + "] is out of range"));
                break;
            }
            int spanSize2 = this.getSpanSize(recycler, state, pos);
            if (spanSize2 > this.mSpanCount) {
                throw new IllegalArgumentException("Item at position " + pos + " requires " + spanSize2 + " spans but GridLayoutManager has only " + this.mSpanCount + " spans.");
            }
            if ((remainingSpan -= spanSize2) < 0 || (view = layoutState.next(recycler)) == null) break;
            if (!isStartLine) {
                boolean bl4 = helper.getReverseLayout() ? pos == this.getRange().getUpper() : (isStartLine = pos == this.getRange().getLower());
            }
            if (!isEndLine) {
                isEndLine = helper.getReverseLayout() ? pos == this.getRange().getLower() : pos == this.getRange().getUpper();
            }
            consumedSpanCount += spanSize2;
            this.mSet[count] = view;
            ++count;
        }
        if (count == 0) {
            return;
        }
        int maxSize = 0;
        this.assignSpans(recycler, state, count, consumedSpanCount, layingOutInPrimaryDirection, helper);
        if (remainingSpan > 0 && count == consumedSpanCount && this.mIsAutoExpand) {
            this.mSizePerSpan = layoutInVertical ? (this.mTotalSize - (count - 1) * this.mHGap) / count : (this.mTotalSize - (count - 1) * this.mVGap) / count;
        } else if (!layingOutInPrimaryDirection && remainingSpan == 0 && count == consumedSpanCount && this.mIsAutoExpand) {
            this.mSizePerSpan = layoutInVertical ? (this.mTotalSize - (count - 1) * this.mHGap) / count : (this.mTotalSize - (count - 1) * this.mVGap) / count;
        }
        boolean weighted = false;
        if (this.mWeights != null && this.mWeights.length > 0) {
            weighted = true;
            int totalSpace = layoutInVertical ? this.mTotalSize - (count - 1) * this.mHGap : this.mTotalSize - (count - 1) * this.mVGap;
            int eqCnt = 0;
            int remainingSpace = totalSpace;
            int colCnt = remainingSpan > 0 && this.mIsAutoExpand ? count : this.mSpanCount;
            for (int i = 0; i < colCnt; ++i) {
                if (i < this.mWeights.length && !Float.isNaN(this.mWeights[i]) && this.mWeights[i] >= 0.0f) {
                    float weight = this.mWeights[i];
                    this.mSpanCols[i] = (int)(weight * 1.0f / 100.0f * (float)totalSpace + 0.5f);
                    remainingSpace -= this.mSpanCols[i];
                    continue;
                }
                ++eqCnt;
                this.mSpanCols[i] = -1;
            }
            if (eqCnt > 0) {
                int eqLength = remainingSpace / eqCnt;
                for (int i = 0; i < colCnt; ++i) {
                    if (this.mSpanCols[i] >= 0) continue;
                    this.mSpanCols[i] = eqLength;
                }
            }
        }
        for (int i = 0; i < count; ++i) {
            int spec;
            View view = this.mSet[i];
            helper.addChildView(layoutState, view, layingOutInPrimaryDirection ? -1 : 0);
            spanSize = this.getSpanSize(recycler, state, helper.getPosition(view));
            if (weighted) {
                int index = this.mSpanIndices[i];
                int spanLength = 0;
                for (int j = 0; j < spanSize; ++j) {
                    spanLength += this.mSpanCols[j + index];
                }
                spec = View.MeasureSpec.makeMeasureSpec((int)Math.max(0, spanLength), (int)0x40000000);
            } else {
                spec = View.MeasureSpec.makeMeasureSpec((int)(this.mSizePerSpan * spanSize + Math.max(0, spanSize - 1) * (layoutInVertical ? this.mHGap : this.mVGap)), (int)0x40000000);
            }
            VirtualLayoutManager.LayoutParams lp = (VirtualLayoutManager.LayoutParams)view.getLayoutParams();
            if (helper.getOrientation() == 1) {
                helper.measureChildWithMargins(view, spec, this.getMainDirSpec(lp.height, this.mTotalSize, View.MeasureSpec.getSize((int)spec), lp.mAspectRatio));
            } else {
                helper.measureChildWithMargins(view, this.getMainDirSpec(lp.width, this.mTotalSize, View.MeasureSpec.getSize((int)spec), lp.mAspectRatio), View.MeasureSpec.getSize((int)spec));
            }
            int size = orientationHelper.getDecoratedMeasurement(view);
            if (size <= maxSize) continue;
            maxSize = size;
        }
        int maxMeasureSpec = this.getMainDirSpec(maxSize, this.mTotalSize, 0, Float.NaN);
        for (int i = 0; i < count; ++i) {
            int spec;
            View view = this.mSet[i];
            if (orientationHelper.getDecoratedMeasurement(view) == maxSize) continue;
            int spanSize3 = this.getSpanSize(recycler, state, helper.getPosition(view));
            if (weighted) {
                int index = this.mSpanIndices[i];
                int spanLength = 0;
                for (int j = 0; j < spanSize3; ++j) {
                    spanLength += this.mSpanCols[j + index];
                }
                spec = View.MeasureSpec.makeMeasureSpec((int)Math.max(0, spanLength), (int)0x40000000);
            } else {
                spec = View.MeasureSpec.makeMeasureSpec((int)(this.mSizePerSpan * spanSize3 + Math.max(0, spanSize3 - 1) * (layoutInVertical ? this.mHGap : this.mVGap)), (int)0x40000000);
            }
            if (helper.getOrientation() == 1) {
                helper.measureChildWithMargins(view, spec, maxMeasureSpec);
                continue;
            }
            helper.measureChildWithMargins(view, maxMeasureSpec, spec);
        }
        int startSpace = 0;
        int endSpace = 0;
        if (isStartLine) {
            startSpace = this.computeStartSpace(helper, layoutInVertical, !helper.getReverseLayout(), isOverLapMargin);
        }
        if (isEndLine) {
            endSpace = this.computeEndSpace(helper, layoutInVertical, !helper.getReverseLayout(), isOverLapMargin);
        }
        result.mConsumed = maxSize + startSpace + endSpace;
        boolean bl5 = layoutStart = layoutState.getLayoutDirection() == -1;
        if (!(this.mLayoutWithAnchor || isEndLine && layoutStart || isStartLine && !layoutStart)) {
            result.mConsumed = result.mConsumed + (layoutInVertical ? this.mVGap : this.mHGap);
        }
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        if (layoutInVertical) {
            if (layoutState.getLayoutDirection() == -1) {
                bottom = layoutState.getOffset() - endSpace - (this.mLayoutWithAnchor || isEndLine ? 0 : this.mVGap);
                top = bottom - maxSize;
            } else {
                top = layoutState.getOffset() + startSpace + (this.mLayoutWithAnchor || isStartLine ? 0 : this.mVGap);
                bottom = top + maxSize;
            }
        } else if (layoutState.getLayoutDirection() == -1) {
            right = layoutState.getOffset() - endSpace - (this.mLayoutWithAnchor || isEndLine ? 0 : this.mHGap);
            left = right - maxSize;
        } else {
            left = layoutState.getOffset() + startSpace + (this.mLayoutWithAnchor || isStartLine ? 0 : this.mHGap);
            right = left + maxSize;
        }
        for (int i = 0; i < count; ++i) {
            int j;
            View view = this.mSet[i];
            int index = this.mSpanIndices[i];
            VirtualLayoutManager.LayoutParams params = (VirtualLayoutManager.LayoutParams)view.getLayoutParams();
            if (layoutInVertical) {
                if (weighted) {
                    left = helper.getPaddingLeft() + this.mMarginLeft + this.mPaddingLeft;
                    for (j = 0; j < index; ++j) {
                        left += this.mSpanCols[j] + this.mHGap;
                    }
                } else {
                    left = helper.getPaddingLeft() + this.mMarginLeft + this.mPaddingLeft + this.mSizePerSpan * index + index * this.mHGap;
                }
                right = left + orientationHelper.getDecoratedMeasurementInOther(view);
            } else {
                if (weighted) {
                    top = helper.getPaddingTop() + this.mMarginTop + this.mPaddingTop;
                    for (j = 0; j < index; ++j) {
                        top += this.mSpanCols[j] + this.mVGap;
                    }
                } else {
                    top = helper.getPaddingTop() + this.mMarginTop + this.mPaddingTop + this.mSizePerSpan * index + index * this.mVGap;
                }
                bottom = top + orientationHelper.getDecoratedMeasurementInOther(view);
            }
            if (DEBUG) {
                Log.d((String)TAG, (String)("layout item in position: " + params.getViewPosition() + " with text " + ((TextView)view).getText() + " with SpanIndex: " + index + " into (" + left + ", " + top + ", " + right + ", " + bottom + " )"));
            }
            this.layoutChildWithMargin(view, left, top, right, bottom, helper);
            if (params.isItemRemoved() || params.isItemChanged()) {
                result.mIgnoreConsumed = true;
            }
            result.mFocusable |= view.isFocusable();
        }
        this.mLayoutWithAnchor = false;
        Arrays.fill(this.mSet, null);
        Arrays.fill(this.mSpanIndices, 0);
        Arrays.fill(this.mSpanCols, 0);
    }

    @Override
    public int computeAlignOffset(int offset, boolean isLayoutEnd, boolean useAnchor, LayoutManagerHelper helper) {
        boolean layoutInVertical;
        boolean bl = layoutInVertical = helper.getOrientation() == 1;
        if (isLayoutEnd) {
            if (offset == this.getItemCount() - 1) {
                return layoutInVertical ? this.mMarginBottom + this.mPaddingBottom : this.mMarginRight + this.mPaddingRight;
            }
        } else if (offset == 0) {
            return layoutInVertical ? -this.mMarginTop - this.mPaddingTop : -this.mMarginLeft - this.mPaddingLeft;
        }
        return super.computeAlignOffset(offset, isLayoutEnd, useAnchor, helper);
    }

    @Override
    public void onClear(LayoutManagerHelper helper) {
        super.onClear(helper);
        this.mSpanSizeLookup.invalidateSpanIndexCache();
    }

    @Override
    public void onItemsChanged(LayoutManagerHelper helper) {
        super.onItemsChanged(helper);
        this.mSpanSizeLookup.invalidateSpanIndexCache();
    }

    private int getMainDirSpec(int dim, int otherSize, int viewSize, float viewAspectRatio) {
        if (!Float.isNaN(viewAspectRatio) && viewAspectRatio > 0.0f && viewSize > 0) {
            return View.MeasureSpec.makeMeasureSpec((int)((int)((float)viewSize / viewAspectRatio + 0.5f)), (int)0x40000000);
        }
        if (!Float.isNaN(this.mAspectRatio) && this.mAspectRatio > 0.0f) {
            return View.MeasureSpec.makeMeasureSpec((int)((int)((float)otherSize / this.mAspectRatio + 0.5f)), (int)0x40000000);
        }
        if (dim < 0) {
            return MAIN_DIR_SPEC;
        }
        return View.MeasureSpec.makeMeasureSpec((int)dim, (int)0x40000000);
    }

    private void ensureSpanCount() {
        if (this.mSet == null || this.mSet.length != this.mSpanCount) {
            this.mSet = new View[this.mSpanCount];
        }
        if (this.mSpanIndices == null || this.mSpanIndices.length != this.mSpanCount) {
            this.mSpanIndices = new int[this.mSpanCount];
        }
        if (this.mSpanCols == null || this.mSpanCols.length != this.mSpanCount) {
            this.mSpanCols = new int[this.mSpanCount];
        }
    }

    @Override
    public void checkAnchorInfo(RecyclerView.State state, VirtualLayoutManager.AnchorInfoWrapper anchorInfo, LayoutManagerHelper helper) {
        if (state.getItemCount() > 0 && !state.isPreLayout()) {
            int span = this.mSpanSizeLookup.getCachedSpanIndex(anchorInfo.position, this.mSpanCount);
            if (anchorInfo.layoutFromEnd) {
                while (span < this.mSpanCount - 1 && anchorInfo.position < this.getRange().getUpper()) {
                    ++anchorInfo.position;
                    span = this.mSpanSizeLookup.getCachedSpanIndex(anchorInfo.position, this.mSpanCount);
                }
            } else {
                while (span > 0 && anchorInfo.position > 0) {
                    --anchorInfo.position;
                    span = this.mSpanSizeLookup.getCachedSpanIndex(anchorInfo.position, this.mSpanCount);
                }
            }
            this.mLayoutWithAnchor = true;
        }
    }

    private int getSpanIndex(RecyclerView.Recycler recycler, RecyclerView.State state, int pos) {
        if (!state.isPreLayout()) {
            return this.mSpanSizeLookup.getCachedSpanIndex(pos, this.mSpanCount);
        }
        int adapterPosition = recycler.convertPreLayoutPositionToPostLayout(pos);
        if (adapterPosition == -1) {
            return 0;
        }
        return this.mSpanSizeLookup.getCachedSpanIndex(adapterPosition, this.mSpanCount);
    }

    private int getSpanSize(RecyclerView.Recycler recycler, RecyclerView.State state, int pos) {
        if (!state.isPreLayout()) {
            return this.mSpanSizeLookup.getSpanSize(pos);
        }
        int adapterPosition = recycler.convertPreLayoutPositionToPostLayout(pos);
        if (adapterPosition == -1) {
            return 0;
        }
        return this.mSpanSizeLookup.getSpanSize(adapterPosition);
    }

    private void assignSpans(RecyclerView.Recycler recycler, RecyclerView.State state, int count, int consumedSpanCount, boolean layingOutInPrimaryDirection, LayoutManagerHelper helper) {
        int spanDiff;
        int span;
        int diff;
        int end;
        int start;
        if (layingOutInPrimaryDirection) {
            start = 0;
            end = count;
            diff = 1;
        } else {
            start = count - 1;
            end = -1;
            diff = -1;
        }
        if (helper.getOrientation() == 1 && helper.isDoLayoutRTL()) {
            span = consumedSpanCount - 1;
            spanDiff = -1;
        } else {
            span = 0;
            spanDiff = 1;
        }
        for (int i = start; i != end; i += diff) {
            View view = this.mSet[i];
            int spanSize = this.getSpanSize(recycler, state, helper.getPosition(view));
            this.mSpanIndices[i] = spanDiff == -1 && spanSize > 1 ? span - (spanSize - 1) : span;
            span += spanDiff * spanSize;
        }
    }

    public static abstract class SpanSizeLookup {
        final SparseIntArray mSpanIndexCache = new SparseIntArray();
        private boolean mCacheSpanIndices = false;
        int mStartPosition = 0;

        public abstract int getSpanSize(int var1);

        public void setSpanIndexCacheEnabled(boolean cacheSpanIndices) {
            this.mCacheSpanIndices = cacheSpanIndices;
        }

        public void setStartPosition(int startPosition) {
            this.mStartPosition = startPosition;
        }

        public int getStartPosition() {
            return this.mStartPosition;
        }

        public void invalidateSpanIndexCache() {
            this.mSpanIndexCache.clear();
        }

        public boolean isSpanIndexCacheEnabled() {
            return this.mCacheSpanIndices;
        }

        int getCachedSpanIndex(int position, int spanCount) {
            if (!this.mCacheSpanIndices) {
                return this.getSpanIndex(position, spanCount);
            }
            int existing = this.mSpanIndexCache.get(position, -1);
            if (existing != -1) {
                return existing;
            }
            int value = this.getSpanIndex(position, spanCount);
            this.mSpanIndexCache.put(position, value);
            return value;
        }

        public int getSpanIndex(int position, int spanCount) {
            int prevKey;
            int positionSpanSize = this.getSpanSize(position);
            if (positionSpanSize == spanCount) {
                return 0;
            }
            int span = 0;
            int startPos = this.mStartPosition;
            if (this.mCacheSpanIndices && this.mSpanIndexCache.size() > 0 && (prevKey = this.findReferenceIndexFromCache(position)) >= 0) {
                span = this.mSpanIndexCache.get(prevKey) + this.getSpanSize(prevKey);
                startPos = prevKey + 1;
            }
            for (int i = startPos; i < position; ++i) {
                int size = this.getSpanSize(i);
                if ((span += size) == spanCount) {
                    span = 0;
                    continue;
                }
                if (span <= spanCount) continue;
                span = size;
            }
            if (span + positionSpanSize <= spanCount) {
                return span;
            }
            return 0;
        }

        int findReferenceIndexFromCache(int position) {
            int lo = 0;
            int hi = this.mSpanIndexCache.size() - 1;
            while (lo <= hi) {
                int mid = lo + hi >>> 1;
                int midVal = this.mSpanIndexCache.keyAt(mid);
                if (midVal < position) {
                    lo = mid + 1;
                    continue;
                }
                hi = mid - 1;
            }
            int index = lo - 1;
            if (index >= 0 && index < this.mSpanIndexCache.size()) {
                return this.mSpanIndexCache.keyAt(index);
            }
            return -1;
        }

        public int getSpanGroupIndex(int adapterPosition, int spanCount) {
            int span = 0;
            int group = 0;
            int positionSpanSize = this.getSpanSize(adapterPosition);
            for (int i = 0; i < adapterPosition; ++i) {
                int size = this.getSpanSize(i);
                if ((span += size) == spanCount) {
                    span = 0;
                    ++group;
                    continue;
                }
                if (span <= spanCount) continue;
                span = size;
                ++group;
            }
            if (span + positionSpanSize > spanCount) {
                ++group;
            }
            return group;
        }
    }

    static final class DefaultSpanSizeLookup
    extends SpanSizeLookup {
        DefaultSpanSizeLookup() {
        }

        @Override
        public int getSpanSize(int position) {
            return 1;
        }

        @Override
        public int getSpanIndex(int span, int spanCount) {
            return (span - this.mStartPosition) % spanCount;
        }
    }
}

