/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.vlayout.layout;

import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.View;
import com.alibaba.android.vlayout.LayoutManagerHelper;
import com.alibaba.android.vlayout.OrientationHelperEx;
import com.alibaba.android.vlayout.VirtualLayoutManager;
import com.alibaba.android.vlayout.layout.AbstractFullFillLayoutHelper;
import com.alibaba.android.vlayout.layout.LayoutChunkResult;
import java.util.Arrays;

public class OnePlusNLayoutHelperEx
extends AbstractFullFillLayoutHelper {
    private static final String TAG = "OnePlusNLayoutHelper";
    private Rect mAreaRect = new Rect();
    private View[] mChildrenViews;
    private float[] mColWeights = new float[0];
    private float mRowWeight = Float.NaN;

    public OnePlusNLayoutHelperEx() {
        this.setItemCount(0);
    }

    public OnePlusNLayoutHelperEx(int itemCount) {
        this(itemCount, 0, 0, 0, 0);
    }

    public OnePlusNLayoutHelperEx(int itemCount, int leftMargin, int topMargin, int rightMargin, int bottomMargin) {
        this.setItemCount(itemCount);
    }

    @Override
    public void onRangeChange(int start, int end) {
        if (end - start < 4) {
            throw new IllegalArgumentException("pls use OnePlusNLayoutHelper instead of OnePlusNLayoutHelperEx which childcount <= 5");
        }
        if (end - start > 6) {
            throw new IllegalArgumentException("OnePlusNLayoutHelper only supports maximum 7 children now");
        }
    }

    public void setColWeights(float[] weights) {
        this.mColWeights = weights != null ? Arrays.copyOf(weights, weights.length) : new float[0];
    }

    public void setRowWeight(float weight) {
        this.mRowWeight = weight;
    }

    @Override
    public void layoutViews(RecyclerView.Recycler recycler, RecyclerView.State state, VirtualLayoutManager.LayoutStateWrapper layoutState, LayoutChunkResult result, LayoutManagerHelper helper) {
        int count;
        int originCurPos = layoutState.getCurrentPosition();
        if (this.isOutOfRange(originCurPos)) {
            return;
        }
        if (this.mChildrenViews == null || this.mChildrenViews.length != this.getItemCount()) {
            this.mChildrenViews = new View[this.getItemCount()];
        }
        if ((count = this.getAllChildren(this.mChildrenViews, recycler, layoutState, result, helper)) != this.getItemCount()) {
            Log.w((String)TAG, (String)"The real number of children is not match with range of LayoutHelper");
        }
        boolean layoutInVertical = helper.getOrientation() == 1;
        int parentWidth = helper.getContentWidth();
        int parentHeight = helper.getContentHeight();
        int parentHPadding = helper.getPaddingLeft() + helper.getPaddingRight() + this.getHorizontalMargin() + this.getHorizontalPadding();
        int parentVPadding = helper.getPaddingTop() + helper.getPaddingBottom() + this.getVerticalMargin() + this.getVerticalPadding();
        int mainConsumed = 0;
        if (count == 5) {
            mainConsumed = this.handleFive(layoutState, result, helper, layoutInVertical, parentWidth, parentHeight, parentHPadding, parentVPadding);
        } else if (count == 6) {
            mainConsumed = this.handSix(layoutState, result, helper, layoutInVertical, parentWidth, parentHeight, parentHPadding, parentVPadding);
        } else if (count == 7) {
            mainConsumed = this.handSeven(layoutState, result, helper, layoutInVertical, parentWidth, parentHeight, parentHPadding, parentVPadding);
        }
        result.mConsumed = mainConsumed;
        Arrays.fill(this.mChildrenViews, null);
    }

    private float getViewMainWeight(int index) {
        if (this.mColWeights.length > index) {
            return this.mColWeights[index];
        }
        return Float.NaN;
    }

    @Override
    public int computeAlignOffset(int offset, boolean isLayoutEnd, boolean useAnchor, LayoutManagerHelper helper) {
        if (this.getItemCount() == 3) {
            if (offset == 1 && isLayoutEnd) {
                Log.w((String)TAG, (String)"Should not happen after adjust anchor");
                return 0;
            }
        } else if (this.getItemCount() == 4 && offset == 1 && isLayoutEnd) {
            return 0;
        }
        if (helper.getOrientation() == 1) {
            if (isLayoutEnd) {
                return this.mMarginBottom + this.mPaddingBottom;
            }
            return -this.mMarginTop - this.mPaddingTop;
        }
        if (isLayoutEnd) {
            return this.mMarginRight + this.mPaddingRight;
        }
        return -this.mMarginLeft - this.mPaddingLeft;
    }

    private int handleFive(VirtualLayoutManager.LayoutStateWrapper layoutState, LayoutChunkResult result, LayoutManagerHelper helper, boolean layoutInVertical, int parentWidth, int parentHeight, int parentHPadding, int parentVPadding) {
        int mainConsumed = 0;
        OrientationHelperEx orientationHelper = helper.getMainOrientationHelper();
        View child1 = this.mChildrenViews[0];
        VirtualLayoutManager.LayoutParams lp1 = (VirtualLayoutManager.LayoutParams)child1.getLayoutParams();
        View child2 = helper.getReverseLayout() ? this.mChildrenViews[4] : this.mChildrenViews[1];
        VirtualLayoutManager.LayoutParams lp2 = (VirtualLayoutManager.LayoutParams)child2.getLayoutParams();
        View child3 = helper.getReverseLayout() ? this.mChildrenViews[3] : this.mChildrenViews[2];
        VirtualLayoutManager.LayoutParams lp3 = (VirtualLayoutManager.LayoutParams)child3.getLayoutParams();
        View child4 = helper.getReverseLayout() ? this.mChildrenViews[2] : this.mChildrenViews[3];
        VirtualLayoutManager.LayoutParams lp4 = (VirtualLayoutManager.LayoutParams)child4.getLayoutParams();
        View child5 = helper.getReverseLayout() ? this.mChildrenViews[1] : this.mChildrenViews[4];
        VirtualLayoutManager.LayoutParams lp5 = (VirtualLayoutManager.LayoutParams)child5.getLayoutParams();
        float weight1 = this.getViewMainWeight(0);
        float weight2 = this.getViewMainWeight(1);
        float weight3 = this.getViewMainWeight(2);
        float weight4 = this.getViewMainWeight(3);
        float weight5 = this.getViewMainWeight(4);
        if (layoutInVertical) {
            lp2.topMargin = lp1.topMargin;
            lp3.bottomMargin = lp4.bottomMargin = lp1.bottomMargin;
            lp3.leftMargin = lp2.leftMargin;
            lp4.rightMargin = lp2.rightMargin;
            lp5.rightMargin = lp3.rightMargin;
            if (!Float.isNaN(this.mAspectRatio)) {
                lp1.height = (int)((float)(parentWidth - parentHPadding) / this.mAspectRatio);
            }
            int availableSpace = parentWidth - parentHPadding - lp1.leftMargin - lp1.rightMargin - lp2.leftMargin - lp2.rightMargin - lp3.leftMargin - lp3.rightMargin;
            int width1 = Float.isNaN(weight1) ? (int)((float)availableSpace / 3.0f + 0.5f) : (int)((float)availableSpace * weight1 / 100.0f + 0.5f);
            int width2 = Float.isNaN(weight2) ? (availableSpace - width1) / 2 : (int)((float)availableSpace * weight2 / 100.0f + 0.5f);
            int width3 = Float.isNaN(weight3) ? width2 : (int)((float)availableSpace * weight3 / 100.0f + 0.5f);
            int width4 = Float.isNaN(weight4) ? width2 : (int)((float)availableSpace * weight4 / 100.0f + 0.5f);
            int width5 = Float.isNaN(weight5) ? width2 : (int)((float)availableSpace * weight5 / 100.0f + 0.5f);
            helper.measureChildWithMargins(child1, View.MeasureSpec.makeMeasureSpec((int)(width1 + lp1.leftMargin + lp1.rightMargin), (int)0x40000000), helper.getChildMeasureSpec(helper.getContentHeight(), lp1.height, true));
            int height1 = child1.getMeasuredHeight();
            int height2 = Float.isNaN(this.mRowWeight) ? (int)((float)(height1 - lp2.bottomMargin - lp3.topMargin) / 2.0f + 0.5f) : (int)((float)(height1 - lp2.bottomMargin - lp3.topMargin) * this.mRowWeight / 100.0f + 0.5f);
            int height3 = height1 - lp2.bottomMargin - lp3.topMargin - height2;
            helper.measureChildWithMargins(child2, View.MeasureSpec.makeMeasureSpec((int)(width2 + lp2.leftMargin + lp2.rightMargin), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(height2 + lp2.topMargin + lp2.bottomMargin), (int)0x40000000));
            helper.measureChildWithMargins(child3, View.MeasureSpec.makeMeasureSpec((int)(width3 + lp3.leftMargin + lp3.rightMargin), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(height3 + lp3.topMargin + lp3.bottomMargin), (int)0x40000000));
            helper.measureChildWithMargins(child4, View.MeasureSpec.makeMeasureSpec((int)(width4 + lp4.leftMargin + lp4.rightMargin), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(height3 + lp4.topMargin + lp4.bottomMargin), (int)0x40000000));
            helper.measureChildWithMargins(child5, View.MeasureSpec.makeMeasureSpec((int)(width5 + lp5.leftMargin + lp5.rightMargin), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(height3 + lp5.topMargin + lp5.bottomMargin), (int)0x40000000));
            mainConsumed = Math.max(height1 + lp1.topMargin + lp1.bottomMargin, height2 + lp2.topMargin + lp2.bottomMargin + Math.max(height3 + lp3.topMargin + lp3.bottomMargin, height3 + lp4.topMargin + lp4.bottomMargin)) + this.getVerticalMargin() + this.getVerticalPadding();
            this.calculateRect(mainConsumed - this.getVerticalMargin() - this.getVerticalPadding(), this.mAreaRect, layoutState, helper);
            int right1 = this.mAreaRect.left + orientationHelper.getDecoratedMeasurementInOther(child1);
            this.layoutChildWithMargin(child1, this.mAreaRect.left, this.mAreaRect.top, right1, this.mAreaRect.bottom, helper);
            int right2 = right1 + orientationHelper.getDecoratedMeasurementInOther(child2);
            this.layoutChildWithMargin(child2, right1, this.mAreaRect.top, right2, this.mAreaRect.top + orientationHelper.getDecoratedMeasurement(child2), helper);
            int right3 = right2 + orientationHelper.getDecoratedMeasurementInOther(child3);
            this.layoutChildWithMargin(child3, right2, this.mAreaRect.top, right3, this.mAreaRect.top + orientationHelper.getDecoratedMeasurement(child3), helper);
            int right4 = right1 + orientationHelper.getDecoratedMeasurementInOther(child4);
            this.layoutChildWithMargin(child4, right1, this.mAreaRect.bottom - orientationHelper.getDecoratedMeasurement(child4), right4, this.mAreaRect.bottom, helper);
            this.layoutChildWithMargin(child5, right4, this.mAreaRect.bottom - orientationHelper.getDecoratedMeasurement(child5), right4 + orientationHelper.getDecoratedMeasurementInOther(child5), this.mAreaRect.bottom, helper);
        }
        this.handleStateOnResult(result, this.mChildrenViews);
        return mainConsumed;
    }

    private int handSix(VirtualLayoutManager.LayoutStateWrapper layoutState, LayoutChunkResult result, LayoutManagerHelper helper, boolean layoutInVertical, int parentWidth, int parentHeight, int parentHPadding, int parentVPadding) {
        int mainConsumed = 0;
        OrientationHelperEx orientationHelper = helper.getMainOrientationHelper();
        View child1 = this.mChildrenViews[0];
        VirtualLayoutManager.LayoutParams lp1 = (VirtualLayoutManager.LayoutParams)child1.getLayoutParams();
        View child2 = helper.getReverseLayout() ? this.mChildrenViews[5] : this.mChildrenViews[1];
        VirtualLayoutManager.LayoutParams lp2 = (VirtualLayoutManager.LayoutParams)child2.getLayoutParams();
        View child3 = helper.getReverseLayout() ? this.mChildrenViews[4] : this.mChildrenViews[2];
        VirtualLayoutManager.LayoutParams lp3 = (VirtualLayoutManager.LayoutParams)child3.getLayoutParams();
        View child4 = helper.getReverseLayout() ? this.mChildrenViews[3] : this.mChildrenViews[3];
        VirtualLayoutManager.LayoutParams lp4 = (VirtualLayoutManager.LayoutParams)child4.getLayoutParams();
        View child5 = helper.getReverseLayout() ? this.mChildrenViews[2] : this.mChildrenViews[4];
        VirtualLayoutManager.LayoutParams lp5 = (VirtualLayoutManager.LayoutParams)child5.getLayoutParams();
        View child6 = helper.getReverseLayout() ? this.mChildrenViews[1] : this.mChildrenViews[5];
        VirtualLayoutManager.LayoutParams lp6 = (VirtualLayoutManager.LayoutParams)child6.getLayoutParams();
        float weight1 = this.getViewMainWeight(0);
        float weight2 = this.getViewMainWeight(1);
        float weight3 = this.getViewMainWeight(2);
        float weight4 = this.getViewMainWeight(3);
        float weight5 = this.getViewMainWeight(4);
        float weight6 = this.getViewMainWeight(5);
        if (layoutInVertical) {
            lp2.topMargin = lp1.topMargin;
            lp3.bottomMargin = lp4.bottomMargin = lp1.bottomMargin;
            lp3.leftMargin = lp2.leftMargin;
            lp4.rightMargin = lp2.rightMargin;
            lp5.rightMargin = lp2.rightMargin;
            if (!Float.isNaN(this.mAspectRatio)) {
                lp1.height = (int)((float)(parentWidth - parentHPadding) / this.mAspectRatio);
            }
            int availableSpace = parentWidth - parentHPadding - lp1.leftMargin - lp1.rightMargin - lp2.leftMargin - lp2.rightMargin;
            int width1 = Float.isNaN(weight1) ? (int)((float)availableSpace / 2.0f + 0.5f) : (int)((float)availableSpace * weight1 / 100.0f + 0.5f);
            int width2 = Float.isNaN(weight2) ? availableSpace - width1 : (int)((float)availableSpace * weight2 / 100.0f + 0.5f);
            int width3 = Float.isNaN(weight3) ? width2 : (int)((double)((float)availableSpace * weight3 / 100.0f) + 0.5);
            int bottomavailableSpace = parentWidth - parentHPadding - lp4.leftMargin - lp4.rightMargin - lp5.leftMargin - lp5.rightMargin - lp6.leftMargin - lp6.rightMargin;
            int width4 = Float.isNaN(weight4) ? (int)((float)bottomavailableSpace / 3.0f + 0.5f) : (int)((float)availableSpace * weight4 / 100.0f + 0.5f);
            int width5 = Float.isNaN(weight5) ? width4 : (int)((float)availableSpace * weight5 / 100.0f + 0.5f);
            int width6 = Float.isNaN(weight6) ? width4 : (int)((float)availableSpace * weight6 / 100.0f + 0.5f);
            helper.measureChildWithMargins(child1, View.MeasureSpec.makeMeasureSpec((int)(width1 + lp1.leftMargin + lp1.rightMargin), (int)0x40000000), helper.getChildMeasureSpec(helper.getContentHeight(), lp1.height, true));
            int height1 = child1.getMeasuredHeight();
            int height2 = Float.isNaN(this.mRowWeight) ? (int)((float)(height1 - lp2.bottomMargin - lp3.topMargin) / 2.0f + 0.5f) : (int)((float)(height1 - lp2.bottomMargin - lp3.topMargin) * this.mRowWeight / 100.0f + 0.5f);
            int height3 = height1 - lp2.bottomMargin - lp3.topMargin - height2;
            helper.measureChildWithMargins(child2, View.MeasureSpec.makeMeasureSpec((int)(width2 + lp2.leftMargin + lp2.rightMargin), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(height2 + lp2.topMargin + lp2.bottomMargin), (int)0x40000000));
            helper.measureChildWithMargins(child3, View.MeasureSpec.makeMeasureSpec((int)(width3 + lp3.leftMargin + lp3.rightMargin), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(height3 + lp3.topMargin + lp3.bottomMargin), (int)0x40000000));
            helper.measureChildWithMargins(child4, View.MeasureSpec.makeMeasureSpec((int)(width4 + lp4.leftMargin + lp4.rightMargin), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(height3 + lp4.topMargin + lp4.bottomMargin), (int)0x40000000));
            helper.measureChildWithMargins(child5, View.MeasureSpec.makeMeasureSpec((int)(width5 + lp5.leftMargin + lp5.rightMargin), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(height3 + lp5.topMargin + lp5.bottomMargin), (int)0x40000000));
            helper.measureChildWithMargins(child6, View.MeasureSpec.makeMeasureSpec((int)(width6 + lp6.leftMargin + lp6.rightMargin), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(height3 + lp6.topMargin + lp6.bottomMargin), (int)0x40000000));
            int maxTopHeight = Math.max(height1 + lp1.topMargin + lp1.bottomMargin, (height2 + lp2.topMargin + lp2.bottomMargin) * 2);
            int maxBottomHeight = Math.max(height3 + lp4.topMargin + lp4.bottomMargin, Math.max(height3 + lp5.topMargin + lp5.bottomMargin, height3 + lp6.topMargin + lp6.bottomMargin));
            mainConsumed = maxTopHeight + maxBottomHeight + this.getVerticalMargin() + this.getVerticalPadding();
            this.calculateRect(mainConsumed - this.getVerticalMargin() - this.getVerticalPadding(), this.mAreaRect, layoutState, helper);
            int right1 = this.mAreaRect.left + orientationHelper.getDecoratedMeasurementInOther(child1);
            this.layoutChildWithMargin(child1, this.mAreaRect.left, this.mAreaRect.top, right1, this.mAreaRect.bottom - orientationHelper.getDecoratedMeasurement(child4), helper);
            int right2 = right1 + orientationHelper.getDecoratedMeasurementInOther(child2);
            this.layoutChildWithMargin(child2, right1, this.mAreaRect.top, right2, this.mAreaRect.top + orientationHelper.getDecoratedMeasurement(child2), helper);
            int right3 = right1 + orientationHelper.getDecoratedMeasurementInOther(child3);
            this.layoutChildWithMargin(child3, right1, this.mAreaRect.top + orientationHelper.getDecoratedMeasurement(child3), right3, this.mAreaRect.bottom - orientationHelper.getDecoratedMeasurement(child4), helper);
            int right4 = this.mAreaRect.left + orientationHelper.getDecoratedMeasurementInOther(child4);
            this.layoutChildWithMargin(child4, this.mAreaRect.left, this.mAreaRect.bottom - orientationHelper.getDecoratedMeasurement(child4), right4, this.mAreaRect.bottom, helper);
            int right5 = right4 + orientationHelper.getDecoratedMeasurementInOther(child5);
            this.layoutChildWithMargin(child5, right4, this.mAreaRect.bottom - orientationHelper.getDecoratedMeasurement(child5), right5, this.mAreaRect.bottom, helper);
            int right6 = right5 + orientationHelper.getDecoratedMeasurementInOther(child6);
            this.layoutChildWithMargin(child6, right5, this.mAreaRect.bottom - orientationHelper.getDecoratedMeasurement(child6), right6, this.mAreaRect.bottom, helper);
        }
        this.handleStateOnResult(result, this.mChildrenViews);
        return mainConsumed;
    }

    private int handSeven(VirtualLayoutManager.LayoutStateWrapper layoutState, LayoutChunkResult result, LayoutManagerHelper helper, boolean layoutInVertical, int parentWidth, int parentHeight, int parentHPadding, int parentVPadding) {
        int mainConsumed = 0;
        OrientationHelperEx orientationHelper = helper.getMainOrientationHelper();
        View child1 = this.mChildrenViews[0];
        VirtualLayoutManager.LayoutParams lp1 = (VirtualLayoutManager.LayoutParams)child1.getLayoutParams();
        View child2 = helper.getReverseLayout() ? this.mChildrenViews[6] : this.mChildrenViews[1];
        VirtualLayoutManager.LayoutParams lp2 = (VirtualLayoutManager.LayoutParams)child2.getLayoutParams();
        View child3 = helper.getReverseLayout() ? this.mChildrenViews[5] : this.mChildrenViews[2];
        VirtualLayoutManager.LayoutParams lp3 = (VirtualLayoutManager.LayoutParams)child3.getLayoutParams();
        View child4 = helper.getReverseLayout() ? this.mChildrenViews[4] : this.mChildrenViews[3];
        VirtualLayoutManager.LayoutParams lp4 = (VirtualLayoutManager.LayoutParams)child4.getLayoutParams();
        View child5 = helper.getReverseLayout() ? this.mChildrenViews[3] : this.mChildrenViews[4];
        VirtualLayoutManager.LayoutParams lp5 = (VirtualLayoutManager.LayoutParams)child5.getLayoutParams();
        View child6 = helper.getReverseLayout() ? this.mChildrenViews[2] : this.mChildrenViews[5];
        VirtualLayoutManager.LayoutParams lp6 = (VirtualLayoutManager.LayoutParams)child6.getLayoutParams();
        View child7 = helper.getReverseLayout() ? this.mChildrenViews[1] : this.mChildrenViews[6];
        VirtualLayoutManager.LayoutParams lp7 = (VirtualLayoutManager.LayoutParams)child7.getLayoutParams();
        float weight1 = this.getViewMainWeight(0);
        float weight2 = this.getViewMainWeight(1);
        float weight3 = this.getViewMainWeight(2);
        float weight4 = this.getViewMainWeight(3);
        float weight5 = this.getViewMainWeight(4);
        float weight6 = this.getViewMainWeight(5);
        float weight7 = this.getViewMainWeight(6);
        if (layoutInVertical) {
            if (!Float.isNaN(this.mAspectRatio)) {
                lp1.height = (int)((float)(parentWidth - parentHPadding) / this.mAspectRatio);
            }
            int availableSpace = parentWidth - parentHPadding - lp1.leftMargin - lp1.rightMargin - lp2.leftMargin - lp2.rightMargin - lp3.leftMargin - lp3.rightMargin;
            int width1 = Float.isNaN(weight1) ? (int)((float)availableSpace / 3.0f + 0.5f) : (int)((float)availableSpace * weight1 / 100.0f + 0.5f);
            int width2 = Float.isNaN(weight2) ? (availableSpace - width1) / 2 : (int)((float)availableSpace * weight2 / 100.0f + 0.5f);
            int width3 = Float.isNaN(weight3) ? width2 : (int)((double)((float)availableSpace * weight3 / 100.0f) + 0.5);
            int width4 = Float.isNaN(weight4) ? width2 : (int)((float)availableSpace * weight4 / 100.0f + 0.5f);
            int width5 = Float.isNaN(weight5) ? width2 : (int)((float)availableSpace * weight5 / 100.0f + 0.5f);
            int width6 = Float.isNaN(weight6) ? width2 : (int)((float)availableSpace * weight6 / 100.0f + 0.5f);
            int width7 = Float.isNaN(weight6) ? width2 : (int)((float)availableSpace * weight7 / 100.0f + 0.5f);
            helper.measureChildWithMargins(child1, View.MeasureSpec.makeMeasureSpec((int)(width1 + lp1.leftMargin + lp1.rightMargin), (int)0x40000000), helper.getChildMeasureSpec(helper.getContentHeight(), lp1.height, true));
            int height1 = child1.getMeasuredHeight();
            int height2 = Float.isNaN(this.mRowWeight) ? (int)((float)(height1 - lp2.bottomMargin - lp3.topMargin) / 3.0f + 0.5f) : (int)((float)(height1 - lp2.bottomMargin - lp3.topMargin) * this.mRowWeight / 100.0f + 0.5f);
            helper.measureChildWithMargins(child2, View.MeasureSpec.makeMeasureSpec((int)(width2 + lp2.leftMargin + lp2.rightMargin), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(height2 + lp2.topMargin + lp2.bottomMargin), (int)0x40000000));
            helper.measureChildWithMargins(child3, View.MeasureSpec.makeMeasureSpec((int)(width3 + lp3.leftMargin + lp3.rightMargin), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(height2 + lp3.topMargin + lp3.bottomMargin), (int)0x40000000));
            helper.measureChildWithMargins(child4, View.MeasureSpec.makeMeasureSpec((int)(width4 + lp4.leftMargin + lp4.rightMargin), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(height2 + lp4.topMargin + lp4.bottomMargin), (int)0x40000000));
            helper.measureChildWithMargins(child5, View.MeasureSpec.makeMeasureSpec((int)(width5 + lp5.leftMargin + lp5.rightMargin), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(height2 + lp5.topMargin + lp5.bottomMargin), (int)0x40000000));
            helper.measureChildWithMargins(child6, View.MeasureSpec.makeMeasureSpec((int)(width6 + lp6.leftMargin + lp6.rightMargin), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(height2 + lp6.topMargin + lp6.bottomMargin), (int)0x40000000));
            helper.measureChildWithMargins(child7, View.MeasureSpec.makeMeasureSpec((int)(width7 + lp7.leftMargin + lp7.rightMargin), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(height2 + lp7.topMargin + lp7.bottomMargin), (int)0x40000000));
            int maxRightHeight = Math.max(height2 + lp2.topMargin + lp2.bottomMargin, height2 + lp3.topMargin + lp3.bottomMargin) + Math.max(height2 + lp4.topMargin + lp4.bottomMargin, height2 + lp5.topMargin + lp5.bottomMargin) + Math.max(height2 + lp6.topMargin + lp6.bottomMargin, height2 + lp7.topMargin + lp7.bottomMargin);
            int maxHeight = Math.max(height1 + lp1.topMargin + lp1.bottomMargin, maxRightHeight);
            mainConsumed = maxHeight + this.getVerticalMargin() + this.getVerticalPadding();
            this.calculateRect(mainConsumed - this.getVerticalMargin() - this.getVerticalPadding(), this.mAreaRect, layoutState, helper);
            int right1 = this.mAreaRect.left + orientationHelper.getDecoratedMeasurementInOther(child1);
            this.layoutChildWithMargin(child1, this.mAreaRect.left, this.mAreaRect.top, right1, this.mAreaRect.bottom, helper);
            int right2 = right1 + orientationHelper.getDecoratedMeasurementInOther(child2);
            this.layoutChildWithMargin(child2, right1, this.mAreaRect.top, right2, this.mAreaRect.top + orientationHelper.getDecoratedMeasurement(child2), helper);
            int right3 = right2 + orientationHelper.getDecoratedMeasurementInOther(child3);
            this.layoutChildWithMargin(child3, right2, this.mAreaRect.top, right3, this.mAreaRect.top + orientationHelper.getDecoratedMeasurement(child3), helper);
            int right4 = right1 + orientationHelper.getDecoratedMeasurementInOther(child4);
            this.layoutChildWithMargin(child4, right1, this.mAreaRect.top + orientationHelper.getDecoratedMeasurement(child2), right4, this.mAreaRect.bottom - orientationHelper.getDecoratedMeasurement(child6), helper);
            int right5 = right4 + orientationHelper.getDecoratedMeasurementInOther(child5);
            this.layoutChildWithMargin(child5, right4, this.mAreaRect.top + orientationHelper.getDecoratedMeasurement(child2), right5, this.mAreaRect.bottom - orientationHelper.getDecoratedMeasurement(child7), helper);
            int right6 = right1 + orientationHelper.getDecoratedMeasurementInOther(child6);
            this.layoutChildWithMargin(child6, right1, this.mAreaRect.bottom - orientationHelper.getDecoratedMeasurement(child6), right6, this.mAreaRect.bottom, helper);
            this.layoutChildWithMargin(child7, right6, this.mAreaRect.bottom - orientationHelper.getDecoratedMeasurement(child7), right6 + orientationHelper.getDecoratedMeasurementInOther(child7), this.mAreaRect.bottom, helper);
        }
        this.handleStateOnResult(result, this.mChildrenViews);
        return mainConsumed;
    }
}

