/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.vlayout.layout;

import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.alibaba.android.vlayout.LayoutManagerHelper;
import com.alibaba.android.vlayout.OrientationHelperEx;
import com.alibaba.android.vlayout.VirtualLayoutManager;
import com.alibaba.android.vlayout.layout.ColumnLayoutHelper;
import com.alibaba.android.vlayout.layout.LayoutChunkResult;

public class SingleLayoutHelper
extends ColumnLayoutHelper {
    private static final String TAG = "SingleLayoutHelper";
    private int mPos = -1;

    public SingleLayoutHelper() {
        this.setItemCount(1);
    }

    @Override
    public void setItemCount(int itemCount) {
        if (itemCount > 0) {
            super.setItemCount(1);
        } else {
            super.setItemCount(0);
        }
    }

    @Override
    public void onRangeChange(int start, int end) {
        this.mPos = start;
    }

    @Override
    public void layoutViews(RecyclerView.Recycler recycler, RecyclerView.State state, VirtualLayoutManager.LayoutStateWrapper layoutState, LayoutChunkResult result, LayoutManagerHelper helper) {
        int top;
        int bottom;
        int right;
        int left;
        int heightSpec;
        int widthSpec;
        if (this.isOutOfRange(layoutState.getCurrentPosition())) {
            return;
        }
        View view = layoutState.next(recycler);
        if (view == null) {
            result.mFinished = true;
            return;
        }
        helper.addChildView(layoutState, view);
        VirtualLayoutManager.LayoutParams params = (VirtualLayoutManager.LayoutParams)view.getLayoutParams();
        boolean layoutInVertical = helper.getOrientation() == 1;
        int parentWidth = helper.getContentWidth() - helper.getPaddingLeft() - helper.getPaddingRight() - this.getHorizontalMargin() - this.getHorizontalPadding();
        int parentHeight = helper.getContentHeight() - helper.getPaddingTop() - helper.getPaddingBottom() - this.getVerticalMargin() - this.getVerticalPadding();
        if (!Float.isNaN(this.mAspectRatio)) {
            if (layoutInVertical) {
                parentHeight = (int)((float)parentWidth / this.mAspectRatio + 0.5f);
            } else {
                parentWidth = (int)((float)parentHeight * this.mAspectRatio + 0.5f);
            }
        }
        if (layoutInVertical) {
            widthSpec = helper.getChildMeasureSpec(parentWidth, Float.isNaN(this.mAspectRatio) ? params.width : parentWidth, !layoutInVertical && Float.isNaN(this.mAspectRatio));
            heightSpec = helper.getChildMeasureSpec(parentHeight, Float.isNaN(params.mAspectRatio) ? (Float.isNaN(this.mAspectRatio) ? params.height : parentHeight) : (int)((float)parentWidth / params.mAspectRatio + 0.5f), layoutInVertical && Float.isNaN(this.mAspectRatio));
            helper.measureChildWithMargins(view, widthSpec, heightSpec);
        } else {
            widthSpec = helper.getChildMeasureSpec(parentWidth, Float.isNaN(params.mAspectRatio) ? (Float.isNaN(this.mAspectRatio) ? params.width : parentWidth) : (int)((float)parentHeight * params.mAspectRatio + 0.5f), !layoutInVertical && Float.isNaN(this.mAspectRatio));
            heightSpec = helper.getChildMeasureSpec(parentHeight, Float.isNaN(this.mAspectRatio) ? params.height : parentHeight, layoutInVertical && Float.isNaN(this.mAspectRatio));
            helper.measureChildWithMargins(view, widthSpec, heightSpec);
        }
        OrientationHelperEx orientationHelper = helper.getMainOrientationHelper();
        result.mConsumed = orientationHelper.getDecoratedMeasurement(view);
        if (layoutInVertical) {
            int viewWidth = orientationHelper.getDecoratedMeasurementInOther(view);
            int available = parentWidth - viewWidth;
            if (available < 0) {
                available = 0;
            }
            left = this.mMarginLeft + this.mPaddingLeft + helper.getPaddingLeft() + available / 2;
            right = helper.getContentWidth() - this.mMarginRight - this.mPaddingRight - helper.getPaddingRight() - available / 2;
            if (layoutState.getLayoutDirection() == -1) {
                bottom = layoutState.getOffset() - this.mMarginBottom - this.mPaddingBottom;
                top = bottom - result.mConsumed;
            } else {
                top = layoutState.getOffset() + this.mMarginTop + this.mPaddingTop;
                bottom = top + result.mConsumed;
            }
        } else {
            int viewHeight = orientationHelper.getDecoratedMeasurementInOther(view);
            int available = parentHeight - viewHeight;
            if (available < 0) {
                available = 0;
            }
            top = helper.getPaddingTop() + this.mMarginTop + this.mPaddingTop + available / 2;
            bottom = helper.getContentHeight() - -this.mMarginBottom - this.mPaddingBottom - helper.getPaddingBottom() - available / 2;
            if (layoutState.getLayoutDirection() == -1) {
                right = layoutState.getOffset() - this.mMarginRight - this.mPaddingRight;
                left = right - result.mConsumed;
            } else {
                left = layoutState.getOffset() + this.mMarginLeft + this.mPaddingLeft;
                right = left + result.mConsumed;
            }
        }
        result.mConsumed = layoutInVertical ? (result.mConsumed += this.getVerticalMargin() + this.getVerticalPadding()) : (result.mConsumed += this.getHorizontalMargin() + this.getHorizontalPadding());
        this.layoutChildWithMargin(view, left, top, right, bottom, helper);
    }
}

