/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.vlayout.layout;

import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.View;
import com.alibaba.android.vlayout.LayoutHelper;
import com.alibaba.android.vlayout.LayoutManagerHelper;
import com.alibaba.android.vlayout.OrientationHelperEx;
import com.alibaba.android.vlayout.VirtualLayoutManager;
import com.alibaba.android.vlayout.layout.FixAreaLayoutHelper;
import com.alibaba.android.vlayout.layout.LayoutChunkResult;
import com.alibaba.android.vlayout.layout.MarginLayoutHelper;
import com.alibaba.android.vlayout.layout.RangeGridLayoutHelper;
import java.util.List;

public class StickyLayoutHelper
extends FixAreaLayoutHelper {
    private static final String TAG = "StickyStartLayoutHelper";
    private int mPos = -1;
    private boolean mStickyStart = true;
    private int mOffset = 0;
    private View mFixView = null;
    private boolean mDoNormalHandle = false;
    private boolean isLastStatusSticking = false;
    private StickyListener stickyListener;
    private Stackable mStackable;

    public StickyLayoutHelper() {
        this(true);
    }

    public StickyLayoutHelper(boolean stickyStart) {
        this.mStickyStart = stickyStart;
        this.setItemCount(1);
    }

    public void setStickyStart(boolean stickyStart) {
        this.mStickyStart = stickyStart;
    }

    public void setOffset(int offset) {
        this.mOffset = offset;
    }

    public boolean isStickyNow() {
        return !this.mDoNormalHandle && this.mFixView != null;
    }

    @Override
    public void setItemCount(int itemCount) {
        if (itemCount > 0) {
            super.setItemCount(1);
        } else {
            super.setItemCount(0);
        }
    }

    @Override
    public void onRangeChange(int start, int end) {
        this.mPos = start;
    }

    @Override
    public void layoutViews(RecyclerView.Recycler recycler, RecyclerView.State state, VirtualLayoutManager.LayoutStateWrapper layoutState, LayoutChunkResult result, LayoutManagerHelper helper) {
        int top;
        int bottom;
        int left;
        int right;
        if (this.isOutOfRange(layoutState.getCurrentPosition())) {
            return;
        }
        View view = this.mFixView;
        if (view == null) {
            view = layoutState.next(recycler);
        } else {
            layoutState.skipCurrentPosition();
        }
        if (view == null) {
            result.mFinished = true;
            return;
        }
        this.doMeasure(view, helper);
        boolean layoutInVertical = helper.getOrientation() == 1;
        OrientationHelperEx orientationHelper = helper.getMainOrientationHelper();
        result.mConsumed = orientationHelper.getDecoratedMeasurement(view);
        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)view.getLayoutParams();
        this.mDoNormalHandle = true;
        int remainingSpace = layoutState.getAvailable() - result.mConsumed + layoutState.getExtra();
        if (helper.getOrientation() == 1) {
            if (helper.isDoLayoutRTL()) {
                right = helper.getContentWidth() - helper.getPaddingRight() - this.mMarginRight;
                left = right - orientationHelper.getDecoratedMeasurementInOther(view);
            } else {
                left = helper.getPaddingLeft() + this.mMarginLeft;
                right = left + orientationHelper.getDecoratedMeasurementInOther(view);
            }
            if (layoutState.getLayoutDirection() == -1) {
                bottom = layoutState.getOffset() - this.mMarginBottom;
                top = layoutState.getOffset() - result.mConsumed;
            } else if (this.mStickyStart) {
                top = layoutState.getOffset() + this.mMarginTop;
                bottom = layoutState.getOffset() + result.mConsumed;
            } else {
                bottom = orientationHelper.getEndAfterPadding() - this.mMarginBottom - this.mOffset - this.mAdjuster.bottom;
                top = bottom - result.mConsumed;
            }
            if (helper.getReverseLayout() || !this.mStickyStart) {
                if (remainingSpace < this.mOffset + this.mAdjuster.bottom && layoutState.getItemDirection() == 1 || bottom > this.mMarginBottom + this.mOffset + this.mAdjuster.bottom) {
                    this.mDoNormalHandle = false;
                    this.mFixView = view;
                    bottom = orientationHelper.getEndAfterPadding() - this.mMarginBottom - this.mOffset - this.mAdjuster.bottom;
                    top = bottom - result.mConsumed;
                }
            } else if (remainingSpace < this.mOffset + this.mAdjuster.top && layoutState.getItemDirection() == -1 || top < this.mMarginTop + this.mOffset + this.mAdjuster.top) {
                this.mDoNormalHandle = false;
                this.mFixView = view;
                top = orientationHelper.getStartAfterPadding() + this.mMarginTop + this.mOffset + this.mAdjuster.top;
                bottom = top + result.mConsumed;
            } else if (VirtualLayoutManager.sDebuggable) {
                Log.i((String)"Sticky", (String)("remainingSpace: " + remainingSpace + "    offset: " + this.mOffset));
            }
        } else {
            top = helper.getPaddingTop();
            bottom = top + orientationHelper.getDecoratedMeasurementInOther(view) + this.mMarginTop;
            if (layoutState.getLayoutDirection() == -1) {
                right = layoutState.getOffset() - this.mMarginRight;
                left = layoutState.getOffset() - result.mConsumed;
            } else {
                left = layoutState.getOffset() + this.mMarginLeft;
                right = layoutState.getOffset() + result.mConsumed;
            }
            if (helper.getReverseLayout() || !this.mStickyStart) {
                if (remainingSpace < this.mOffset + this.mAdjuster.right) {
                    this.mDoNormalHandle = false;
                    this.mFixView = view;
                    right = orientationHelper.getEndAfterPadding() - this.mOffset - this.mAdjuster.right;
                    left = right - result.mConsumed;
                }
            } else if (remainingSpace < this.mOffset + this.mAdjuster.left) {
                this.mDoNormalHandle = false;
                this.mFixView = view;
                left = orientationHelper.getStartAfterPadding() + this.mOffset + this.mAdjuster.left;
                right = result.mConsumed;
            }
        }
        this.layoutChildWithMargin(view, left, top, right, bottom, helper);
        result.mConsumed = result.mConsumed + (layoutInVertical ? this.getVerticalMargin() : this.getHorizontalMargin());
        if (state.isPreLayout()) {
            this.mDoNormalHandle = true;
        }
        if (this.mDoNormalHandle) {
            helper.addChildView(layoutState, view);
            this.handleStateOnResult(result, view);
        }
    }

    @Override
    public void beforeLayout(RecyclerView.Recycler recycler, RecyclerView.State state, LayoutManagerHelper helper) {
        super.beforeLayout(recycler, state, helper);
        if (this.mFixView != null && helper.isViewHolderUpdated(this.mFixView)) {
            helper.removeChildView(this.mFixView);
            recycler.recycleView(this.mFixView);
            this.mFixView = null;
        }
        this.mDoNormalHandle = false;
    }

    @Override
    public boolean requireLayoutView() {
        return false;
    }

    @Override
    public void afterLayout(RecyclerView.Recycler recycler, RecyclerView.State state, int startPosition, int endPosition, int scrolled, LayoutManagerHelper helper) {
        super.afterLayout(recycler, state, startPosition, endPosition, scrolled, helper);
        if (this.mPos < 0) {
            return;
        }
        OrientationHelperEx orientationHelper = helper.getMainOrientationHelper();
        if (!this.mDoNormalHandle && this.mPos >= startPosition && this.mPos <= endPosition) {
            this.fixLayoutStateFromAbnormal2Normal(orientationHelper, recycler, startPosition, endPosition, helper);
        }
        if (this.mDoNormalHandle || state.isPreLayout()) {
            if (!state.isPreLayout()) {
                // empty if block
            }
            if (this.mFixView != null) {
                helper.removeChildView(this.mFixView);
            } else {
                return;
            }
        }
        View stickyView = this.mFixView;
        if (!this.mDoNormalHandle && this.mFixView != null) {
            if (this.mFixView.getParent() == null) {
                helper.addFixedView(this.mFixView);
            } else {
                this.fixLayoutStateInCase1(orientationHelper, recycler, startPosition, endPosition, helper);
            }
        } else {
            this.fixLayoutStateInCase2(orientationHelper, recycler, startPosition, endPosition, helper);
        }
        if (this.stickyListener != null) {
            if (this.isLastStatusSticking && !this.isStickyNow()) {
                this.stickyListener.onUnSticky(this.mPos, stickyView);
                this.isLastStatusSticking = false;
            } else if (!this.isLastStatusSticking && this.isStickyNow()) {
                this.stickyListener.onSticky(this.mPos, this.mFixView);
                this.isLastStatusSticking = true;
            }
        }
    }

    private void fixLayoutStateFromAbnormal2Normal(OrientationHelperEx orientationHelper, RecyclerView.Recycler recycler, int startPosition, int endPosition, LayoutManagerHelper helper) {
        block11: {
            if (VirtualLayoutManager.sDebuggable) {
                Log.i((String)TAG, (String)("abnormal pos: " + this.mPos + " start: " + startPosition + " end: " + endPosition));
            }
            if (this.mFixView == null) break block11;
            View refer = null;
            if (this.mStickyStart) {
                for (int i = helper.getChildCount() - 1; i >= 0; --i) {
                    refer = helper.getChildAt(i);
                    int anchorPos = helper.getPosition(refer);
                    if (anchorPos >= this.mPos) continue;
                    int top = orientationHelper.getDecoratedEnd(refer);
                    LayoutHelper layoutHelper = helper.findLayoutHelperByPosition(anchorPos);
                    if (layoutHelper instanceof RangeGridLayoutHelper) {
                        top += ((RangeGridLayoutHelper)layoutHelper).getBorderEndSpace(helper);
                    } else if (layoutHelper instanceof MarginLayoutHelper) {
                        top = top + ((MarginLayoutHelper)layoutHelper).getMarginBottom() + ((MarginLayoutHelper)layoutHelper).getPaddingBottom();
                    }
                    if (top < this.mOffset + this.mAdjuster.top) break;
                    this.mDoNormalHandle = true;
                    break;
                }
            } else {
                for (int i = 0; i < helper.getChildCount(); ++i) {
                    refer = helper.getChildAt(i);
                    int anchorPos = helper.getPosition(refer);
                    if (anchorPos <= this.mPos) continue;
                    int bottom = orientationHelper.getDecoratedStart(refer);
                    LayoutHelper layoutHelper = helper.findLayoutHelperByPosition(anchorPos);
                    if (layoutHelper instanceof RangeGridLayoutHelper) {
                        bottom -= ((RangeGridLayoutHelper)layoutHelper).getBorderStartSpace(helper);
                    } else if (layoutHelper instanceof MarginLayoutHelper) {
                        bottom = bottom - ((MarginLayoutHelper)layoutHelper).getMarginTop() - ((MarginLayoutHelper)layoutHelper).getPaddingTop();
                    }
                    if (bottom < this.mOffset + this.mAdjuster.bottom) break;
                    this.mDoNormalHandle = true;
                    break;
                }
            }
        }
    }

    private void fixLayoutStateInCase1(OrientationHelperEx orientationHelper, RecyclerView.Recycler recycler, int startPosition, int endPosition, LayoutManagerHelper helper) {
        if (this.mStickyStart && endPosition >= this.mPos || !this.mStickyStart && startPosition <= this.mPos) {
            int consumed = orientationHelper.getDecoratedMeasurement(this.mFixView);
            boolean layoutInVertical = helper.getOrientation() == 1;
            int extraTopOffset = this.getExtraTopOffset(helper);
            int startAdjust = layoutInVertical ? this.mAdjuster.top + extraTopOffset : this.mAdjuster.left;
            int endAdjust = layoutInVertical ? this.mAdjuster.bottom : this.mAdjuster.right;
            int left = 0;
            int top = 0;
            int right = 0;
            int bottom = 0;
            int index = -1;
            if (layoutInVertical) {
                if (helper.isDoLayoutRTL()) {
                    right = helper.getContentWidth() - helper.getPaddingRight();
                    left = right - orientationHelper.getDecoratedMeasurementInOther(this.mFixView);
                } else {
                    left = helper.getPaddingLeft();
                    right = left + orientationHelper.getDecoratedMeasurementInOther(this.mFixView);
                }
                View refer = null;
                if (this.mStickyStart) {
                    for (int i = helper.getChildCount() - 1; i >= 0; --i) {
                        refer = helper.getChildAt(i);
                        int anchorPos = helper.getPosition(refer);
                        if (anchorPos >= this.mPos) continue;
                        top = orientationHelper.getDecoratedEnd(refer);
                        LayoutHelper layoutHelper = helper.findLayoutHelperByPosition(anchorPos);
                        if (layoutHelper instanceof RangeGridLayoutHelper) {
                            top += ((RangeGridLayoutHelper)layoutHelper).getBorderEndSpace(helper);
                        } else if (layoutHelper instanceof MarginLayoutHelper) {
                            top = top + ((MarginLayoutHelper)layoutHelper).getMarginBottom() + ((MarginLayoutHelper)layoutHelper).getPaddingBottom();
                        }
                        bottom = top + consumed;
                        index = i;
                        this.mDoNormalHandle = true;
                        break;
                    }
                } else {
                    for (int i = 0; i < helper.getChildCount(); ++i) {
                        refer = helper.getChildAt(i);
                        int anchorPos = helper.getPosition(refer);
                        if (anchorPos <= this.mPos) continue;
                        bottom = orientationHelper.getDecoratedStart(refer);
                        LayoutHelper layoutHelper = helper.findLayoutHelperByPosition(anchorPos);
                        if (layoutHelper instanceof RangeGridLayoutHelper) {
                            bottom -= ((RangeGridLayoutHelper)layoutHelper).getBorderStartSpace(helper);
                        } else if (layoutHelper instanceof MarginLayoutHelper) {
                            bottom = bottom - ((MarginLayoutHelper)layoutHelper).getMarginTop() - ((MarginLayoutHelper)layoutHelper).getPaddingTop();
                        }
                        top = bottom - consumed;
                        index = i + 1;
                        this.mDoNormalHandle = true;
                        break;
                    }
                }
                if (refer == null || index < 0) {
                    this.mDoNormalHandle = false;
                }
                if (helper.getReverseLayout() || !this.mStickyStart) {
                    if (bottom > orientationHelper.getEndAfterPadding() - this.mOffset - endAdjust) {
                        this.mDoNormalHandle = false;
                    }
                } else if (top < orientationHelper.getStartAfterPadding() + this.mOffset + startAdjust) {
                    this.mDoNormalHandle = false;
                }
                if (!this.mDoNormalHandle) {
                    if (helper.getReverseLayout() || !this.mStickyStart) {
                        bottom = orientationHelper.getEndAfterPadding() - this.mOffset - endAdjust;
                        top = bottom - consumed;
                    } else {
                        top = orientationHelper.getStartAfterPadding() + this.mOffset + startAdjust;
                        bottom = top + consumed;
                    }
                }
            } else {
                top = helper.getPaddingTop();
                bottom = top + orientationHelper.getDecoratedMeasurementInOther(this.mFixView);
                if (this.mDoNormalHandle) {
                    View refer = null;
                    if (this.mStickyStart) {
                        for (int i = helper.getChildCount() - 1; i >= 0; --i) {
                            refer = helper.getChildAt(i);
                            int anchorPos = helper.getPosition(refer);
                            if (anchorPos >= this.mPos) continue;
                            left = orientationHelper.getDecoratedEnd(refer);
                            right = left + consumed;
                            break;
                        }
                    } else {
                        for (int i = 0; i < helper.getChildCount(); ++i) {
                            refer = helper.getChildAt(i);
                            int anchorPos = helper.getPosition(refer);
                            if (anchorPos <= this.mPos) continue;
                            right = orientationHelper.getDecoratedStart(refer);
                            left = right - consumed;
                            break;
                        }
                    }
                } else if (helper.getReverseLayout() || !this.mStickyStart) {
                    right = orientationHelper.getEndAfterPadding() - this.mOffset - endAdjust;
                    left = right - consumed;
                } else {
                    left = orientationHelper.getStartAfterPadding() + this.mOffset + startAdjust;
                    right = left + consumed;
                }
            }
            this.layoutChildWithMargin(this.mFixView, left, top, right, bottom, helper);
            if (this.mDoNormalHandle) {
                if (index >= 0) {
                    if (this.mFixView.getParent() == null) {
                        helper.addChildView(this.mFixView, index);
                    }
                    this.mFixView = null;
                }
            } else {
                helper.showView(this.mFixView);
                helper.addFixedView(this.mFixView);
            }
        } else {
            helper.removeChildView(this.mFixView);
            helper.recycleView(this.mFixView);
            this.mFixView = null;
        }
    }

    private void fixLayoutStateInCase2(OrientationHelperEx orientationHelper, RecyclerView.Recycler recycler, int startPosition, int endPosition, LayoutManagerHelper helper) {
        int endAdjust;
        View eView = this.mFixView;
        if (eView == null) {
            eView = helper.findViewByPosition(this.mPos);
        }
        boolean normalHandle = false;
        boolean layoutInVertical = helper.getOrientation() == 1;
        int extraTopOffset = this.getExtraTopOffset(helper);
        int startAdjust = layoutInVertical ? this.mAdjuster.top + extraTopOffset : this.mAdjuster.left;
        int n = endAdjust = layoutInVertical ? this.mAdjuster.bottom : this.mAdjuster.right;
        if (this.mStickyStart && endPosition >= this.mPos || !this.mStickyStart && startPosition <= this.mPos) {
            if (eView == null) {
                if (this.mOffset + (this.mStickyStart ? startAdjust : endAdjust) >= 0) {
                    normalHandle = true;
                }
                this.mFixView = recycler.getViewForPosition(this.mPos);
                this.doMeasure(this.mFixView, helper);
            } else if (this.mStickyStart && orientationHelper.getDecoratedStart(eView) >= orientationHelper.getStartAfterPadding() + this.mOffset + startAdjust) {
                normalHandle = true;
                this.mFixView = eView;
            } else if (!this.mStickyStart && orientationHelper.getDecoratedEnd(eView) <= orientationHelper.getEndAfterPadding() - this.mOffset - endAdjust) {
                normalHandle = true;
                this.mFixView = eView;
            } else {
                this.mFixView = eView;
            }
        }
        if (this.mFixView != null) {
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)this.mFixView.getLayoutParams();
            if (params.isItemRemoved()) {
                return;
            }
            int consumed = orientationHelper.getDecoratedMeasurement(this.mFixView);
            int left = 0;
            int top = 0;
            int right = 0;
            int bottom = 0;
            int index = -1;
            if (layoutInVertical) {
                if (helper.isDoLayoutRTL()) {
                    right = helper.getContentWidth() - helper.getPaddingRight();
                    left = right - orientationHelper.getDecoratedMeasurementInOther(this.mFixView);
                } else {
                    left = helper.getPaddingLeft();
                    right = left + orientationHelper.getDecoratedMeasurementInOther(this.mFixView);
                }
                if (normalHandle) {
                    View refer = null;
                    if (this.mStickyStart) {
                        for (int i = helper.getChildCount() - 1; i >= 0; --i) {
                            refer = helper.getChildAt(i);
                            int anchorPos = helper.getPosition(refer);
                            if (anchorPos >= this.mPos) continue;
                            top = orientationHelper.getDecoratedEnd(refer);
                            LayoutHelper layoutHelper = helper.findLayoutHelperByPosition(anchorPos);
                            if (layoutHelper instanceof RangeGridLayoutHelper) {
                                top += ((RangeGridLayoutHelper)layoutHelper).getBorderEndSpace(helper);
                            } else if (layoutHelper instanceof MarginLayoutHelper) {
                                top = top + ((MarginLayoutHelper)layoutHelper).getMarginBottom() + ((MarginLayoutHelper)layoutHelper).getPaddingBottom();
                            }
                            bottom = top + consumed;
                            index = i + 1;
                            break;
                        }
                    } else {
                        for (int i = 0; i < helper.getChildCount(); ++i) {
                            refer = helper.getChildAt(i);
                            int anchorPos = helper.getPosition(refer);
                            if (anchorPos <= this.mPos) continue;
                            bottom = orientationHelper.getDecoratedStart(refer);
                            LayoutHelper layoutHelper = helper.findLayoutHelperByPosition(anchorPos);
                            if (layoutHelper instanceof RangeGridLayoutHelper) {
                                bottom -= ((RangeGridLayoutHelper)layoutHelper).getBorderStartSpace(helper);
                            } else if (layoutHelper instanceof MarginLayoutHelper) {
                                bottom = bottom - ((MarginLayoutHelper)layoutHelper).getMarginTop() - ((MarginLayoutHelper)layoutHelper).getPaddingTop();
                            }
                            top = bottom - consumed;
                            index = i;
                            break;
                        }
                    }
                    if (refer == null || index < 0) {
                        normalHandle = false;
                    }
                    if (helper.getReverseLayout() || !this.mStickyStart) {
                        if (bottom > orientationHelper.getEndAfterPadding() - this.mOffset - endAdjust) {
                            normalHandle = false;
                        }
                    } else if (top < orientationHelper.getStartAfterPadding() + this.mOffset + startAdjust) {
                        normalHandle = false;
                    }
                }
                if (!normalHandle) {
                    if (helper.getReverseLayout() || !this.mStickyStart) {
                        bottom = orientationHelper.getEndAfterPadding() - this.mOffset - endAdjust;
                        top = bottom - consumed;
                    } else {
                        top = orientationHelper.getStartAfterPadding() + this.mOffset + startAdjust;
                        bottom = top + consumed;
                    }
                }
            } else {
                top = helper.getPaddingTop();
                bottom = top + orientationHelper.getDecoratedMeasurementInOther(this.mFixView);
                if (normalHandle) {
                    View refer = null;
                    if (this.mStickyStart) {
                        for (int i = helper.getChildCount() - 1; i >= 0; --i) {
                            refer = helper.getChildAt(i);
                            int anchorPos = helper.getPosition(refer);
                            if (anchorPos >= this.mPos) continue;
                            left = orientationHelper.getDecoratedEnd(refer);
                            right = left + consumed;
                            break;
                        }
                    } else {
                        for (int i = 0; i < helper.getChildCount(); ++i) {
                            refer = helper.getChildAt(i);
                            int anchorPos = helper.getPosition(refer);
                            if (anchorPos <= this.mPos) continue;
                            right = orientationHelper.getDecoratedStart(refer);
                            left = right - consumed;
                            break;
                        }
                    }
                } else if (helper.getReverseLayout() || !this.mStickyStart) {
                    right = orientationHelper.getEndAfterPadding() - this.mOffset - endAdjust;
                    left = right - consumed;
                } else {
                    left = orientationHelper.getStartAfterPadding() + this.mOffset + startAdjust;
                    right = left + consumed;
                }
            }
            this.layoutChildWithMargin(this.mFixView, left, top, right, bottom, helper);
            if (normalHandle) {
                if (index >= 0) {
                    if (this.mFixView.getParent() == null) {
                        helper.addChildView(this.mFixView, index);
                    }
                    this.mFixView = null;
                }
            } else {
                helper.addFixedView(this.mFixView);
            }
        }
        this.mDoNormalHandle = normalHandle;
    }

    @Override
    @Nullable
    public View getFixedView() {
        return this.mFixView;
    }

    @Override
    public void onClear(LayoutManagerHelper helper) {
        super.onClear(helper);
        if (this.mFixView != null) {
            helper.recycleView(this.mFixView);
            helper.removeChildView(this.mFixView);
            this.mFixView = null;
        }
    }

    private void doMeasure(View view, LayoutManagerHelper helper) {
        VirtualLayoutManager.LayoutParams params = (VirtualLayoutManager.LayoutParams)view.getLayoutParams();
        boolean layoutInVertical = helper.getOrientation() == 1;
        int widthSize = helper.getContentWidth() - helper.getPaddingLeft() - helper.getPaddingRight() - this.getHorizontalMargin();
        int heightSize = helper.getContentHeight() - helper.getPaddingTop() - helper.getPaddingBottom() - this.getVerticalMargin();
        float viewAspectRatio = params.mAspectRatio;
        if (layoutInVertical) {
            int widthSpec = helper.getChildMeasureSpec(widthSize, params.width, false);
            int heightSpec = !Float.isNaN(viewAspectRatio) && viewAspectRatio > 0.0f ? View.MeasureSpec.makeMeasureSpec((int)((int)((float)widthSize / viewAspectRatio + 0.5f)), (int)0x40000000) : (!Float.isNaN(this.mAspectRatio) && this.mAspectRatio > 0.0f ? View.MeasureSpec.makeMeasureSpec((int)((int)((double)((float)widthSize / this.mAspectRatio) + 0.5)), (int)0x40000000) : helper.getChildMeasureSpec(heightSize, params.height, true));
            helper.measureChildWithMargins(view, widthSpec, heightSpec);
        } else {
            int heightSpec = helper.getChildMeasureSpec(heightSize, params.height, false);
            int widthSpec = !Float.isNaN(viewAspectRatio) && viewAspectRatio > 0.0f ? View.MeasureSpec.makeMeasureSpec((int)((int)((double)((float)heightSize * viewAspectRatio) + 0.5)), (int)0x40000000) : (!Float.isNaN(this.mAspectRatio) && this.mAspectRatio > 0.0f ? View.MeasureSpec.makeMeasureSpec((int)((int)((double)((float)heightSize * this.mAspectRatio) + 0.5)), (int)0x40000000) : helper.getChildMeasureSpec(widthSize, params.width, true));
            helper.measureChildWithMargins(view, widthSpec, heightSpec);
        }
    }

    public void setStickyListener(StickyListener stickyListener) {
        this.stickyListener = stickyListener;
    }

    public void setStackable(Stackable stackable) {
        this.mStackable = stackable;
    }

    private int getExtraTopOffset(LayoutManagerHelper helper) {
        if (this.mStackable == null || !this.mStackable.enable()) {
            return 0;
        }
        int offset = 0;
        if (helper instanceof VirtualLayoutManager) {
            List<LayoutHelper> helperList = ((VirtualLayoutManager)helper).getLayoutHelpers();
            for (LayoutHelper helperItem : helperList) {
                View view;
                if (!helperItem.isFixLayout() || helperItem.getRange().getUpper() >= this.getRange().getLower() || (view = helperItem.getFixedView()) == null) continue;
                offset += view.getHeight();
            }
        }
        return offset;
    }

    public static interface Stackable {
        public boolean enable();
    }

    public static interface StickyListener {
        public void onSticky(int var1, View var2);

        public void onUnSticky(int var1, View var2);
    }
}

