/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.model;

import com.alibaba.sdk.android.oss.common.HttpMethod;
import com.alibaba.sdk.android.oss.common.utils.CaseInsensitiveHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class GeneratePresignedUrlRequest {
    private HttpMethod method;
    private String bucketName;
    private String key;
    private String process;
    private long expiration;
    private String contentType;
    private String contentMD5;
    private Map<String, String> headers = new CaseInsensitiveHashMap<String, String>();
    private Map<String, String> queryParam = new HashMap<String, String>();
    private Set<String> additionalHeaderNames;

    public GeneratePresignedUrlRequest(String bucketName, String key) {
        this(bucketName, key, 3600L);
    }

    public GeneratePresignedUrlRequest(String bucketName, String key, long expiration) {
        this(bucketName, key, 3600L, HttpMethod.GET);
    }

    public GeneratePresignedUrlRequest(String bucketName, String key, long expiration, HttpMethod method) {
        this.bucketName = bucketName;
        this.key = key;
        this.expiration = expiration;
        this.method = method;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentMD5() {
        return this.contentMD5;
    }

    public void setContentMD5(String contentMD5) {
        this.contentMD5 = contentMD5;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpMethod method) {
        if (method != HttpMethod.GET && method != HttpMethod.PUT) {
            throw new IllegalArgumentException("Only GET or PUT is supported!");
        }
        this.method = method;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public Map<String, String> getQueryParameter() {
        return this.queryParam;
    }

    public void setQueryParameter(Map<String, String> queryParam) {
        if (queryParam == null) {
            throw new NullPointerException("The argument 'queryParameter' is null.");
        }
        if (this.queryParam != null && this.queryParam.size() > 0) {
            this.queryParam.clear();
        }
        this.queryParam.putAll(queryParam);
    }

    public void addQueryParameter(String key, String value) {
        this.queryParam.put(key, value);
    }

    public String getProcess() {
        return this.process;
    }

    public void setProcess(String process) {
        this.process = process;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        if (this.headers == null) {
            this.headers = new CaseInsensitiveHashMap<String, String>();
        }
        if (this.headers != null && this.headers.size() > 0) {
            this.headers.clear();
        }
        this.headers.putAll(headers);
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public Set<String> getAdditionalHeaderNames() {
        return this.additionalHeaderNames;
    }

    public void setAdditionalHeaderNames(Set<String> additionalHeaderNames) {
        this.additionalHeaderNames = additionalHeaderNames;
    }
}

