/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.signer;

import com.alibaba.sdk.android.oss.ClientException;
import com.alibaba.sdk.android.oss.common.OSSLog;
import com.alibaba.sdk.android.oss.common.auth.OSSCredentialProvider;
import com.alibaba.sdk.android.oss.common.auth.OSSCustomSignerCredentialProvider;
import com.alibaba.sdk.android.oss.common.auth.OSSFederationCredentialProvider;
import com.alibaba.sdk.android.oss.common.auth.OSSFederationToken;
import com.alibaba.sdk.android.oss.common.auth.OSSPlainTextAKSKCredentialProvider;
import com.alibaba.sdk.android.oss.common.auth.OSSStsTokenCredentialProvider;
import com.alibaba.sdk.android.oss.common.utils.DateUtil;
import com.alibaba.sdk.android.oss.internal.RequestMessage;
import com.alibaba.sdk.android.oss.signer.OSSSignerParams;
import com.alibaba.sdk.android.oss.signer.OSSV1Signer;
import com.alibaba.sdk.android.oss.signer.OSSV4Signer;
import com.alibaba.sdk.android.oss.signer.RequestPresigner;
import com.alibaba.sdk.android.oss.signer.RequestSigner;
import com.alibaba.sdk.android.oss.signer.SignVersion;
import java.util.Date;

public abstract class OSSSignerBase
implements RequestSigner,
RequestPresigner {
    protected final OSSSignerParams signerParams;

    protected OSSSignerBase(OSSSignerParams signerParams) {
        this.signerParams = signerParams;
    }

    protected void addDateHeaderIfNeeded(RequestMessage request) {
        Date now = new Date();
        long fixedSkewedTimeMillis = DateUtil.getFixedSkewedTimeMillis();
        if (fixedSkewedTimeMillis != 0L) {
            now.setTime(fixedSkewedTimeMillis);
        }
        request.getHeaders().put("Date", DateUtil.formatRfc822Date(now));
    }

    protected void addSecurityTokenHeaderIfNeeded(RequestMessage request, OSSFederationToken federationToken) {
        if (federationToken.useSecurityToken() && !request.isUseUrlSignature()) {
            request.addHeader("x-oss-security-token", federationToken.getSecurityToken());
        }
    }

    protected abstract void addAuthorizationHeader(RequestMessage var1, OSSFederationToken var2);

    protected abstract String buildStringToSign(RequestMessage var1);

    @Override
    public void sign(RequestMessage request) throws Exception {
        if (!request.isAuthorizationRequired()) {
            return;
        }
        OSSCredentialProvider credentialProvider = this.signerParams.getCredentialProvider();
        OSSFederationToken federationToken = null;
        if (credentialProvider instanceof OSSFederationCredentialProvider) {
            federationToken = ((OSSFederationCredentialProvider)credentialProvider).getValidFederationToken();
        } else if (credentialProvider instanceof OSSStsTokenCredentialProvider) {
            federationToken = credentialProvider.getFederationToken();
        } else if (credentialProvider instanceof OSSPlainTextAKSKCredentialProvider) {
            OSSPlainTextAKSKCredentialProvider plainTextAKSKCredentialProvider = (OSSPlainTextAKSKCredentialProvider)credentialProvider;
            federationToken = new OSSFederationToken(plainTextAKSKCredentialProvider.getAccessKeyId(), plainTextAKSKCredentialProvider.getAccessKeySecret(), null, 0L);
        }
        this.addDateHeaderIfNeeded(request);
        if (credentialProvider instanceof OSSCustomSignerCredentialProvider) {
            try {
                OSSCustomSignerCredentialProvider customSignerCredentialProvider = (OSSCustomSignerCredentialProvider)credentialProvider;
                String stringToSign = this.buildStringToSign(request);
                String authorization = customSignerCredentialProvider.signContent(stringToSign);
                request.addHeader("Authorization", authorization);
            }
            catch (Exception e) {
                throw new ClientException(e.getMessage(), e);
            }
        } else {
            if (federationToken == null) {
                OSSLog.logError("Can't get a federation token");
                throw new ClientException("Can't get a federation token");
            }
            this.addSecurityTokenHeaderIfNeeded(request, federationToken);
            this.addAuthorizationHeader(request, federationToken);
        }
    }

    public static RequestSigner createRequestSigner(SignVersion version, OSSSignerParams signerParams) {
        if (SignVersion.V4.equals((Object)version)) {
            return new OSSV4Signer(signerParams);
        }
        return new OSSV1Signer(signerParams);
    }

    public static RequestPresigner createRequestPresigner(SignVersion version, OSSSignerParams signerParams) {
        if (SignVersion.V4.equals((Object)version)) {
            return new OSSV4Signer(signerParams);
        }
        return new OSSV1Signer(signerParams);
    }
}

