/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.signer;

import com.alibaba.sdk.android.oss.ClientException;
import com.alibaba.sdk.android.oss.common.OSSLog;
import com.alibaba.sdk.android.oss.common.auth.OSSCredentialProvider;
import com.alibaba.sdk.android.oss.common.auth.OSSCustomSignerCredentialProvider;
import com.alibaba.sdk.android.oss.common.auth.OSSFederationCredentialProvider;
import com.alibaba.sdk.android.oss.common.auth.OSSFederationToken;
import com.alibaba.sdk.android.oss.common.auth.OSSPlainTextAKSKCredentialProvider;
import com.alibaba.sdk.android.oss.common.auth.OSSStsTokenCredentialProvider;
import com.alibaba.sdk.android.oss.common.utils.BinaryUtil;
import com.alibaba.sdk.android.oss.common.utils.DateUtil;
import com.alibaba.sdk.android.oss.common.utils.HttpUtil;
import com.alibaba.sdk.android.oss.common.utils.StringUtils;
import com.alibaba.sdk.android.oss.internal.RequestMessage;
import com.alibaba.sdk.android.oss.signer.OSSSignerBase;
import com.alibaba.sdk.android.oss.signer.OSSSignerParams;
import com.alibaba.sdk.android.oss.signer.ServiceSignature;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SimpleTimeZone;
import java.util.TreeMap;
import java.util.TreeSet;

public class OSSV4Signer
extends OSSSignerBase {
    private static final List<String> DEFAULT_SIGNED_HEADERS = Arrays.asList("Content-Type".toLowerCase(), "Content-MD5".toLowerCase());
    private static final String ISO8601_DATETIME_FORMAT = "yyyyMMdd'T'HHmmss'Z'";
    private static final String ISO8601_DATE_FORMAT = "yyyyMMdd";
    private static final String SEPARATOR_BACKSLASH = "/";
    private static final String OSS4_HMAC_SHA256 = "OSS4-HMAC-SHA256";
    private static final String TERMINATOR = "aliyun_v4_request";
    private static final String SECRET_KEY_PREFIX = "aliyun_v4";
    private static final String CONTENT_STRING_TO_SIGN = "stringToSign";
    private static final String CONTENT_DATE = "date";
    private static final String CONTENT_ALGORITHM = "algorithm";
    private static final String CONTENT_REGION = "region";
    private static final String CONTENT_PRODUCT = "product";
    private static final String SECURITY_TOKEN = "x-oss-security-token";
    Set<String> additionalSignedHeaders;
    private Date requestDateTime;

    protected OSSV4Signer(OSSSignerParams signerParams) {
        super(signerParams);
    }

    private static DateFormat getIso8601DateTimeFormat() {
        SimpleDateFormat df = new SimpleDateFormat(ISO8601_DATETIME_FORMAT, Locale.US);
        df.setTimeZone(new SimpleTimeZone(0, "GMT"));
        return df;
    }

    private static DateFormat getIso8601DateFormat() {
        SimpleDateFormat df = new SimpleDateFormat(ISO8601_DATE_FORMAT, Locale.US);
        df.setTimeZone(new SimpleTimeZone(0, "GMT"));
        return df;
    }

    private String getDateTime() {
        return OSSV4Signer.getIso8601DateTimeFormat().format(this.requestDateTime);
    }

    private String getDate() {
        return OSSV4Signer.getIso8601DateFormat().format(this.requestDateTime);
    }

    private boolean hasDefaultSignedHeaders(String header) {
        if (DEFAULT_SIGNED_HEADERS.contains(header)) {
            return true;
        }
        return header.startsWith("x-oss-");
    }

    private boolean hasSignedHeaders(String header) {
        if (this.hasDefaultSignedHeaders(header)) {
            return true;
        }
        return this.additionalSignedHeaders.contains(header);
    }

    private boolean hasAdditionalSignedHeaders() {
        return this.additionalSignedHeaders != null && !this.additionalSignedHeaders.isEmpty();
    }

    private TreeMap<String, String> buildSortedHeadersMap(Map<String, String> headers) {
        TreeMap<String, String> orderMap = new TreeMap<String, String>();
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                String key = header.getKey().toLowerCase();
                if (!this.hasSignedHeaders(key)) continue;
                orderMap.put(key, header.getValue());
            }
        }
        return orderMap;
    }

    private void resolveAdditionalSignedHeaders(RequestMessage request, Set<String> headerNames) {
        TreeSet<String> signedHeaders = new TreeSet<String>();
        if (headerNames != null) {
            for (String additionalHeader : headerNames) {
                String additionalHeaderKey = additionalHeader.toLowerCase();
                for (Map.Entry header : request.getHeaders().entrySet()) {
                    String headerKey = ((String)header.getKey()).toLowerCase();
                    if (!headerKey.equals(additionalHeaderKey) || this.hasDefaultSignedHeaders(additionalHeaderKey)) continue;
                    signedHeaders.add(additionalHeaderKey);
                }
            }
        }
        this.additionalSignedHeaders = signedHeaders;
    }

    private void addSignedHeaderIfNeeded(RequestMessage request) {
        Set<String> signedHeaders = this.additionalSignedHeaders;
        if (signedHeaders.contains("Host".toLowerCase()) && !request.getHeaders().containsKey("Host")) {
            request.addHeader("Host", request.getEndpoint().getHost());
        }
    }

    private void addOSSContentSha256Header(RequestMessage request) {
        request.addHeader("x-oss-content-sha256", "UNSIGNED-PAYLOAD");
    }

    @Override
    protected void addDateHeaderIfNeeded(RequestMessage request) {
        this.initRequestDateTime();
        request.getHeaders().put("Date", this.getDateTime());
    }

    private void initRequestDateTime() {
        Date now = new Date();
        long fixedSkewedTimeMillis = DateUtil.getFixedSkewedTimeMillis();
        if (fixedSkewedTimeMillis != 0L) {
            now.setTime(fixedSkewedTimeMillis);
        }
        this.requestDateTime = now;
    }

    /*
     * WARNING - void declaration
     */
    private String buildCanonicalRequest(RequestMessage request) {
        void var10_15;
        String method = request.getMethod().toString();
        String resourcePath = this.signerParams.getResourcePath();
        StringBuilder canonicalString = new StringBuilder();
        canonicalString.append(method).append("\n");
        canonicalString.append(HttpUtil.urlEncode(resourcePath, true)).append("\n");
        Map<String, String> parameters = request.getParameters();
        TreeMap<Object, Object> orderMap = new TreeMap<String, String>();
        if (parameters != null) {
            for (Map.Entry<String, String> param : parameters.entrySet()) {
                orderMap.put(HttpUtil.urlEncode(StringUtils.trim(param.getKey()), false), HttpUtil.urlEncode(StringUtils.trim(param.getValue()), false));
            }
        }
        String separator = "";
        StringBuilder canonicalPart = new StringBuilder();
        for (Map.Entry entry : orderMap.entrySet()) {
            canonicalPart.append(separator).append((String)entry.getKey());
            if (entry.getValue() != null && !((String)entry.getValue()).isEmpty()) {
                canonicalPart.append("=").append((String)entry.getValue());
            }
            separator = "&";
        }
        canonicalString.append((CharSequence)canonicalPart).append("\n");
        orderMap = this.buildSortedHeadersMap(request.getHeaders());
        canonicalPart = new StringBuilder();
        for (Map.Entry<Object, Object> entry : orderMap.entrySet()) {
            canonicalPart.append((String)entry.getKey()).append(":").append(((String)entry.getValue()).trim()).append("\n");
        }
        canonicalString.append((CharSequence)canonicalPart).append("\n");
        String canonicalPartStr = StringUtils.join(";", this.additionalSignedHeaders);
        canonicalString.append(canonicalPartStr).append("\n");
        String string = (String)request.getHeaders().get("x-oss-content-sha256");
        if (StringUtils.isNullOrEmpty(string)) {
            String string2 = "UNSIGNED-PAYLOAD";
        }
        canonicalString.append((String)var10_15);
        return canonicalString.toString();
    }

    private String getRegion() {
        if (this.signerParams.getCloudBoxId() != null) {
            return this.signerParams.getCloudBoxId();
        }
        return this.signerParams.getRegion();
    }

    private String getProduct() {
        return this.signerParams.getProduct();
    }

    private String buildScope() {
        return this.getDate() + SEPARATOR_BACKSLASH + this.getRegion() + SEPARATOR_BACKSLASH + this.getProduct() + SEPARATOR_BACKSLASH + TERMINATOR;
    }

    private String buildStringToSign(String canonicalString) {
        return "OSS4-HMAC-SHA256\n" + this.getDateTime() + "\n" + this.buildScope() + "\n" + BinaryUtil.toHex(BinaryUtil.calculateSha256(canonicalString.getBytes(StringUtils.UTF8)));
    }

    private byte[] buildSigningKey(OSSFederationToken federationToken) {
        ServiceSignature signature = ServiceSignature.create("HmacSHA256");
        byte[] signingSecret = (SECRET_KEY_PREFIX + federationToken.getTempSK()).getBytes(StringUtils.UTF8);
        byte[] signingDate = signature.computeHash(signingSecret, this.getDate().getBytes(StringUtils.UTF8));
        byte[] signingRegion = signature.computeHash(signingDate, this.getRegion().getBytes(StringUtils.UTF8));
        byte[] signingService = signature.computeHash(signingRegion, this.getProduct().getBytes(StringUtils.UTF8));
        return signature.computeHash(signingService, TERMINATOR.getBytes(StringUtils.UTF8));
    }

    private String buildSignature(byte[] signingKey, String stringToSign) {
        byte[] result = ServiceSignature.create("HmacSHA256").computeHash(signingKey, stringToSign.getBytes(StringUtils.UTF8));
        return BinaryUtil.toHex(result);
    }

    private String buildAuthorization(String signature, OSSFederationToken federationToken) {
        String credential = "Credential=" + federationToken.getTempAK() + SEPARATOR_BACKSLASH + this.buildScope();
        String signedHeaders = !this.hasAdditionalSignedHeaders() ? "" : ",AdditionalHeaders=" + StringUtils.join(";", this.additionalSignedHeaders);
        String sign = ",Signature=" + signature;
        return "OSS4-HMAC-SHA256 " + credential + signedHeaders + sign;
    }

    @Override
    protected void addAuthorizationHeader(RequestMessage request, OSSFederationToken federationToken) {
        String stringToSign = this.buildStringToSign(request);
        byte[] signingKey = this.buildSigningKey(federationToken);
        String signature = this.buildSignature(signingKey, stringToSign);
        String authorization = this.buildAuthorization(signature, federationToken);
        request.addHeader("Authorization", authorization);
    }

    @Override
    protected String buildStringToSign(RequestMessage request) {
        String canonicalRequest = this.buildCanonicalRequest(request);
        OSSLog.logInfo(canonicalRequest);
        String stringToSign = this.buildStringToSign(canonicalRequest);
        return stringToSign;
    }

    @Override
    public void sign(RequestMessage request) throws Exception {
        if (!request.isAuthorizationRequired()) {
            return;
        }
        if (this.getRegion() == null) {
            throw new ClientException("Region haven't been set!");
        }
        OSSCredentialProvider credentialProvider = this.signerParams.getCredentialProvider();
        if (credentialProvider instanceof OSSCustomSignerCredentialProvider) {
            throw new IOException("V4 signature does not support OSSCustomSignerCredentialProvider");
        }
        OSSFederationToken federationToken = null;
        if (credentialProvider instanceof OSSFederationCredentialProvider) {
            federationToken = ((OSSFederationCredentialProvider)credentialProvider).getValidFederationToken();
        } else if (credentialProvider instanceof OSSStsTokenCredentialProvider) {
            federationToken = credentialProvider.getFederationToken();
        } else if (credentialProvider instanceof OSSPlainTextAKSKCredentialProvider) {
            OSSPlainTextAKSKCredentialProvider plainTextAKSKCredentialProvider = (OSSPlainTextAKSKCredentialProvider)credentialProvider;
            federationToken = new OSSFederationToken(plainTextAKSKCredentialProvider.getAccessKeyId(), plainTextAKSKCredentialProvider.getAccessKeySecret(), null, 0L);
        }
        this.addDateHeaderIfNeeded(request);
        if (federationToken == null) {
            OSSLog.logError("Can't get a federation token");
            throw new ClientException("Can't get a federation token");
        }
        this.resolveAdditionalSignedHeaders(request, request.getAdditionalHeaderNames());
        this.addSignedHeaderIfNeeded(request);
        this.addSecurityTokenHeaderIfNeeded(request, federationToken);
        this.addOSSContentSha256Header(request);
        this.addAuthorizationHeader(request, federationToken);
    }

    @Override
    public void presign(RequestMessage request) throws Exception {
        if (this.getRegion() == null) {
            throw new ClientException("Region haven't been set!");
        }
        OSSCredentialProvider credentialProvider = this.signerParams.getCredentialProvider();
        if (credentialProvider instanceof OSSCustomSignerCredentialProvider) {
            throw new IOException("V4 signature does not support OSSCustomSignerCredentialProvider");
        }
        OSSFederationToken federationToken = null;
        if (credentialProvider instanceof OSSFederationCredentialProvider) {
            federationToken = ((OSSFederationCredentialProvider)credentialProvider).getValidFederationToken();
        } else if (credentialProvider instanceof OSSStsTokenCredentialProvider) {
            federationToken = credentialProvider.getFederationToken();
        } else if (credentialProvider instanceof OSSPlainTextAKSKCredentialProvider) {
            OSSPlainTextAKSKCredentialProvider plainTextAKSKCredentialProvider = (OSSPlainTextAKSKCredentialProvider)credentialProvider;
            federationToken = new OSSFederationToken(plainTextAKSKCredentialProvider.getAccessKeyId(), plainTextAKSKCredentialProvider.getAccessKeySecret(), null, 0L);
        }
        this.initRequestDateTime();
        String expires = String.valueOf(this.signerParams.getExpiration());
        request.addParameter("x-oss-date", OSSV4Signer.getIso8601DateTimeFormat().format(this.requestDateTime));
        request.addParameter("x-oss-expires", expires);
        this.resolveAdditionalSignedHeaders(request, this.signerParams.getAdditionalHeaderNames());
        this.addSignedHeaderIfNeeded(request);
        if (this.hasAdditionalSignedHeaders()) {
            request.addParameter("x-oss-additional-headers", StringUtils.join(";", this.additionalSignedHeaders));
        }
        request.addParameter("x-oss-signature-version", OSS4_HMAC_SHA256);
        String signature = null;
        if (federationToken.useSecurityToken()) {
            request.addParameter(SECURITY_TOKEN, federationToken.getSecurityToken());
        }
        String credential = federationToken.getTempAK() + SEPARATOR_BACKSLASH + this.buildScope();
        request.addParameter("x-oss-credential", credential);
        String stringToSign = this.buildStringToSign(request);
        byte[] signingKey = this.buildSigningKey(federationToken);
        signature = this.buildSignature(signingKey, stringToSign);
        request.addParameter("x-oss-signature", signature);
    }
}

