/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aps.ads;

import androidx.annotation.NonNull;
import com.amazon.aps.ads.Aps;
import com.amazon.aps.ads.ApsAd;
import com.amazon.aps.ads.ApsAdError;
import com.amazon.aps.ads.ApsAdFormatProperties;
import com.amazon.aps.ads.ApsAdFormatUtils;
import com.amazon.aps.ads.ApsAdUtils;
import com.amazon.aps.ads.listeners.ApsAdRequestListener;
import com.amazon.aps.ads.model.ApsAdFormat;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.AdError;
import com.amazon.device.ads.DTBAdCallback;
import com.amazon.device.ads.DTBAdRequest;
import com.amazon.device.ads.DTBAdResponse;
import com.amazon.device.ads.DTBAdSize;
import com.amazon.device.ads.DTBLoadException;
import java.util.HashMap;
import java.util.Map;

public class ApsAdRequest
extends DTBAdRequest {
    private ApsAdRequestListener apsAdRequestListener;
    private ApsAdFormat apsAdFormat;
    private String slotUuid;
    private ApsAdFormatProperties apsAdFormatProperties;
    private DTBAdCallback dtbAdCallback = new DTBAdCallback(){

        @Override
        public void onFailure(@NonNull AdError adError) {
            if (ApsAdRequest.this.apsAdRequestListener != null) {
                ApsAdRequest.this.apsAdRequestListener.onFailure(new ApsAdError(adError, ApsAdRequest.this.slotUuid, ApsAdRequest.this.apsAdFormat));
            }
        }

        @Override
        public void onSuccess(@NonNull DTBAdResponse dtbAdResponse) {
            if (ApsAdRequest.this.apsAdRequestListener != null) {
                ApsAd apsAd = new ApsAd(dtbAdResponse, ApsAdRequest.this.apsAdFormat);
                apsAd.setSlotUuid(ApsAdRequest.this.slotUuid);
                ApsAdRequest.this.apsAdRequestListener.onSuccess(apsAd);
            }
        }
    };

    public ApsAdRequest(String slotUuid) {
        ApsAdUtils.checkNullAndLogInvalidArg(slotUuid);
        this.slotUuid = slotUuid;
    }

    public ApsAdRequest(String slotUuid, ApsAdFormat apsAdFormat) {
        this(slotUuid);
        ApsAdUtils.checkNullAndLogInvalidArg(new Object[]{apsAdFormat});
        this.setApsAdFormat(apsAdFormat);
    }

    public ApsAdRequest(String slotUuid, ApsAdFormat apsAdFormat, ApsAdFormatProperties apsAdFormatProperties) {
        this(slotUuid);
        ApsAdUtils.checkNullAndLogInvalidArg(new Object[]{apsAdFormat});
        this.setApsAdFormat(apsAdFormat, apsAdFormatProperties);
    }

    public ApsAdRequest(DTBAdRequest dtbAdRequest, String slotUuid, ApsAdFormat apsAdFormat) {
        super(dtbAdRequest, slotUuid);
        this.slotUuid = slotUuid;
        this.setApsAdFormat(apsAdFormat);
    }

    public ApsAdRequest(DTBAdRequest dtbAdRequest) {
        super(dtbAdRequest);
        DTBAdSize dtbAdSize;
        if (dtbAdRequest != null && dtbAdRequest.getAdSizes() != null && dtbAdRequest.getAdSizes().size() > 0 && (dtbAdSize = dtbAdRequest.getAdSizes().get(0)) != null) {
            String slotUuid = dtbAdSize.getSlotUUID();
            ApsAdFormat apsAdFormat = ApsAdFormatUtils.getAdFormat(dtbAdSize.getDTBAdType(), dtbAdSize.getHeight(), dtbAdSize.getWidth());
            this.slotUuid = slotUuid;
            this.setApsAdFormat(apsAdFormat);
        }
    }

    public void setApsAdFormat(ApsAdFormat apsAdFormat) {
        ApsAdUtils.checkNullAndLogInvalidArg(new Object[]{apsAdFormat});
        try {
            this.apsAdFormat = apsAdFormat;
            this.apsAdFormatProperties = null;
            this.setAdSize();
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "API failure:ApsAdRequest - setApsAdFormat", e);
        }
    }

    public void setApsAdFormat(ApsAdFormat apsAdFormat, ApsAdFormatProperties apsAdFormatProperties) {
        ApsAdUtils.checkNullAndLogInvalidArg(new Object[]{apsAdFormat});
        try {
            this.apsAdFormat = apsAdFormat;
            this.apsAdFormatProperties = apsAdFormatProperties;
            this.setAdSize();
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "API failure:ApsAdRequest - setApsAdFormat", e);
        }
    }

    public void loadAd(@NonNull ApsAdRequestListener apsAdRequestListener) {
        ApsAdUtils.checkNullAndLogInvalidArg(apsAdRequestListener);
        try {
            this.loadPrivacyStrings();
            this.apsAdRequestListener = apsAdRequestListener;
            super.loadAd(this.dtbAdCallback);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "API failure:ApsAdRequest - loadAd", e);
        }
    }

    public void loadSmartBanner(@NonNull ApsAdRequestListener apsAdRequestListener) {
        ApsAdUtils.checkNullAndLogInvalidArg(apsAdRequestListener);
        this.apsAdRequestListener = apsAdRequestListener;
        try {
            this.loadPrivacyStrings();
            super.loadSmartBanner(this.dtbAdCallback);
        }
        catch (DTBLoadException | RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "API failure:ApsAdRequest - loadSmartBanner", e);
        }
    }

    public String getSlotUuid() {
        return this.slotUuid;
    }

    private void setAdSize() {
        int bannerWidth = ApsAdFormatUtils.getWidth(this.apsAdFormat);
        int bannerHeight = ApsAdFormatUtils.getHeight(this.apsAdFormat);
        switch (this.apsAdFormat) {
            case BANNER: 
            case LEADERBOARD: 
            case MREC: 
            case BANNER_SMART: {
                this.setSizes(new DTBAdSize(bannerWidth, bannerHeight, this.slotUuid));
                break;
            }
            case INTERSTITIAL: 
            case REWARDED_VIDEO: {
                this.setSizes(new DTBAdSize.DTBInterstitialAdSize(this.slotUuid));
                break;
            }
            case INSTREAM_VIDEO: {
                int playerWidth = this.apsAdFormatProperties != null ? this.apsAdFormatProperties.getPlayerWidth() : 320;
                int playerHeight = this.apsAdFormatProperties != null ? this.apsAdFormatProperties.getPlayerHeight() : 480;
                this.setSizes(new DTBAdSize.DTBVideo(playerWidth, playerHeight, this.slotUuid));
            }
        }
    }

    private void loadPrivacyStrings() {
        try {
            HashMap<String, String> privacyHashMap = Aps.getPrivacyHashmap();
            if (privacyHashMap.size() > 0) {
                for (Map.Entry<String, String> privacyEntry : privacyHashMap.entrySet()) {
                    this.putCustomTarget(privacyEntry.getKey(), privacyEntry.getValue());
                }
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error in ApsAdRequest - loadPrivacySettings", e);
        }
    }
}

