/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aps.ads;

import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import com.amazon.aps.ads.ApsAd;
import com.amazon.aps.ads.ApsAdUtils;
import com.amazon.aps.ads.listeners.ApsAdListener;
import com.amazon.aps.ads.model.ApsAdFormat;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.DTBAdBannerListener;
import com.amazon.device.ads.DTBAdInterstitialListener;
import com.amazon.device.ads.DTBAdView;
import java.lang.ref.WeakReference;

public class ApsAdView
extends DTBAdView {
    WeakReference<ApsAd> apsAdWeakReference;
    private final ApsAdListener apsAdListener;
    private boolean isAdAvailable = false;
    private final DTBAdInterstitialListener dtbAdInterstitialListener = new DTBAdInterstitialListener(){

        @Override
        public void onAdLoaded(View view) {
            ApsAdView.this.isAdAvailable = true;
            if (ApsAdView.this.apsAdListener != null) {
                ApsAdView.this.apsAdListener.onAdLoaded(ApsAdView.this.getApsAd());
            }
        }

        @Override
        public void onAdFailed(View view) {
            ApsAdView.this.isAdAvailable = false;
            if (ApsAdView.this.apsAdListener != null) {
                ApsAdView.this.apsAdListener.onAdFailedToLoad(ApsAdView.this.getApsAd());
            }
        }

        @Override
        public void onAdClicked(View view) {
            if (ApsAdView.this.apsAdListener != null) {
                ApsAdView.this.apsAdListener.onAdClicked(ApsAdView.this.getApsAd());
            }
        }

        @Override
        public void onAdLeftApplication(View view) {
        }

        @Override
        public void onAdOpen(View view) {
            if (ApsAdView.this.apsAdListener != null) {
                ApsAdView.this.apsAdListener.onAdOpen(ApsAdView.this.getApsAd());
            }
        }

        @Override
        public void onAdClosed(View view) {
            if (ApsAdView.this.apsAdListener != null) {
                ApsAdView.this.apsAdListener.onAdClosed(ApsAdView.this.getApsAd());
            }
        }

        @Override
        public void onImpressionFired(View view) {
            if (ApsAdView.this.apsAdListener != null) {
                ApsAdView.this.apsAdListener.onImpressionFired(ApsAdView.this.getApsAd());
            }
        }

        @Override
        public void onVideoCompleted(View view) {
            if (ApsAdView.this.apsAdListener != null) {
                ApsAdView.this.apsAdListener.onVideoCompleted(ApsAdView.this.getApsAd());
            }
        }

        @Override
        public void onAdError(View view) {
            if (ApsAdView.this.apsAdListener != null) {
                ApsAdView.this.apsAdListener.onAdError(ApsAdView.this.getApsAd());
            }
        }
    };
    private DTBAdBannerListener dtbAdBannerListener = new DTBAdBannerListener(){

        @Override
        public void onAdLoaded(View view) {
            ApsAdView.this.isAdAvailable = true;
            if (ApsAdView.this.apsAdListener != null) {
                ApsAdView.this.apsAdListener.onAdLoaded(ApsAdView.this.getApsAd());
            }
        }

        @Override
        public void onAdFailed(View view) {
            ApsAdView.this.isAdAvailable = false;
            if (ApsAdView.this.apsAdListener != null) {
                ApsAdView.this.apsAdListener.onAdFailedToLoad(ApsAdView.this.getApsAd());
            }
        }

        @Override
        public void onAdClicked(View view) {
            if (ApsAdView.this.apsAdListener != null) {
                ApsAdView.this.apsAdListener.onAdClicked(ApsAdView.this.getApsAd());
            }
        }

        @Override
        public void onAdLeftApplication(View view) {
        }

        @Override
        public void onAdOpen(View view) {
            if (ApsAdView.this.apsAdListener != null) {
                ApsAdView.this.apsAdListener.onAdOpen(ApsAdView.this.getApsAd());
            }
        }

        @Override
        public void onAdClosed(View view) {
            if (ApsAdView.this.apsAdListener != null) {
                ApsAdView.this.apsAdListener.onAdClosed(ApsAdView.this.getApsAd());
            }
        }

        @Override
        public void onImpressionFired(View view) {
            if (ApsAdView.this.apsAdListener != null) {
                ApsAdView.this.apsAdListener.onImpressionFired(ApsAdView.this.getApsAd());
            }
        }
    };

    public ApsAdView(@NonNull Context context, ApsAdFormat apsAdFormat, @NonNull ApsAdListener listener) {
        super(context);
        this.apsAdListener = listener;
        switch (apsAdFormat) {
            case BANNER: 
            case BANNER_SMART: 
            case MREC: 
            case LEADERBOARD: {
                this.initAdBannerListener(this.dtbAdBannerListener);
                break;
            }
            case INTERSTITIAL: 
            case REWARDED_VIDEO: {
                this.initAdInterstitialListener(this.dtbAdInterstitialListener);
            }
        }
    }

    private ApsAd getApsAd() {
        if (this.apsAdWeakReference != null) {
            return (ApsAd)this.apsAdWeakReference.get();
        }
        return null;
    }

    void fetchAd(ApsAd apsAd) {
        ApsAdUtils.checkNullAndLogInvalidArg(apsAd);
        try {
            apsAd.setAdView(this);
            this.apsAdWeakReference = new WeakReference<ApsAd>(apsAd);
            this.fetchAd(apsAd.getBidInfo(), apsAd.getRenderingBundle());
        }
        catch (RuntimeException e) {
            this.isAdAvailable = false;
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error in ApsAdView - fetchAd", e);
        }
    }

    public void setApsAd(ApsAd apsAd) {
        this.apsAdWeakReference = new WeakReference<ApsAd>(apsAd);
    }

    public boolean isAdAvailable() {
        return this.isAdAvailable;
    }

    @Override
    public void cleanup() {
        super.cleanup();
    }
}

