/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aps.ads.util;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.DisplayMetrics;
import com.amazon.aps.ads.Aps;
import com.amazon.aps.ads.ApsLog;
import com.amazon.aps.shared.ApsMetrics;
import com.amazon.aps.shared.metrics.model.ApsMetricsDeviceInfo;
import com.amazon.aps.shared.metrics.model.ApsMetricsSdkInfo;
import com.amazon.device.ads.DtbCommonUtils;
import com.amazon.device.ads.DtbDeviceData;
import com.amazon.device.ads.DtbDeviceDataRetriever;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/amazon/aps/ads/util/ApsUtils;", "", "()V", "Companion", "DTBAndroidSDK_release"})
public class ApsUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "ApsUtils";
    @NotNull
    private static final String AMAZON_SCHEME = "amzn";
    @NotNull
    private static final String AMAZON_APP_STORE_LINK = "https://www.amazon.com/gp/mas/dl/android?";
    @NotNull
    private static final String GOOGLE_PLAY_STORE_LINK = "https://play.google.com/store/apps/";

    private ApsUtils() {
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0016\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/amazon/aps/ads/util/ApsUtils$Companion;", "", "()V", "AMAZON_APP_STORE_LINK", "", "getAMAZON_APP_STORE_LINK", "()Ljava/lang/String;", "AMAZON_SCHEME", "getAMAZON_SCHEME", "GOOGLE_PLAY_STORE_LINK", "getGOOGLE_PLAY_STORE_LINK", "TAG", "getTAG", "directAppStoreLinkToBrowser", "", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "isNullOrEmpty", "", "s", "setupMetrics", "DTBAndroidSDK_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTAG() {
            return TAG;
        }

        @NotNull
        public final String getAMAZON_SCHEME() {
            return AMAZON_SCHEME;
        }

        @NotNull
        public final String getAMAZON_APP_STORE_LINK() {
            return AMAZON_APP_STORE_LINK;
        }

        @NotNull
        public final String getGOOGLE_PLAY_STORE_LINK() {
            return GOOGLE_PLAY_STORE_LINK;
        }

        public final void setupMetrics(@Nullable Context context) {
            Context context2 = context;
            if (context2 != null) {
                Context it = context2;
                boolean bl = false;
                DisplayMetrics metrics = new DisplayMetrics();
                String string = DtbCommonUtils.getSDKFramework();
                String string2 = DtbDeviceDataRetriever.isTablet() ? "tablet" : "phone";
                String string3 = DtbDeviceDataRetriever.getScreenSize(metrics, "portrait");
                String string4 = DtbDeviceData.getConnectionType();
                ApsMetrics.Companion.init(it, new ApsMetricsDeviceInfo(string, string3, string2, string4, null, 16, null), new ApsMetricsSdkInfo(Aps.getSdkVersion()));
            }
        }

        public final void directAppStoreLinkToBrowser(@NotNull Context context, @NotNull Uri uri) throws ActivityNotFoundException, NullPointerException {
            String string;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            if (Intrinsics.areEqual((Object)this.getAMAZON_SCHEME(), (Object)uri.getScheme())) {
                ApsLog.d(this.getTAG(), "Amazon app store unavailable in the device");
                string = Intrinsics.stringPlus((String)this.getAMAZON_APP_STORE_LINK(), (Object)uri.getQuery());
            } else {
                ApsLog.d(this.getTAG(), "App store unavailable in the device");
                string = this.getGOOGLE_PLAY_STORE_LINK() + uri.getHost() + '?' + uri.getQuery();
            }
            String redirectUrl = string;
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)redirectUrl));
            context.startActivity(intent);
        }

        public final boolean isNullOrEmpty(@Nullable String s) {
            return StringsKt.equals$default((String)s, null, (boolean)false, (int)2, null) || StringsKt.equals$default((String)s, (String)"", (boolean)false, (int)2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

