/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aps.ads.util.adview;

import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import com.amazon.aps.ads.util.ApsAdExtensionsKt;
import com.amazon.aps.ads.util.ApsUtils;
import com.amazon.aps.ads.util.adview.ApsAdViewBase;
import com.amazon.aps.ads.util.adview.ApsAdViewFetchUtils;
import com.amazon.aps.ads.util.adview.ApsAdViewWebBridge;
import com.amazon.aps.ads.util.adview.ApsAdWebViewClientListener;
import com.amazon.aps.ads.util.adview.ApsAdWebViewSupportClient;
import com.amazon.aps.ads.util.adview.ApsAdWebViewSupportClientBase;
import com.amazon.aps.ads.util.adview.ApsWebBridgeListener;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.ApsMetrics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.aps.shared.metrics.ApsMetricsPerfEventModelBuilder;
import com.amazon.device.ads.DTBAdMRAIDBannerController;
import com.amazon.device.ads.DTBAdMRAIDController;
import com.amazon.device.ads.DTBAdView;
import com.amazon.device.ads.DtbOmSdkSessionManager;
import com.amazon.device.ads.WebResourceOptions;
import com.amazon.device.ads.WebResourceService;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J$\u0010\u001c\u001a\u00020\u00182\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0010\u0010\u001f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001e\u0018\u00010 H\u0016J\u0012\u0010!\u001a\u00020\u00182\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0012\u0010!\u001a\u00020\u00182\b\u0010$\u001a\u0004\u0018\u00010\u001eH\u0016J\u001a\u0010!\u001a\u00020\u00182\b\u0010%\u001a\u0004\u0018\u00010\u001e2\b\u0010&\u001a\u0004\u0018\u00010#J(\u0010!\u001a\u00020\u00182\b\u0010$\u001a\u0004\u0018\u00010\u001e2\u0014\u0010'\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001e\u0012\u0004\u0012\u00020)0(H\u0016J\"\u0010!\u001a\u00020\u00182\u0018\u0010*\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u001e\u0012\u0006\u0012\u0004\u0018\u00010)\u0018\u00010(H\u0016J\u0010\u0010+\u001a\u00020\u00182\b\u0010,\u001a\u0004\u0018\u00010\u001eJ\u0016\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u001e2\u0006\u0010/\u001a\u00020#J\n\u00100\u001a\u0004\u0018\u000101H\u0016J\u0018\u00102\u001a\u0002032\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u00104\u001a\u000203H\u0002J\b\u00105\u001a\u00020\u0018H\u0014J\b\u00106\u001a\u00020\u000bH\u0016J\u0018\u00107\u001a\u00020\u00182\u0006\u00108\u001a\u00020\u001e2\u0006\u00109\u001a\u00020:H\u0004J\u0010\u0010;\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u001eH\u0016J\b\u0010<\u001a\u00020\u0018H\u0016J\b\u0010=\u001a\u00020\u0018H\u0014J\u0006\u0010>\u001a\u00020\u0018J$\u0010?\u001a\u00020\u00182\u0006\u0010@\u001a\u00020A2\n\u0010B\u001a\u00060:j\u0002`C2\u0006\u0010D\u001a\u00020\u001eH\u0016J\u0018\u0010E\u001a\u00020\u00182\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0014J\b\u0010J\u001a\u00020\u0018H\u0016J\u001a\u0010K\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u001e2\b\u0010L\u001a\u0004\u0018\u00010AH\u0016J\b\u0010M\u001a\u00020\u0018H\u0016J\u0010\u0010N\u001a\u00020\u00182\u0006\u0010H\u001a\u00020IH\u0014J\u0010\u0010O\u001a\u00020\u00182\u0006\u0010P\u001a\u00020\u000bH\u0014J\b\u0010Q\u001a\u00020\u0018H\u0014J\u0006\u0010R\u001a\u00020\u0018R\u0014\u0010\u0007\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006S"}, d2={"Lcom/amazon/aps/ads/util/adview/ApsAdViewImpl;", "Lcom/amazon/aps/ads/util/adview/ApsAdViewBase;", "Lcom/amazon/aps/ads/util/adview/ApsWebBridgeListener;", "Lcom/amazon/aps/ads/util/adview/ApsAdWebViewClientListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "adViewContext", "getAdViewContext", "()Landroid/content/Context;", "localOnly", "", "getLocalOnly", "()Z", "webBridge", "Lcom/amazon/aps/ads/util/adview/ApsAdViewWebBridge;", "value", "Lcom/amazon/aps/ads/util/adview/ApsAdWebViewSupportClientBase;", "webClient", "getWebClient", "()Lcom/amazon/aps/ads/util/adview/ApsAdWebViewSupportClientBase;", "setWebClient", "(Lcom/amazon/aps/ads/util/adview/ApsAdWebViewSupportClientBase;)V", "cleanup", "", "detectAdClick", "event", "Landroid/view/MotionEvent;", "evaluateApsJavascript", "script", "", "resultCallback", "Landroid/webkit/ValueCallback;", "fetchAd", "extras", "Landroid/os/Bundle;", "adHtml", "adHtmlArg", "extraData", "extra", "", "", "extraMap", "fetchAdWithLocation", "url", "getAdInfo", "adhtml", "adInfoBundle", "getApsMraidHandler", "Lcom/amazon/device/ads/DTBAdMRAIDController;", "handleClick", "", "time", "initWebView", "isTwoPartExpand", "loadLocalFile", "filename", "sb", "Ljava/lang/StringBuilder;", "loadUrl", "onAdLeftApplication", "onAdOpened", "onAdRemoved", "onCrash", "webView", "Landroid/webkit/WebView;", "errorInfo", "Lkotlin/text/StringBuilder;", "errorDetail", "onExposureChange", "exposurePercentage", "", "adViewRect", "Landroid/graphics/Rect;", "onLoadError", "onPageFinished", "view", "onPageLoaded", "onPositionChanged", "onViewabilityChanged", "isChanged", "setCurrentPositionProperty", "setIgnoreDetachment", "DTBAndroidSDK_release"})
public class ApsAdViewImpl
extends ApsAdViewBase
implements ApsWebBridgeListener,
ApsAdWebViewClientListener {
    @JvmField
    @Nullable
    protected ApsAdViewWebBridge webBridge;
    private final boolean localOnly;
    @Nullable
    private ApsAdWebViewSupportClientBase webClient;
    @NotNull
    private final Context adViewContext;

    public ApsAdViewImpl(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.localOnly = WebResourceOptions.isLocalSourcesOnly();
        this.adViewContext = context;
    }

    public final boolean getLocalOnly() {
        return this.localOnly;
    }

    @Nullable
    public final ApsAdWebViewSupportClientBase getWebClient() {
        return this.webClient;
    }

    protected final void setWebClient(@Nullable ApsAdWebViewSupportClientBase value) {
        ApsAdWebViewSupportClientBase apsAdWebViewSupportClientBase = value;
        if (apsAdWebViewSupportClientBase != null) {
            ApsAdWebViewSupportClientBase it = apsAdWebViewSupportClientBase;
            boolean bl = false;
            this.webClient = it;
            this.setWebViewClient(it);
        }
    }

    @Override
    protected void initWebView() {
        Object object;
        super.initWebView();
        ApsAdWebViewSupportClient it = object = new ApsAdWebViewSupportClient(this);
        boolean bl = false;
        this.setWebViewClient(it);
        this.setWebClient(it);
        this.setAdViewScrollEnabled(false);
        it = object = new ApsAdViewWebBridge(this);
        boolean bl2 = false;
        this.webBridge = it;
        this.addJavascriptInterface((Object)it, "amzn_bridge");
        WebResourceService.init();
        this.initLayoutListeners();
        this.setOnTouchListener((arg_0, arg_1) -> ApsAdViewImpl.initWebView$lambda-3(this, arg_0, arg_1));
    }

    public final void getAdInfo(@NotNull String adhtml, @NotNull Bundle adInfoBundle) {
        Intrinsics.checkNotNullParameter((Object)adhtml, (String)"adhtml");
        Intrinsics.checkNotNullParameter((Object)adInfoBundle, (String)"adInfoBundle");
        ApsAdViewFetchUtils.Companion.getAdInfo(adhtml, adInfoBundle);
    }

    public void fetchAd(@Nullable String adHtml, @NotNull Map<String, ? extends Object> extra) {
        Intrinsics.checkNotNullParameter(extra, (String)"extra");
        ApsAdViewFetchUtils.Companion.fetchAd(this, adHtml, extra);
    }

    public final void fetchAdWithLocation(@Nullable String url) {
        Context context = this.getContext();
        if (context != null) {
            Context it = context;
            boolean bl = false;
            ApsAdViewFetchUtils.Companion.fetchAdWithLocation(it, this, this.getLocalOnly(), url);
        }
    }

    @Override
    public void cleanup() {
        try {
            super.cleanup();
            this.removeJavascriptInterface("amzn_bridge");
            DtbOmSdkSessionManager dtbOmSdkSessionManager = this.getOmSdkManager();
            if (dtbOmSdkSessionManager != null) {
                dtbOmSdkSessionManager.stopOmAdSession();
            }
            DTBAdMRAIDController dTBAdMRAIDController = this.getMraidHandler();
            if (dTBAdMRAIDController != null) {
                DTBAdMRAIDController it = dTBAdMRAIDController;
                boolean bl = false;
                it.cleanup();
            }
            this.setMraidHandler(null);
        }
        catch (RuntimeException e) {
            ApsAdExtensionsKt.logEvent(this, APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error in ApsAdView cleanup", e);
        }
    }

    public final void onAdRemoved() {
        if (this.getMraidHandler() != null) {
            DTBAdMRAIDController dTBAdMRAIDController = this.getMraidHandler();
            Intrinsics.checkNotNull((Object)dTBAdMRAIDController);
            dTBAdMRAIDController.onAdRemoved();
        } else {
            ApsAdExtensionsKt.logEvent(this, APSEventSeverity.FATAL, APSEventType.LOG, "Null controller instance onAdRemoved");
        }
    }

    public void fetchAd(@Nullable Map<String, ? extends Object> extraMap) {
        Map<String, ? extends Object> map = extraMap;
        if (map == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String?, kotlin.Any>");
        }
        this.fetchAd(null, map);
    }

    public void fetchAd(@Nullable String adHtml) {
        this.fetchAd(adHtml, (Bundle)null);
    }

    public void fetchAd(@Nullable Bundle extras) {
        this.fetchAd(null, extras);
    }

    public final void fetchAd(@Nullable String adHtmlArg, @Nullable Bundle extraData) {
        String string;
        long fetchStartTime = System.currentTimeMillis();
        if (!ApsUtils.Companion.isNullOrEmpty(adHtmlArg)) {
            string = adHtmlArg;
        } else {
            Bundle bundle = extraData;
            string = bundle == null ? null : bundle.getString("bid_html_template", null);
        }
        String adHtml = string;
        DTBAdMRAIDController dTBAdMRAIDController = this.getMraidHandler();
        if (dTBAdMRAIDController != null) {
            DTBAdMRAIDController it = dTBAdMRAIDController;
            boolean bl = false;
            Bundle bundle = ApsAdViewFetchUtils.Companion.getBundleForFetchAd(it, adHtml, extraData);
            if (bundle != null) {
                Bundle bundle2 = bundle;
                boolean bl2 = false;
                this.setBidId(bundle2.getString("bid_identifier"));
                this.setHostname(bundle2.getString("hostname_identifier"));
                this.setVideo(bundle2.getBoolean("video_flag"));
            }
            this.setStartTime(new Date().getTime());
            ApsAdViewFetchUtils.Companion.fetchAd(this, it, adHtml, extraData);
        }
        ApsMetrics.Companion.adEvent(this.getBidId(), new ApsMetricsPerfEventModelBuilder().withBidId(this.getBidId()).withAdFetchStartTime(fetchStartTime));
    }

    public boolean detectAdClick(@Nullable MotionEvent event) {
        if (!this.isVideo() && event != null) {
            long l;
            int action = event.getAction();
            long time = new Date().getTime();
            switch (action) {
                case 1: {
                    l = this.handleClick(event, time);
                    break;
                }
                case 0: {
                    l = time;
                    break;
                }
                default: {
                    l = this.timePressed;
                }
            }
            this.timePressed = l;
        }
        return false;
    }

    private final long handleClick(MotionEvent event, long time) {
        if (time - this.timeClicked < 1000L) {
            return this.timePressed;
        }
        if (time - this.timePressed < 500L) {
            this.timeClicked = time;
            if (this.getMraidHandler() != null) {
                DTBAdMRAIDController dTBAdMRAIDController = this.getMraidHandler();
                Intrinsics.checkNotNull((Object)dTBAdMRAIDController);
                dTBAdMRAIDController.onAdClicked();
            } else {
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.LOG, "Null controller instance onAdClick callback");
            }
        }
        return 0L;
    }

    public final void setIgnoreDetachment() {
        this.ignoreDetachment = true;
    }

    protected final void loadLocalFile(@NotNull String filename, @NotNull StringBuilder sb) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        ApsAdViewFetchUtils.Companion.loadLocalFile(context, this.localOnly, filename, sb);
    }

    public void loadUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            ApsAdWebViewSupportClientBase apsAdWebViewSupportClientBase = this.webClient;
            if (apsAdWebViewSupportClientBase != null) {
                ApsAdWebViewSupportClientBase it = apsAdWebViewSupportClientBase;
                boolean bl = false;
                if (it.isCrashed()) {
                    ApsAdExtensionsKt.logEvent(this, APSEventSeverity.FATAL, APSEventType.LOG, Intrinsics.stringPlus((String)"WebView is corrupted. loadUrl method will not be executed. URL:", (Object)url));
                    return;
                }
                new Handler(Looper.getMainLooper()).post(() -> ApsAdViewImpl.loadUrl$lambda-9$lambda-8(this, url));
            }
        }
        catch (RuntimeException e) {
            ApsAdExtensionsKt.logEvent(this, APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Failed to execute loadUrl method", e);
        }
    }

    @Override
    @Nullable
    public DTBAdMRAIDController getApsMraidHandler() {
        return this.getMraidHandler();
    }

    @Override
    public void evaluateApsJavascript(@Nullable String script, @Nullable ValueCallback<String> resultCallback) {
        String string = script;
        if (string != null) {
            String it = string;
            boolean bl = false;
            new Handler(Looper.getMainLooper()).post(() -> ApsAdViewImpl.evaluateApsJavascript$lambda-11$lambda-10(this, script, resultCallback));
        }
    }

    @Override
    protected void onPositionChanged(@NotNull Rect adViewRect) {
        Intrinsics.checkNotNullParameter((Object)adViewRect, (String)"adViewRect");
        DTBAdMRAIDController dTBAdMRAIDController = this.getMraidHandler();
        if (dTBAdMRAIDController != null) {
            dTBAdMRAIDController.onPositionChanged(adViewRect);
        }
    }

    @Override
    protected void setCurrentPositionProperty() {
        DTBAdMRAIDController dTBAdMRAIDController = this.getMraidHandler();
        if (dTBAdMRAIDController != null) {
            dTBAdMRAIDController.setCurrentPositionProperty();
        }
    }

    @Override
    protected void onAdOpened() {
        DTBAdMRAIDController dTBAdMRAIDController = this.getMraidHandler();
        if (dTBAdMRAIDController != null) {
            dTBAdMRAIDController.onAdOpened();
        }
    }

    @Override
    protected void onViewabilityChanged(boolean isChanged) {
        DTBAdMRAIDController dTBAdMRAIDController = this.getMraidHandler();
        if (dTBAdMRAIDController != null) {
            dTBAdMRAIDController.onViewabilityChanged(isChanged);
        }
    }

    @Override
    protected void onExposureChange(int exposurePercentage, @NotNull Rect adViewRect) {
        Intrinsics.checkNotNullParameter((Object)adViewRect, (String)"adViewRect");
        DTBAdMRAIDController dTBAdMRAIDController = this.getMraidHandler();
        if (dTBAdMRAIDController != null) {
            dTBAdMRAIDController.fireExposureChange(exposurePercentage, adViewRect);
        }
    }

    @Override
    public void onPageLoaded() {
        DTBAdMRAIDController dTBAdMRAIDController = this.getMraidHandler();
        if (dTBAdMRAIDController != null) {
            dTBAdMRAIDController.onPageLoad();
        }
    }

    @Override
    public void onAdLeftApplication() {
        DTBAdMRAIDController dTBAdMRAIDController = this.getMraidHandler();
        if (dTBAdMRAIDController != null) {
            dTBAdMRAIDController.onAdLeftApplication();
        }
    }

    @Override
    public void onLoadError() {
        DTBAdMRAIDController dTBAdMRAIDController = this.getMraidHandler();
        if (dTBAdMRAIDController != null) {
            dTBAdMRAIDController.onLoadError();
        }
    }

    @Override
    public void onCrash(@NotNull WebView webView, @NotNull StringBuilder errorInfo, @NotNull String errorDetail) {
        Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
        Intrinsics.checkNotNullParameter((Object)errorInfo, (String)"errorInfo");
        Intrinsics.checkNotNullParameter((Object)errorDetail, (String)"errorDetail");
        try {
            if (webView instanceof DTBAdView) {
                String string;
                Object[] objectArray;
                String string2;
                Object it;
                String string3 = ((DTBAdView)webView).getSettings().getUserAgentString();
                if (string3 != null) {
                    it = string3;
                    boolean bl = false;
                    string2 = "webViewUserAgentInfo = %s;";
                    objectArray = new Object[]{it};
                    string = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(format, *args)");
                    errorInfo.append(string);
                }
                String string4 = this.getBidId();
                if (string4 != null) {
                    it = string4;
                    boolean bl = false;
                    string2 = "webViewBidId = %s;";
                    objectArray = new Object[]{this.getBidId()};
                    string = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(format, *args)");
                    errorInfo.append(string);
                }
                this.onAdRemoved();
                DTBAdMRAIDController dTBAdMRAIDController = this.getMraidHandler();
                if (dTBAdMRAIDController != null) {
                    it = dTBAdMRAIDController;
                    boolean bl = false;
                    DtbOmSdkSessionManager dtbOmSdkSessionManager = this.getOmSdkManager();
                    if (dtbOmSdkSessionManager != null) {
                        dtbOmSdkSessionManager.stopOmAdSession();
                    }
                }
                ViewParent viewParent = ((DTBAdView)webView).getParent();
                if (viewParent != null) {
                    it = viewParent;
                    boolean bl = false;
                    if (it instanceof ViewGroup) {
                        ((ViewGroup)it).removeView((View)this);
                    }
                }
                DTBAdMRAIDController dTBAdMRAIDController2 = this.getMraidHandler();
                if (dTBAdMRAIDController2 != null) {
                    it = dTBAdMRAIDController2;
                    boolean bl = false;
                    ((DTBAdMRAIDController)it).onLoadError();
                    this.cleanup();
                }
                webView.removeAllViews();
            }
            String string = errorDetail.substring(0, Math.min(100, errorDetail.length()));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String errorDetail2 = string;
            String string5 = "webViewErrorDetail = %s";
            Object[] objectArray = new Object[]{errorDetail2};
            string = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(format, *args)");
            errorInfo.append(string);
            ApsAdExtensionsKt.logEvent(this, APSEventSeverity.FATAL, APSEventType.EXCEPTION, errorInfo.toString());
        }
        catch (RuntimeException exception) {
            ApsAdExtensionsKt.logEvent(this, APSEventSeverity.FATAL, APSEventType.EXCEPTION, errorInfo.toString(), exception);
        }
    }

    @Override
    @NotNull
    public Context getAdViewContext() {
        return this.adViewContext;
    }

    @Override
    public void onPageFinished(@NotNull String url, @Nullable WebView view) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            ApsAdExtensionsKt.d(this, Intrinsics.stringPlus((String)"Page finished:", (Object)url));
            if (view instanceof DTBAdView) {
                if (StringsKt.contains$default((CharSequence)url, (CharSequence)"MRAID_ENV", (boolean)false, (int)2, null)) {
                    this.onPageLoaded();
                } else if (url.equals("https://c.amazon-adsystem.com/")) {
                    if (this.getMraidHandler() instanceof DTBAdMRAIDBannerController) {
                        DtbOmSdkSessionManager dtbOmSdkSessionManager = this.getOmSdkManager();
                        if (dtbOmSdkSessionManager != null) {
                            DtbOmSdkSessionManager it = dtbOmSdkSessionManager;
                            boolean bl = false;
                            it.stopOmAdSession();
                            if (this.isVideo()) {
                                it.initJavaScriptOmAdSession(this, url);
                            } else {
                                it.initHtmlDisplayOmAdSession(this, url);
                            }
                            it.registerAdView(this);
                            it.startAdSession();
                        }
                    }
                    this.onPageLoaded();
                }
            }
        }
        catch (RuntimeException e) {
            ApsAdExtensionsKt.logEvent(this, APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute onPageFinished method", e);
        }
    }

    @Override
    public boolean isTwoPartExpand() {
        boolean bl;
        if (this.getMraidHandler() != null) {
            DTBAdMRAIDController dTBAdMRAIDController = this.getMraidHandler();
            if (dTBAdMRAIDController == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.amazon.device.ads.DTBAdMRAIDController");
            }
            bl = dTBAdMRAIDController.isTwoPartExpand();
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean initWebView$lambda-3(ApsAdViewImpl this$0, View v, MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.detectAdClick(event);
    }

    private static final void loadUrl$lambda-9$lambda-8(ApsAdViewImpl this$0, String $url) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
        try {
            super.loadUrl($url);
        }
        catch (Exception e) {
            ApsAdExtensionsKt.logEvent(this$0, APSEventSeverity.FATAL, APSEventType.EXCEPTION, Intrinsics.stringPlus((String)"WebView crash noticed during super.loadUrl method. URL:", (Object)$url), e);
        }
    }

    private static final void evaluateApsJavascript$lambda-11$lambda-10(ApsAdViewImpl this$0, String $script, ValueCallback $resultCallback) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        super.evaluateJavascript($script, $resultCallback);
    }
}

