/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aps.ads.util.adview;

import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.net.Uri;
import com.amazon.aps.ads.util.ApsAdExtensionsKt;
import com.amazon.aps.ads.util.ApsUtils;
import com.amazon.aps.ads.util.adview.ApsAdWebViewClientListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0014J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0006H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/amazon/aps/ads/util/adview/ApsAdWebViewSchemeHandler;", "", "webviewClientListener", "Lcom/amazon/aps/ads/util/adview/ApsAdWebViewClientListener;", "(Lcom/amazon/aps/ads/util/adview/ApsAdWebViewClientListener;)V", "AMAZON_SCHEME", "", "MARKET_SCHEME", "MOBILE_SHOPPING_SCHEME", "MOBILE_SHOPPING_WEB_SCHEME", "MSHOP_PKG_NAME", "handleMarketAndAmazonScheme", "", "uri", "Landroid/net/Uri;", "handleMshopApp", "url", "handleMshopWeb", "launchIntent", "openUrl", "DTBAndroidSDK_release"})
public class ApsAdWebViewSchemeHandler {
    @NotNull
    private final ApsAdWebViewClientListener webviewClientListener;
    @NotNull
    private final String MSHOP_PKG_NAME;
    @NotNull
    private final String MOBILE_SHOPPING_WEB_SCHEME;
    @NotNull
    private final String MOBILE_SHOPPING_SCHEME;
    @NotNull
    private final String MARKET_SCHEME;
    @NotNull
    private final String AMAZON_SCHEME;

    public ApsAdWebViewSchemeHandler(@NotNull ApsAdWebViewClientListener webviewClientListener) {
        Intrinsics.checkNotNullParameter((Object)webviewClientListener, (String)"webviewClientListener");
        this.webviewClientListener = webviewClientListener;
        this.MSHOP_PKG_NAME = "com.amazon.mShop.android.shopping";
        this.MOBILE_SHOPPING_WEB_SCHEME = "com.amazon.mobile.shopping.web";
        this.MOBILE_SHOPPING_SCHEME = "com.amazon.mobile.shopping";
        this.MARKET_SCHEME = "market";
        this.AMAZON_SCHEME = "amzn";
    }

    public final boolean openUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            Uri uri;
            Uri uri2 = uri = this.uri(url);
            if (uri2 != null) {
                String string = uri2.getScheme();
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    String string2 = uri.getScheme();
                    return Intrinsics.areEqual((Object)string2, (Object)this.MOBILE_SHOPPING_WEB_SCHEME) ? this.handleMshopWeb(url) : (Intrinsics.areEqual((Object)string2, (Object)this.MOBILE_SHOPPING_SCHEME) ? this.handleMshopApp(url, uri) : ((Intrinsics.areEqual((Object)string2, (Object)this.MARKET_SCHEME) ? true : Intrinsics.areEqual((Object)string2, (Object)this.AMAZON_SCHEME)) ? this.handleMarketAndAmazonScheme(uri) : this.launchIntent(uri)));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @NotNull
    protected Uri uri(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Uri uri = Uri.parse((String)url);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(url)");
        return uri;
    }

    protected boolean handleMshopWeb(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        int index = StringsKt.indexOf$default((CharSequence)url, (String)"//", (int)0, (boolean)false, (int)6, null);
        if (index >= 0 && index + 2 < url.length()) {
            String string = url.substring(index + 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            String address = string;
            String temp = Intrinsics.stringPlus((String)"https://", (Object)address);
            Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)temp));
            this.webviewClientListener.getAdViewContext().startActivity(browserIntent);
            this.webviewClientListener.onAdLeftApplication();
            return true;
        }
        return false;
    }

    protected boolean handleMshopApp(@NotNull String url, @NotNull Uri uri) {
        int index;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(uri);
        if (this.webviewClientListener.getAdViewContext().getPackageManager().getLaunchIntentForPackage(this.MSHOP_PKG_NAME) == null && (index = StringsKt.indexOf$default((CharSequence)url, (String)"products/", (int)0, (boolean)false, (int)6, null)) > 0) {
            String string = url.substring(index + "products/".length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            String webAddress = Intrinsics.stringPlus((String)"https://www.amazon.com/dp/", (Object)string);
            intent.setData(Uri.parse((String)webAddress));
        }
        this.webviewClientListener.getAdViewContext().startActivity(intent);
        this.webviewClientListener.onAdLeftApplication();
        return true;
    }

    protected boolean handleMarketAndAmazonScheme(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(uri);
            this.webviewClientListener.getAdViewContext().startActivity(intent);
            this.webviewClientListener.onAdLeftApplication();
        }
        catch (ActivityNotFoundException e) {
            try {
                ApsUtils.Companion.directAppStoreLinkToBrowser(this.webviewClientListener.getAdViewContext(), uri);
                this.webviewClientListener.onAdLeftApplication();
            }
            catch (RuntimeException e2) {
                ApsAdExtensionsKt.d(this, "App stores and browsers not found");
                return false;
            }
        }
        return true;
    }

    protected boolean launchIntent(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(uri);
        this.webviewClientListener.getAdViewContext().startActivity(intent);
        this.webviewClientListener.onAdLeftApplication();
        return true;
    }
}

