/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aps.shared.analytics;

import android.content.Context;
import android.os.Build;
import android.util.Base64;
import android.util.Log;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.util.APSSharedUtil;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import org.json.JSONException;
import org.json.JSONObject;

public class APSEvent
implements Serializable {
    public static final int EXCEPTION_LOG_SIZE = 2048;
    String sdkVersion = null;
    String eventType;
    long timestamp;
    APSEventSeverity severity;
    String pkgName = "";
    String osName = "";
    int osVersion;
    String deviceManufacturer = "";
    String deviceModel = "";
    String configVersion = "";
    String errorDetails = "";
    String exceptionLog = "";

    public APSEvent(Context context, APSEventSeverity severity, String eventType) {
        try {
            this.sdkVersion = APSAnalytics.getVersion();
            String adapterVersion = APSAnalytics.getAdapterVersion();
            if (adapterVersion != null) {
                this.sdkVersion = this.sdkVersion + "_" + adapterVersion;
            }
            this.osName = "Android";
            this.osVersion = Build.VERSION.SDK_INT;
            this.deviceManufacturer = Build.MANUFACTURER;
            this.deviceModel = Build.MODEL;
            this.timestamp = System.currentTimeMillis();
            this.pkgName = context == null ? "unknown" : context.getPackageName();
            this.setEventSeverity(severity);
            this.setEventType(eventType);
        }
        catch (RuntimeException e) {
            Log.e((String)"APSEvent", (String)"Error constructing the APSEvent:", (Throwable)e);
        }
    }

    public APSEvent setEventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    public APSEvent setEventSeverity(APSEventSeverity serverity) {
        this.severity = serverity;
        return this;
    }

    public APSEvent setExceptionDetails(Exception e) {
        if (e != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                String stackTrace = sw.toString();
                if (stackTrace.length() > 2048) {
                    int chunkSize = (2048 - e.getMessage().length() - "...".length() * 2) / 2;
                    String upperPart = stackTrace.substring(0, chunkSize);
                    String lowerPart = stackTrace.substring(stackTrace.length() - chunkSize);
                    this.exceptionLog = e.getMessage() + "..." + upperPart + "..." + lowerPart;
                } else {
                    this.exceptionLog = e.getMessage() + "\n" + stackTrace;
                }
            }
            catch (RuntimeException ex) {
                Log.e((String)"APSEvent", (String)"Error in parsing the exception detail; ", (Throwable)ex);
            }
        }
        return this;
    }

    public APSEvent setExceptionDetails(String exceptionDetail) {
        int size;
        int n = size = 2048 > exceptionDetail.length() ? exceptionDetail.length() : 2048;
        if (exceptionDetail != null) {
            this.exceptionLog = exceptionDetail.substring(0, size);
        }
        return this;
    }

    public APSEvent setErrorDetails(String errorDetails) {
        if (errorDetails != null) {
            int errorDetailsLength = errorDetails.length();
            if (errorDetailsLength > 2048) {
                errorDetailsLength = 2048;
            }
            this.errorDetails = errorDetails.substring(0, errorDetailsLength);
        }
        return this;
    }

    public APSEvent setConfigVersion(String configVersion) {
        this.configVersion = configVersion;
        return this;
    }

    public APSEvent setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public APSEvent build() {
        return this;
    }

    public APSEventSeverity getEventSeverity() {
        return this.severity;
    }

    public String getExceptionDetails() {
        return this.exceptionLog;
    }

    public String getEventType() {
        return this.eventType;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isValidEvent() {
        return this.eventType != null;
    }

    public String toJsonPayload() {
        String base64 = "";
        String otherDetails = String.format("msg = %s;", this.errorDetails);
        String additionalDetails = APSAnalytics.getAdditionalDetails();
        if (!APSSharedUtil.isNullOrEmpty(additionalDetails)) {
            otherDetails = otherDetails.concat(additionalDetails);
        }
        try {
            JSONObject json = new JSONObject();
            json.put("sdkVersion", (Object)this.sdkVersion);
            json.put("eventType", (Object)this.eventType);
            json.put("eventTimestamp", this.timestamp);
            json.put("severity", (Object)this.severity.name());
            json.put("appId", (Object)this.pkgName);
            json.put("osName", (Object)this.osName);
            json.put("osVersion", this.osVersion);
            json.put("deviceManufacturer", (Object)this.deviceManufacturer);
            json.put("deviceModel", (Object)this.deviceModel);
            json.put("configVersion", (Object)this.configVersion);
            json.put("otherDetails", (Object)otherDetails);
            json.put("exceptionDetails", (Object)this.exceptionLog);
            String strVal = json.toString();
            base64 = Base64.encodeToString((byte[])strVal.getBytes(), (int)0).replace("\n", "");
        }
        catch (RuntimeException | JSONException e) {
            Log.e((String)"APSEvent", (String)"Error in parsing the json .. ignoring : ", (Throwable)e);
        }
        String inputData = "{\"Data\": \"" + base64 + "\",\"PartitionKey\": \"" + this.timestamp + "\"}";
        return inputData;
    }
}

