/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aps.shared.util;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.amazon.aps.shared.util.APSSharedUtil;
import com.amazon.aps.shared.util.ApsResult;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ApsAsyncUtil {
    private static final String TAG = ApsAsyncUtil.class.getSimpleName();
    private static ApsAsyncUtil INSTANCE;
    private boolean shutdownInProgress = false;
    private final ExecutorService executorService = Executors.newFixedThreadPool(1);

    private ApsAsyncUtil() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    ApsAsyncUtil.this.shutdownInProgress = true;
                    Log.d((String)TAG, (String)"App is shutting down, terminating the thread executor");
                    ApsAsyncUtil.this.executorService.shutdown();
                }
                catch (RuntimeException e) {
                    Log.e((String)TAG, (String)"Error in stopping the executor", (Throwable)e);
                }
            }
        });
    }

    public static ApsAsyncUtil getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ApsAsyncUtil();
        }
        return INSTANCE;
    }

    public <T> void runOnUiThreadAndAsyncCallback(ApsReturnRunnable<T> apsReturnRunnable, ApsExecutionListener<T> apsExecutionListener) {
        APSSharedUtil.checkNullAndThrowException(apsReturnRunnable);
        try {
            if (!this.shutdownInProgress) {
                new Handler(Looper.getMainLooper()).post(() -> {
                    Object returnVal = null;
                    try {
                        returnVal = apsReturnRunnable.run();
                    }
                    catch (RuntimeException e) {
                        returnVal = null;
                    }
                    if (apsExecutionListener != null) {
                        Object finalReturnVal = returnVal;
                        ApsAsyncUtil.getInstance().runAsyncAndCallback(() -> finalReturnVal, apsExecutionListener);
                    }
                });
            }
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)"Error running the thread", (Throwable)e);
        }
    }

    public synchronized <T> void runAsyncAndCallbackOnUiThread(ApsReturnRunnable<T> apsReturnRunnable, ApsExecutionListener<T> apsExecutionListener) {
        APSSharedUtil.checkNullAndThrowException(apsReturnRunnable, apsExecutionListener);
        try {
            if (!this.shutdownInProgress) {
                this.executorService.execute(() -> {
                    ApsResult result = ApsResult.FAILURE;
                    Object returnVal = null;
                    try {
                        returnVal = apsReturnRunnable.run();
                        result = ApsResult.SUCCESS;
                    }
                    catch (Exception e) {
                        Log.e((String)TAG, (String)"Error running the thread", (Throwable)e);
                    }
                    finally {
                        ApsResult finalResult = result;
                        Object finalReturnVal = returnVal;
                        new Handler(Looper.getMainLooper()).post(() -> {
                            if (apsExecutionListener != null) {
                                apsExecutionListener.onExecutionCompleted(finalResult, finalReturnVal);
                            }
                        });
                    }
                });
            }
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)"Error running the thread", (Throwable)e);
        }
    }

    public synchronized <T> void runAsyncAndCallback(ApsReturnRunnable<T> apsReturnRunnable, ApsExecutionListener<T> apsExecutionListener) {
        APSSharedUtil.checkNullAndThrowException(apsReturnRunnable);
        try {
            if (!this.shutdownInProgress) {
                this.executorService.execute(() -> {
                    ApsResult result = ApsResult.FAILURE;
                    Object returnVal = null;
                    try {
                        returnVal = apsReturnRunnable.run();
                        result = ApsResult.SUCCESS;
                    }
                    catch (Exception e) {
                        Log.e((String)TAG, (String)"Error running the thread", (Throwable)e);
                    }
                    finally {
                        if (apsExecutionListener != null) {
                            apsExecutionListener.onExecutionCompleted(result, returnVal);
                        }
                    }
                });
            }
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)"Error running the thread", (Throwable)e);
        }
    }

    public static interface ApsExecutionListener<T> {
        public void onExecutionCompleted(ApsResult var1, T var2);
    }

    public static interface ApsReturnRunnable<T> {
        public T run();
    }
}

