/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Bundle;
import com.amazon.device.ads.DTBActivityListener;
import java.lang.ref.WeakReference;

public class ActivityMonitor
implements Application.ActivityLifecycleCallbacks {
    private WeakReference<Activity> currentActivity;
    private DTBActivityListener activityListener;
    private static ActivityMonitor theInstance;

    ActivityMonitor(Context context) {
        if (context != null) {
            Application application = (Application)context.getApplicationContext();
            if (application != null) {
                this.setCurrentActivity(context);
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            }
            theInstance = this;
        }
    }

    Activity getCurrentActivity() {
        if (this.currentActivity != null) {
            return (Activity)this.currentActivity.get();
        }
        return null;
    }

    static ActivityMonitor getInstance() {
        return theInstance;
    }

    void setActivityListener(DTBActivityListener activityListener) {
        this.activityListener = activityListener;
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        this.currentActivity = new WeakReference<Activity>(activity);
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        this.currentActivity = new WeakReference<Activity>(activity);
        if (this.activityListener != null) {
            this.activityListener.onActivityResumed(activity);
        }
    }

    public void onActivityPaused(Activity activity) {
        if (this.activityListener != null) {
            this.activityListener.onActivityPaused(activity);
        }
    }

    public void onActivityStopped(Activity activity) {
        if (this.activityListener != null) {
            this.activityListener.onActivityStopped(activity);
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        if (this.activityListener != null) {
            this.activityListener.onActivityDestroyed(activity);
            if (this.getCurrentActivity() == activity) {
                this.currentActivity = null;
            }
        }
    }

    void setCurrentActivity(Context context) {
        if (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                this.currentActivity = new WeakReference<Activity>((Activity)context);
            } else {
                this.setCurrentActivity(((ContextWrapper)context).getBaseContext());
            }
        }
    }
}

