/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import com.amazon.aps.ads.ApsLog;
import com.amazon.aps.ads.ApsMigrationUtil;
import com.amazon.aps.ads.model.ApsLogLevel;
import com.amazon.aps.ads.util.ApsUtils;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.ApsMetrics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.ActivityMonitor;
import com.amazon.device.ads.AdProvider;
import com.amazon.device.ads.AdType;
import com.amazon.device.ads.DTBAdNetworkInfo;
import com.amazon.device.ads.DTBAdRequest;
import com.amazon.device.ads.DTBAdSize;
import com.amazon.device.ads.DTBAdUtil;
import com.amazon.device.ads.DTBBannerType;
import com.amazon.device.ads.DTBCacheData;
import com.amazon.device.ads.DTBGDPREncoder;
import com.amazon.device.ads.DTBLogLevel;
import com.amazon.device.ads.DTBMetricsConfiguration;
import com.amazon.device.ads.DTBSlotType;
import com.amazon.device.ads.DtbCommonUtils;
import com.amazon.device.ads.DtbDeviceDataRetriever;
import com.amazon.device.ads.DtbDeviceRegistration;
import com.amazon.device.ads.DtbLog;
import com.amazon.device.ads.DtbOmSdkSessionManager;
import com.amazon.device.ads.DtbSharedPreferences;
import com.amazon.device.ads.EventDistributor;
import com.amazon.device.ads.MRAIDPolicy;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class AdRegistration {
    private static final String LOGTAG = AdRegistration.class.getSimpleName();
    private static AdRegistration adRegistrationInstance = null;
    private static String mAppKey;
    private static Context mContext;
    private static boolean testMode;
    private static boolean locationEnabled;
    private static boolean isOmSdkActivated;
    private static Integer initCount;
    private static String currentVendorListString;
    private static ConsentStatus currentConsentStatus;
    private static CMPFlavor cmpFlavor;
    private static boolean consentStringDirty;
    private static String lastSeenNonIABEncodedConsentString;
    private static String sdkDistributionPlace;
    private ActivityMonitor activityMonitor;
    private static HashMap<String, SlotGroup> groups;
    static MRAIDPolicy mraidPolicy;
    static String[] serverlessMarkers;
    private Set<AdProvider> providers = new HashSet<AdProvider>();
    private EventDistributor eventDistributor = new EventDistributor();
    static List<String> providersProprietaryKeys;
    private static Map<String, String> customDictionary;
    private static Map<String, DTBCacheData> adMobRequestIdMap;

    private ActivityMonitor getActivityMonitor() {
        return this.activityMonitor;
    }

    private void setActivityMonitor(ActivityMonitor monitor) {
        this.activityMonitor = monitor;
    }

    public static Activity getCurrentActivity() {
        return adRegistrationInstance.getActivityMonitor().getCurrentActivity();
    }

    public static void addProvider(AdProvider provider) {
        if (adRegistrationInstance != null) {
            Class<?> clz = provider.getClass();
            for (AdProvider temp : AdRegistration.adRegistrationInstance.providers) {
                if (!temp.getClass().equals(clz)) continue;
                return;
            }
        } else {
            throw new IllegalStateException("Instance must be initialized prior to adding providers");
        }
        AdRegistration.adRegistrationInstance.providers.add(provider);
        AdRegistration.appendProprietaryProviderKeys(provider.getProprietaryKeys());
    }

    @Deprecated
    public static EventDistributor getEventDistributer() {
        if (adRegistrationInstance != null) {
            return AdRegistration.adRegistrationInstance.eventDistributor;
        }
        throw new IllegalStateException("Instance must be initialized prior using getEventDistributer API");
    }

    public static Set<AdProvider> getAdProviders() {
        if (adRegistrationInstance != null) {
            return AdRegistration.adRegistrationInstance.providers;
        }
        return null;
    }

    static void appendProprietaryProviderKeys(String[] keys) {
        if (providersProprietaryKeys == null) {
            providersProprietaryKeys = new ArrayList<String>();
        }
        for (String key : keys) {
            providersProprietaryKeys.add(key);
        }
    }

    public static List<String> getProprietaryProviderKeys() {
        if (providersProprietaryKeys == null) {
            providersProprietaryKeys = new ArrayList<String>();
        }
        return providersProprietaryKeys;
    }

    private AdRegistration(String appKey, Context context) throws IllegalArgumentException {
        String usedVersion;
        if (context == null || appKey == null || "".equals(appKey.trim())) {
            IllegalArgumentException e = new IllegalArgumentException("Invalid parameters for initialization.");
            DtbLog.fatal(LOGTAG, "mDTB SDK initialize failed due to invalid registration parameters.", e);
            throw e;
        }
        try {
            Class.forName("com.amazon.aps.shared.APSAnalytics");
        }
        catch (ClassNotFoundException classNotFoundException) {
            IllegalArgumentException illegalArgumentExceptionForSharedLib = new IllegalArgumentException("Missing APSAndroidShared SDK. Please import the APSAndroidShared SDK to your project. For further details, please refer to our Android SDK documentation.");
            DtbLog.fatal(LOGTAG, "Missing APSAndroidShared SDK. Please import the APSAndroidShared SDK to your project. For further details, please refer to our Android SDK documentation.", illegalArgumentExceptionForSharedLib);
            throw illegalArgumentExceptionForSharedLib;
        }
        mAppKey = appKey;
        mContext = context.getApplicationContext();
        APSAnalytics.init(mContext);
        APSAnalytics.setVersion(AdRegistration.getVersion());
        ApsUtils.Companion.setupMetrics(mContext);
        DtbSharedPreferences prefs = DtbSharedPreferences.createInstance();
        int permission2 = context.checkCallingOrSelfPermission("android.permission.INTERNET");
        if (context.checkCallingOrSelfPermission("android.permission.INTERNET") == -1) {
            DtbLog.error(LOGTAG, "Network task cannot commence because the INTERNET permission is missing from the app's manifest.");
        }
        if ((usedVersion = prefs.getVersionInUse()) == null || DtbCommonUtils.isNullOrEmpty(usedVersion)) {
            prefs.setVersionInUse("9.9.1");
        }
        DtbOmSdkSessionManager.activateOMSDK(mContext);
        currentConsentStatus = ConsentStatus.CONSENT_NOT_DEFINED;
        cmpFlavor = CMPFlavor.CMP_NOT_DEFINED;
        consentStringDirty = false;
        customDictionary = new HashMap<String, String>();
        JSONObject distributionJson = DTBAdUtil.loadJsonFromAsset("aps_distribution_marker.json");
        if (distributionJson != null) {
            try {
                sdkDistributionPlace = distributionJson.getString("distribution");
            }
            catch (Exception ex) {
                DtbLog.warn("Unable to get distribution place value");
            }
        }
    }

    public static String getAppKey() {
        return mAppKey;
    }

    public static boolean isInitialized() {
        return adRegistrationInstance != null;
    }

    public static AdRegistration getInstance(@NonNull String appKey, @NonNull Context context) throws IllegalArgumentException {
        if (!AdRegistration.isInitialized()) {
            adRegistrationInstance = new AdRegistration(appKey, context);
            DTBMetricsConfiguration.getInstance();
            if (DTBMetricsConfiguration.getInstance().isFeatureEnabled("config_in_init")) {
                DtbDeviceRegistration.verifyRegistration();
            }
        } else if (appKey != null) {
            if (!appKey.equals(mAppKey)) {
                mAppKey = appKey;
                DtbSharedPreferences dtbSharedPreferences = DtbSharedPreferences.createInstance();
            }
        }
        adRegistrationInstance.setActivityMonitor(new ActivityMonitor(context));
        String eventName = ApsMigrationUtil.getIsApsInitCalled() ? "apsInitCall" : "initCall";
        initCount = initCount + 1;
        ApsMetrics.customEvent(eventName, String.valueOf(initCount), null);
        return adRegistrationInstance;
    }

    @Deprecated
    public static void setAppKey(@NonNull String appKey) throws IllegalArgumentException {
        if (!AdRegistration.isInitialized()) {
            throw new IllegalStateException("mDTB was not initialized, please use AdRegistration.getInstance(...) before using other SDK calls");
        }
        if (DtbCommonUtils.isNullOrEmpty(appKey)) {
            IllegalArgumentException e = new IllegalArgumentException("Invalid parameters:appKey for initialization.");
            DtbLog.fatal(LOGTAG, "mDTB SDK initialize failed due to invalid registration parameter:appKey.", e);
            throw e;
        }
        mAppKey = appKey;
        DtbSharedPreferences dtbSharedPreferences = DtbSharedPreferences.createInstance();
    }

    @Deprecated
    public static void setContext(Context context) {
        if (context == null) {
            IllegalArgumentException e = new IllegalArgumentException("Invalid parameters:context for initialization.");
            DtbLog.fatal(LOGTAG, "mDTB SDK initialize failed due to invalid registration parameter:context.", e);
            throw e;
        }
        mContext = context.getApplicationContext();
    }

    public static Context getContext() {
        return mContext;
    }

    public static void setMRAIDPolicy(MRAIDPolicy policy) {
        mraidPolicy = policy;
        DTBAdRequest.resetMraid();
    }

    public static MRAIDPolicy getMRAIDPolicy() {
        return mraidPolicy;
    }

    public static void setMRAIDSupportedVersions(String[] versions) {
        DTBAdRequest.setMRAIDSupportedVersions(versions);
    }

    public static void enableLogging(boolean enable) {
        try {
            if (enable) {
                DtbLog.setLogLevel(DTBLogLevel.All);
                ApsLog.setLogLevel(ApsLogLevel.values()[DTBLogLevel.All.intValue()]);
            } else {
                DtbLog.setLogLevel(DTBLogLevel.Error);
                ApsLog.setLogLevel(ApsLogLevel.values()[DTBLogLevel.Error.intValue()]);
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute enableLogging method", e);
        }
    }

    public static void enableLogging(boolean enable, DTBLogLevel logLevel) {
        try {
            if (enable) {
                DtbLog.setLogLevel(logLevel);
                ApsLog.setLogLevel(ApsLogLevel.values()[logLevel.intValue()]);
            } else {
                DtbLog.setLogLevel(DTBLogLevel.Error);
            }
        }
        catch (RuntimeException e) {
            DtbLog.error(LOGTAG, "Fail to execute enableLogging method with logLevel argument");
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute enableLogging method with logLevel argument", e);
        }
    }

    public static void enableTesting(boolean isTesting) {
        try {
            if (!isTesting) {
                testMode = false;
            } else {
                boolean isInstalledFromAppStore = DTBAdUtil.isInstalledFromAppStore(mContext);
                if (!isInstalledFromAppStore) {
                    testMode = isTesting;
                    DtbLog.enableCallerInfo(isTesting);
                }
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute enableTesting method", e);
        }
    }

    public static boolean isTestMode() {
        return testMode;
    }

    public static void useGeoLocation(boolean isLocationEnabled) {
        locationEnabled = isLocationEnabled;
    }

    public static boolean isLocationEnabled() {
        return locationEnabled;
    }

    public static String getVersion() {
        return DtbCommonUtils.getSDKVersion();
    }

    static String getSDKDistributionPlace() {
        return sdkDistributionPlace;
    }

    static String[] getServerlessMarkers() {
        return serverlessMarkers;
    }

    @Deprecated
    public static void setServerlessMarkers(String[] markers) {
        serverlessMarkers = markers;
    }

    public static void addSlotGroup(SlotGroup sg) {
        try {
            if (groups == null) {
                groups = new HashMap();
            }
            groups.put(sg.name, sg);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to execute addSlotGroup method", e);
        }
    }

    public static SlotGroup getSlotGroup(String name) {
        try {
            if (name != null && groups != null) {
                return groups.get(name);
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute getSlotGroup method", e);
        }
        return null;
    }

    static boolean hasAdapters() {
        for (String name : serverlessMarkers) {
            try {
                Class<?> clz = Class.forName(name);
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    @Deprecated
    public static boolean isConsentStatusUnknown() {
        try {
            return currentConsentStatus == ConsentStatus.CONSENT_NOT_DEFINED || currentConsentStatus == ConsentStatus.UNKNOWN || DtbSharedPreferences.getInstance().getVendorList() == null;
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute isConsentStatusUnknown method", e);
            return true;
        }
    }

    static ConsentStatus getConsentStatus() {
        if (!AdRegistration.isInitialized()) {
            throw new IllegalStateException("mDTB was not initialized, please use AdRegistration.getInstance(...) before using other SDK calls");
        }
        String consentStatusAsString = DtbSharedPreferences.getInstance().getConsentStatus();
        if (consentStatusAsString == null) {
            return currentConsentStatus;
        }
        return ConsentStatus.valueOf(consentStatusAsString);
    }

    static CMPFlavor getCMPFlavor() {
        if (!AdRegistration.isInitialized()) {
            throw new IllegalStateException("mDTB was not initialized, please use AdRegistration.getInstance(...) before using other SDK calls");
        }
        String cmpFlavor = DtbSharedPreferences.getInstance().getCMPFlavor();
        if (cmpFlavor == null) {
            return AdRegistration.cmpFlavor;
        }
        return CMPFlavor.valueOf(cmpFlavor);
    }

    @Deprecated
    public static void setVendorList(List<Integer> vendorList) {
        if (!AdRegistration.isInitialized()) {
            throw new IllegalStateException("mDTB was not initialized, please use AdRegistration.getInstance(...) before using other SDK calls");
        }
        try {
            if (vendorList == null) {
                DtbLog.error(LOGTAG, "Set vendor list failed due to invalid vendor list parameters with value null.");
                return;
            }
            String encodedString = AdRegistration.getStringFromVendorList(vendorList);
            if (currentVendorListString != null && currentVendorListString.equals(encodedString)) {
                return;
            }
            consentStringDirty = true;
            currentVendorListString = encodedString;
            DtbSharedPreferences.getInstance().saveVendorList(encodedString);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute setVendorList method", e);
        }
    }

    @Deprecated
    public static void setConsentStatus(ConsentStatus consentStatus) {
        if (!AdRegistration.isInitialized()) {
            throw new IllegalStateException("mDTB was not initialized, please use AdRegistration.getInstance(...) before using other SDK calls");
        }
        try {
            if (consentStatus == ConsentStatus.CONSENT_NOT_DEFINED) {
                DtbLog.error(LOGTAG, "Set consent status failed due to invalid consent status parameters. Not allowed to set consent not defined.");
                return;
            }
            if (currentConsentStatus != null && currentConsentStatus == consentStatus) {
                return;
            }
            consentStringDirty = true;
            currentConsentStatus = consentStatus;
            DtbSharedPreferences.getInstance().saveConsentStatus(consentStatus.name());
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute setConsentStatus method", e);
        }
    }

    @Deprecated
    public static void setCMPFlavor(CMPFlavor cFlavor) {
        if (!AdRegistration.isInitialized()) {
            throw new IllegalStateException("mDTB was not initialized, please use AdRegistration.getInstance(...) before using other SDK calls");
        }
        try {
            if (cFlavor == CMPFlavor.CMP_NOT_DEFINED) {
                DtbLog.error(LOGTAG, "Set cmp type failed due to invalid cmp type parameters. Not allowed to set cmp type to not defined.");
                return;
            }
            if (cmpFlavor != null && cmpFlavor == cFlavor) {
                return;
            }
            consentStringDirty = true;
            cmpFlavor = cFlavor;
            DtbSharedPreferences.getInstance().saveCMPFlavor(cFlavor.name());
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute setCMPFlavor method", e);
        }
    }

    static String getEncodedNonIABString() {
        if (consentStringDirty) {
            List<Integer> vendorList;
            String vendorListString = DtbSharedPreferences.getInstance().getVendorList();
            String consentStatusString = DtbSharedPreferences.getInstance().getConsentStatus();
            String cmpFlavorString = DtbSharedPreferences.getInstance().getCMPFlavor();
            String encodedString = "";
            if (!(vendorListString == null && consentStatusString == null && cmpFlavorString == null || DtbCommonUtils.isNullOrEmpty(encodedString = DTBGDPREncoder.getEncodedNonIABConsentString(vendorList = AdRegistration.getVendorListFromString(vendorListString))))) {
                DtbSharedPreferences.getInstance().saveNonIABCustomConsent(encodedString);
            }
            consentStringDirty = false;
            lastSeenNonIABEncodedConsentString = encodedString;
            return encodedString;
        }
        return lastSeenNonIABEncodedConsentString;
    }

    @Deprecated
    public static void resetNonIAB() {
        try {
            DtbSharedPreferences.getInstance().removeCMPFlavor();
            DtbSharedPreferences.getInstance().removeConsentStatus();
            DtbSharedPreferences.getInstance().removeVendorList();
            DtbSharedPreferences.getInstance().removeNonIABCustomConsent();
            currentVendorListString = null;
            currentConsentStatus = ConsentStatus.CONSENT_NOT_DEFINED;
            cmpFlavor = CMPFlavor.CMP_NOT_DEFINED;
            consentStringDirty = false;
            lastSeenNonIABEncodedConsentString = null;
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute resetNonIAB method", e);
        }
    }

    private static String getStringFromVendorList(List<Integer> vendorList) {
        return vendorList.toString();
    }

    private static List<Integer> getVendorListFromString(String vendorListString) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (vendorListString != null && vendorListString.length() > 2) {
            String[] numsAsString;
            vendorListString = vendorListString.substring(1, vendorListString.length() - 1);
            for (String num : numsAsString = vendorListString.split(",")) {
                result.add(Integer.parseInt(num.trim()));
            }
            return result;
        }
        return result;
    }

    public static void setAdNetworkInfo(DTBAdNetworkInfo dtbAdNetworkInfo) {
        try {
            AdRegistration.addCustomAttribute("mediationName", dtbAdNetworkInfo.getAdNetworkName());
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute addCustomAttribute method", e);
        }
    }

    public static void addCustomAttribute(String key, String value) {
        if (!AdRegistration.isInitialized() && !ApsMigrationUtil.isApsInitInProgress()) {
            throw new IllegalStateException("mDTB was not initialized, please use AdRegistration.getInstance(...) before using other SDK calls");
        }
        try {
            if (customDictionary == null) {
                customDictionary = new HashMap<String, String>();
            }
            customDictionary.put(key, value);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute addCustomAttribute method", e);
        }
    }

    public static void removeCustomAttribute(String key) {
        if (!AdRegistration.isInitialized() && !ApsMigrationUtil.isApsInitInProgress()) {
            throw new IllegalStateException("mDTB was not initialized, please use AdRegistration.getInstance(...) before using other SDK calls");
        }
        try {
            if (!DtbCommonUtils.isNullOrEmpty(customDictionary)) {
                customDictionary.remove(key);
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute removeCustomAttribute method", e);
        }
    }

    public static Map<String, String> getCustomDictionary() {
        return customDictionary;
    }

    public static Map<String, DTBCacheData> getAdMobCacheData() {
        return adMobRequestIdMap;
    }

    public static DTBCacheData getAdMobCache(String requestId) {
        if (!DtbCommonUtils.isNullOrEmpty(requestId) && adMobRequestIdMap != null) {
            AdRegistration.removeExpiredAdMobCache();
            return adMobRequestIdMap.get(requestId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAdMobCache(String requestId, DTBCacheData dtbCacheData) {
        if (adMobRequestIdMap == null) {
            adMobRequestIdMap = new HashMap<String, DTBCacheData>();
        }
        AdRegistration.removeExpiredAdMobCache();
        Map<String, DTBCacheData> map = adMobRequestIdMap;
        synchronized (map) {
            adMobRequestIdMap.put(requestId, dtbCacheData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAdMobCache(String requestId) {
        if (adMobRequestIdMap != null) {
            Map<String, DTBCacheData> map = adMobRequestIdMap;
            synchronized (map) {
                adMobRequestIdMap.remove(requestId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeExpiredAdMobCache() {
        if (adMobRequestIdMap != null) {
            Map<String, DTBCacheData> map = adMobRequestIdMap;
            synchronized (map) {
                long timeStamp = new Date().getTime();
                Iterator<Map.Entry<String, DTBCacheData>> requestIdMapIterator = adMobRequestIdMap.entrySet().iterator();
                while (requestIdMapIterator.hasNext()) {
                    Map.Entry<String, DTBCacheData> entry = requestIdMapIterator.next();
                    DTBCacheData dtbCacheData = entry.getValue();
                    if (timeStamp - dtbCacheData.getResponseTimeStamp() <= 29000L) continue;
                    requestIdMapIterator.remove();
                }
            }
        }
    }

    static {
        testMode = false;
        locationEnabled = false;
        initCount = 0;
        mraidPolicy = MRAIDPolicy.AUTO_DETECT;
        serverlessMarkers = new String[]{"com.amazon.admob_adapter.APSAdMobCustomBannerEvent", "com.amazon.mopub_adapter.APSMopubCustomBannerEvent", "com.applovin.mediation.adapters.AmazonAdMarketplaceMediationAdapter"};
        adMobRequestIdMap = new HashMap<String, DTBCacheData>();
    }

    public static class SlotGroup {
        String name;
        Set<DTBAdSize> slots;

        public SlotGroup(String name) {
            if (DtbCommonUtils.isNullOrEmpty(name)) {
                throw new IllegalArgumentException("Slot Group name cannot be null or empty");
            }
            this.name = name;
            this.slots = new HashSet<DTBAdSize>();
        }

        public void addSlot(DTBAdSize size) {
            try {
                for (DTBAdSize tmpSize : this.slots) {
                    if (tmpSize.getWidth() != size.getWidth() || tmpSize.getHeight() != size.getHeight() || tmpSize.getDTBAdType() != size.getDTBAdType()) continue;
                    return;
                }
                this.slots.add(size);
            }
            catch (RuntimeException e) {
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to execute addSlot method in SlotGroup class", e);
            }
        }

        DTBAdSize getSizeBySlotUUID(String slotUUID) {
            for (DTBAdSize size : this.slots) {
                if (!size.getSlotUUID().equals(slotUUID)) continue;
                return size;
            }
            return null;
        }

        public DTBAdSize getSizeByWidthAndHeight(int width, int height) {
            return this.getSizeByWidthHeightType(width, height, AdType.DISPLAY);
        }

        public DTBAdSize getSizeByWidthHeightType(int width, int height, AdType type) {
            try {
                for (DTBAdSize size : this.slots) {
                    if (size.getHeight() != height || size.getWidth() != width || size.getDTBAdType() != type) continue;
                    return size;
                }
            }
            catch (RuntimeException e) {
                APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute getSizeByWidthHeightType method in SlotGroup class", e);
            }
            return null;
        }

        public DTBAdSize getSizeByBannerType(DTBBannerType type) {
            try {
                switch (type) {
                    case PHONE_BANNER: {
                        return this.getSizeByWidthAndHeight(320, 50);
                    }
                    case TABLET_BANNER: {
                        return this.getSizeByWidthAndHeight(728, 90);
                    }
                }
            }
            catch (RuntimeException e) {
                APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute getSizeByBannerType method in SlotGroup class", e);
            }
            return null;
        }

        public DTBAdSize getSizeBySlotType(DTBSlotType type) {
            try {
                switch (type) {
                    case SLOT_320_50: {
                        return this.getSizeByWidthAndHeight(320, 50);
                    }
                    case SLOT_300_250: {
                        return this.getSizeByWidthAndHeight(300, 250);
                    }
                    case SLOT_728_90: {
                        return this.getSizeByWidthAndHeight(728, 90);
                    }
                    case SLOT_SMART: {
                        boolean isTablet = DtbDeviceDataRetriever.isTablet();
                        int width = 320;
                        int height = 50;
                        if (isTablet) {
                            width = 728;
                            height = 90;
                        }
                        return this.getSizeByWidthAndHeight(width, height);
                    }
                }
            }
            catch (RuntimeException e) {
                APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute getSizeBySlotType method in SlotGroup class", e);
            }
            return null;
        }
    }

    @Deprecated
    public static enum CMPFlavor {
        CMP_NOT_DEFINED,
        GOOGLE_CMP,
        MOPUB_CMP,
        ADMOB_CMP;

    }

    @Deprecated
    public static enum ConsentStatus {
        CONSENT_NOT_DEFINED,
        EXPLICIT_YES,
        EXPLICIT_NO,
        UNKNOWN;

    }
}

