/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.RelativeLayout;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.DTBAdExpandedListener;
import com.amazon.device.ads.DTBAdMRAIDExpandedController;
import com.amazon.device.ads.DTBAdView;
import com.amazon.device.ads.DisplayUtils;
import java.io.Serializable;
import java.util.Map;

public class DTBAdActivity
extends Activity {
    private final String LOG_TAG = DTBAdActivity.class.getSimpleName();
    static final String URL_ATTR = "url";
    static final String ADTYPE_ATTR = "ad_state";
    static final String INDEX_ATTR = "cntrl_index";
    static final String EXPANDED = "expanded";
    static final String TWO_PART_EXPAND = "two_part_expand";
    RelativeLayout pageLayout;
    DTBAdView adView;
    String type;
    int index;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.pageLayout = new RelativeLayout((Context)this);
        this.setContentView((View)this.pageLayout);
        this.type = this.getIntent().getStringExtra(ADTYPE_ATTR);
        this.index = this.getIntent().getIntExtra(INDEX_ATTR, 0);
        if (this.type.equals(EXPANDED)) {
            this.createExpanded();
        }
        this.handleOrientation();
    }

    void handleOrientation() {
        Serializable obj = this.getIntent().getSerializableExtra("orientation");
        if (obj != null) {
            Map orientationProperties = (Map)((Object)obj);
            boolean allowOrientationChange = (Boolean)orientationProperties.get("allowOrientationChange");
            String expectedOrientation = (String)orientationProperties.get("forceOrientation");
            if (expectedOrientation != null) {
                if ("portrait".equals(expectedOrientation)) {
                    this.setRequestedOrientation(1);
                } else if ("landscape".equals(expectedOrientation)) {
                    this.setRequestedOrientation(0);
                } else if (!allowOrientationChange) {
                    int currentOrientation = DisplayUtils.determineSimpleOrientation();
                    if (currentOrientation == 2) {
                        this.setRequestedOrientation(6);
                    } else {
                        this.setRequestedOrientation(7);
                    }
                }
            }
        }
    }

    private void createExpanded() {
        this.adView = new DTBAdView((Context)this, new DTBAdExpandedListener(){

            @Override
            public void onAdLoaded(DTBAdView view) {
            }

            @Override
            public void onCreateExpandedController(DTBAdMRAIDExpandedController expandedController) {
            }
        }, this.index);
        Intent intent = this.getIntent();
        String script = intent.getStringExtra(URL_ATTR);
        boolean isTwoPartExpand = intent.getBooleanExtra(TWO_PART_EXPAND, false);
        this.pageLayout.addView((View)this.adView, -1, -1);
        this.adView.fetchAdWithLocation(script);
        this.adView.setScrollEnabled(true);
        DTBAdMRAIDExpandedController controller = (DTBAdMRAIDExpandedController)this.adView.getController();
        controller.setTwoPartExpand(isTwoPartExpand);
        controller.addCloseIndicator();
    }

    protected void onStart() {
        super.onStart();
    }

    protected void onStop() {
        super.onStop();
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    protected boolean isExpanded() {
        return EXPANDED.equals(this.type);
    }

    public void finish() {
        try {
            this.adView.getController().closeExpandedPartTwo();
        }
        catch (RuntimeException var5) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute finish method", var5);
        }
    }

    void straightFinish() {
        super.finish();
    }
}

