/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.WindowManager;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.DTBAdInterstitialListener;
import com.amazon.device.ads.DTBAdMRAIDInterstitialController;
import com.amazon.device.ads.DTBAdView;
import com.amazon.device.ads.DTBInterstitialActivity;
import com.amazon.device.ads.DtbOmSdkSessionManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DTBAdInterstitial {
    private static final String LOG_TAG = DTBAdInterstitial.class.getSimpleName();
    protected static final String INTERSTITIAL_CACHE_KEY = "INTERSTITIAL_CACHE_KEY";
    private Context context;
    DTBAdView adView;
    private static Map<Integer, DTBAdInterstitial> dtbAdInterstitialCache = Collections.synchronizedMap(new HashMap());

    DTBAdView getAdView() {
        return this.adView;
    }

    private static int putInCache(DTBAdInterstitial dtbAdInterstitial) {
        dtbAdInterstitialCache.put(dtbAdInterstitial.hashCode(), dtbAdInterstitial);
        return dtbAdInterstitial.hashCode();
    }

    static void removeFromCache(int key) {
        dtbAdInterstitialCache.remove(key);
    }

    static DTBAdInterstitial getFromCache(int key) {
        if (!dtbAdInterstitialCache.containsKey(key)) {
            return null;
        }
        return dtbAdInterstitialCache.get(key);
    }

    public DTBAdInterstitial(Context context, DTBAdInterstitialListener listener) {
        try {
            this.context = context;
            this.adView = new DTBAdView(context, listener);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to initialize DTBAdInterstitial class", e);
        }
    }

    protected DTBAdInterstitial(Context context) {
        this.context = context;
    }

    protected void setDtbAdInterstitialListener(DTBAdInterstitialListener listener) {
        try {
            this.adView = new DTBAdView(this.context, listener);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to initialize DTBAdInterstitial class", e);
        }
    }

    private DTBAdMRAIDInterstitialController getInterstitialController() {
        return (DTBAdMRAIDInterstitialController)this.adView.getController();
    }

    private DTBAdInterstitialListener getInterstitialListener() {
        return this.getInterstitialController().getInterstitialListener();
    }

    void setListener(DTBAdInterstitialListener listener) {
        this.getInterstitialController().setInterstitialListener(listener);
    }

    public void fetchAd(Map<String, Object> extraData) {
        this.adView.fetchAd(extraData);
    }

    public void fetchAd(Bundle extraData) {
        try {
            this.adView.fetchAd(extraData.getString("bid_html_template", ""), extraData);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to execute fetchAd method with extraData argument", e);
        }
    }

    public void fetchAd(String adHtml) {
        try {
            this.adView.fetchAd(adHtml);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to execute fetchAd method with adHtml argument", e);
        }
    }

    public void fetchAd(String adHtml, Bundle extras) {
        try {
            this.adView.fetchAd(adHtml, extras);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to execute fetchAd method with adHtml and  bundle argument", e);
        }
    }

    public void show() {
        try {
            if (this.getInterstitialController() == null) {
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "There is no controller before showing the interstitial ad");
                return;
            }
            Intent intent = new Intent(this.context, DTBInterstitialActivity.class);
            intent.putExtra(INTERSTITIAL_CACHE_KEY, DTBAdInterstitial.putInCache(this));
            this.startOMSDKSession();
            this.context.startActivity(intent);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to execute show method", e);
        }
    }

    public static int getWidth(Context context) {
        try {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            WindowManager windowmanager = (WindowManager)context.getSystemService("window");
            windowmanager.getDefaultDisplay().getMetrics(displayMetrics);
            return displayMetrics.widthPixels;
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute getWidth method", e);
            return 0;
        }
    }

    private void startOMSDKSession() {
        try {
            DtbOmSdkSessionManager dtbOmSdkSessionManager = this.getInterstitialController().getDtbOmSdkSessionManager();
            if (!this.getAdView().isVideo()) {
                dtbOmSdkSessionManager.initHtmlDisplayOmAdSession(this.getAdView(), "https://c.amazon-adsystem.com/");
            } else {
                dtbOmSdkSessionManager.initJavaScriptOmAdSession(this.getAdView(), "https://c.amazon-adsystem.com/");
            }
            dtbOmSdkSessionManager.registerAdView(this.getAdView());
            dtbOmSdkSessionManager.startAdSession();
            dtbOmSdkSessionManager.displayAdEventLoaded();
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Unable to start OM SDK session for Interstitial ad", e);
        }
    }

    void onAdClosed() {
        DTBAdInterstitialListener listener = this.getInterstitialListener();
        if (listener != null) {
            listener.onAdClosed((View)this.adView);
        }
    }
}

