/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.browser.customtabs.CustomTabsIntent;
import com.amazon.aps.ads.R;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DTBActivityListener;
import com.amazon.device.ads.DTBAdUtil;
import com.amazon.device.ads.DTBAdView;
import com.amazon.device.ads.DTBMRAIDCloseButtonListener;
import com.amazon.device.ads.DTBMetricReport;
import com.amazon.device.ads.DTBMetricsProcessor;
import com.amazon.device.ads.DisplayUtils;
import com.amazon.device.ads.DtbLog;
import com.amazon.device.ads.DtbOmSdkSessionManager;
import com.amazon.device.ads.MraidCloseCommand;
import com.amazon.device.ads.MraidCommand;
import com.amazon.device.ads.MraidExpandCommand;
import com.amazon.device.ads.MraidFirePixelCommand;
import com.amazon.device.ads.MraidJSReadyCommand;
import com.amazon.device.ads.MraidOpenCommand;
import com.amazon.device.ads.MraidProperty;
import com.amazon.device.ads.MraidResizeCommand;
import com.amazon.device.ads.MraidStateType;
import com.amazon.device.ads.MraidUnloadCommand;
import com.amazon.device.ads.MraidUseCustomCloseCommand;
import com.amazon.device.ads.SDKUtilities;
import com.iab.omid.library.amazon.adsession.FriendlyObstructionPurpose;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class DTBAdMRAIDController
implements DTBActivityListener {
    static final String LOG_TAG = DTBAdMRAIDController.class.getSimpleName();
    public static final String MRAID_CLOSE = "window.mraid.close();";
    private static final String MRAID_READY = "window.mraidBridge.event.ready();";
    boolean pageLoaded = false;
    LinearLayout closeIndicatorRegion;
    protected boolean useCustomClose = false;
    private Rect lastRect;
    private int lastReportedSizeChangeWidth = -1;
    private int lastReportedSizeChangeHeight = -1;
    private boolean loadReportSubmitted;
    DTBMRAIDCloseButtonListener customButtonListener;
    protected MraidStateType state = MraidStateType.LOADING;
    private Boolean lastViewabilityState;
    private MraidExposure lastReportedExposure;
    private DtbOmSdkSessionManager dtbOmSdkSessionManager;
    private boolean jsReady = false;
    private boolean isTwoPartExpand = false;
    DTBAdView adView;

    protected DTBAdView getAdView() {
        return this.adView;
    }

    public void cleanup() {
        this.closeIndicatorRegion = null;
        this.adView = null;
        this.customButtonListener = null;
    }

    public void setCustomButtonListener(DTBMRAIDCloseButtonListener listener) {
        this.customButtonListener = listener;
    }

    public boolean isUseCustomClose() {
        return this.useCustomClose;
    }

    protected DTBAdMRAIDController(DTBAdView adView) {
        this.adView = adView;
        this.dtbOmSdkSessionManager = adView.getOmSdkManager();
    }

    public DtbOmSdkSessionManager getDtbOmSdkSessionManager() {
        return this.dtbOmSdkSessionManager;
    }

    public abstract void onPageLoad();

    protected abstract void expand(Map<String, Object> var1);

    public void setUseCustomClose(boolean useCustomClose) {
        DtbLog.debug("Set useCustomClose to " + useCustomClose);
        this.useCustomClose = useCustomClose;
        this.commandCompleted("useCustomClose");
        if (this.customButtonListener != null) {
            this.customButtonListener.useCustomButtonUpdated();
        }
    }

    void onLoadError(String description, int errorCode) {
        this.onLoadError();
    }

    public void onLoadError() {
        String bidId = this.adView.getBidId();
        String hostname = this.adView.getHostname();
        if (bidId != null) {
            DTBMetricsProcessor.getInstance().submitSimpleReportBidId(DTBMetricReport.addBid(bidId, hostname), DTBMetricsProcessor.REPORT_LOAD_FAILURE);
        }
        this.passLoadError();
    }

    void passLoadError() {
    }

    protected String getPlacementType() {
        return "";
    }

    protected void createLoadReport() {
        String bidId = this.adView.getBidId();
        String hostname = this.adView.getHostname();
        if (bidId != null && !this.loadReportSubmitted) {
            int interval = (int)(new Date().getTime() - this.adView.getStartTime());
            DTBMetricsProcessor.getInstance().submitLatencyReportBidId(DTBMetricReport.addBid(bidId, hostname), DTBMetricsProcessor.REPORT_LOAD_LATENCY, interval);
            this.loadReportSubmitted = true;
        }
    }

    void prepareMraid() throws JSONException {
        this.createLoadReport();
        this.pageLoaded = true;
        this.fireMaxSizeEvent();
        this.fireScreenSizeEvent();
        if (this.getAdView().isAdViewVisible()) {
            this.setCurrentPositionProperty();
        }
        this.fireMRAIDSupports();
        this.firePlacementType();
        this.setCurrentAppOrientation();
        this.setState(this.getInitialStateType());
        this.fireMRAIDReadyEvent();
        if (AdRegistration.isTestMode()) {
            this.evaluateJavascript("window.mraidBridge.service.debug('enable');");
        }
    }

    protected MraidStateType getInitialStateType() {
        return MraidStateType.DEFAULT;
    }

    private JSONObject formProperties(MraidProperty[] properties) throws JSONException {
        JSONObject obj = new JSONObject();
        for (MraidProperty property : properties) {
            property.formJSON(obj);
        }
        return obj;
    }

    protected void setCurrentAppOrientation() throws JSONException {
        String orientation;
        switch (DisplayUtils.determineSimpleOrientation()) {
            case 1: {
                orientation = "portrait";
                break;
            }
            case 2: {
                orientation = "landscape";
                break;
            }
            default: {
                orientation = "unspecified";
            }
        }
        boolean isLocked = DisplayUtils.isRotationLocked();
        JSONObject json = new JSONObject();
        json.put("orientation", (Object)orientation);
        json.put("locked", isLocked);
        this.evaluateJavascriptMethod("window.mraidBridge.property.setCurrentAppOrientation", json);
    }

    Context getContext() {
        return this.getAdView().getContext();
    }

    public void setCurrentPositionProperty() {
        if (!this.pageLoaded) {
            return;
        }
        int[] position = new int[2];
        this.getAdView().getLocationOnScreen(position);
        this.setCurrentPositionProperty(position[0], position[1], this.getAdView().getWidth(), this.getAdView().getHeight());
    }

    void setCurrentPositionProperty(float width, float height) {
        if (!this.pageLoaded) {
            return;
        }
        int[] position = new int[2];
        this.getAdView().getLocationOnScreen(position);
        this.setCurrentPositionProperty(position[0], position[1], width, height);
    }

    void setCurrentPositionProperty(int x, int y, float width, float height) {
        if (!this.pageLoaded) {
            return;
        }
        float xPos = DTBAdUtil.pixelsToDeviceIndependenPixels(x);
        float yPos = DTBAdUtil.pixelsToDeviceIndependenPixels(y);
        float w = DTBAdUtil.pixelsToDeviceIndependenPixels((int)width);
        float h = DTBAdUtil.pixelsToDeviceIndependenPixels((int)height);
        String script = String.format("window.mraidBridge.property.setCurrentPosition({'xPos':%.1f, 'yPos':%.1f, 'width': %.1f, 'height': %.1f});", Float.valueOf(xPos), Float.valueOf(yPos), Float.valueOf(w), Float.valueOf(h));
        this.evaluateJavascript(script);
    }

    private void fireMaxSizeEvent() {
        SDKUtilities.SimpleSize size = DTBAdUtil.getMaxSize((View)this.getAdView());
        String script = String.format("window.mraidBridge.property.setMaxSize({'width':%d, 'height':%d});", size.getWidth(), size.getHeight());
        this.evaluateJavascript(script);
    }

    void fireScreenSizeEvent() {
        SDKUtilities.SimpleSize size = DTBAdUtil.getScreenSize((View)this.getAdView());
        String script = String.format("window.mraidBridge.property.setScreenSize({'width':%d, 'height':%d});", size.getWidth(), size.getHeight());
        this.evaluateJavascript(script);
    }

    void fireViewableChange(boolean isViewable) {
        if (this.lastViewabilityState == null || this.lastViewabilityState != isViewable) {
            if (this.jsReady) {
                this.fireEnforcedViewableChange(isViewable);
            }
            this.lastViewabilityState = isViewable;
        }
    }

    void fireEnforcedViewableChange(boolean isViewable) {
        String script = String.format("window.mraidBridge.event.viewableChange(%s);", isViewable ? "true" : "false");
        this.evaluateJavascript(script);
    }

    protected void firePlacementType() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("type", (Object)this.getPlacementType());
        this.evaluateJavascriptMethod("window.mraidBridge.property.setPlacementType", json);
    }

    protected void fireMRAIDSupports() {
        this.evaluateJavascriptMethod("window.mraidBridge.property.setSupports", MraidProperty.SUPPORTS_PROPERTY.getData());
    }

    public void fireErrorEvent(String action, String errorMessage) {
        this.evaluateJavascript(String.format("window.mraidBridge.event.error('%s','%s');", errorMessage, action));
    }

    private void evaluateJavascriptMethod(String method, JSONObject json) {
        this.evaluateJavascript(String.format(method + "(%s);", json.toString()));
    }

    protected void evaluateJavascript(final String script) {
        DtbLog.debug(LOG_TAG, "MRAID Evaluate JSScript:" + script);
        new Handler(Looper.getMainLooper()).post(() -> {
            if (this.getAdView() != null) {
                this.getAdView().evaluateJavascript(script, (ValueCallback)new ValueCallback<String>(){

                    public void onReceiveValue(String value) {
                        if (value != null && !"null".equals(value)) {
                            DtbLog.debug(LOG_TAG, "Value received:" + value + " for script " + script);
                        }
                    }
                });
            }
        });
    }

    private MraidProperty getCurrentStateProperty() {
        switch (this.state) {
            case LOADING: {
                return MraidProperty.STATE_LOADING_PROPERTY;
            }
            case DEFAULT: {
                return MraidProperty.STATE_DEFAULT_PROPERTY;
            }
            case RESIZED: {
                return MraidProperty.STATE_RESIZED_PROPERTY;
            }
            case EXPANDED: {
                return MraidProperty.STATE_EXPANDED_PROPERTY;
            }
            case HIDDEN: {
                return MraidProperty.STATE_HIDDEN_PROPERTY;
            }
        }
        return MraidProperty.STATE_DEFAULT_PROPERTY;
    }

    void fireStateChangeEvent() {
        try {
            MraidProperty[] props = new MraidProperty[]{this.getCurrentStateProperty()};
            JSONObject obj = this.formProperties(props);
            DtbLog.debug(LOG_TAG, "State was changed to " + obj.toString() + " for controller " + this);
            String script = String.format("window.mraidBridge.event.stateChange(%s);", obj.toString());
            this.evaluateJavascript(script);
        }
        catch (JSONException ex) {
            ex.printStackTrace();
        }
    }

    public void fireExposureChange(int exposureChange, Rect rect) {
        int width = rect.right - rect.left;
        int height = rect.bottom - rect.top;
        if (this.jsReady) {
            this.fireEnforcedExposureChange(exposureChange, rect);
        } else {
            this.lastReportedExposure = new MraidExposure(exposureChange, rect);
        }
    }

    private void fireEnforcedExposureChange(int exposureChange, Rect rect) {
        int width = rect.right - rect.left;
        int height = rect.bottom - rect.top;
        String script = String.format("window.mraidBridge.event.exposureChange(%d, { x:%d, y:%d, width:%d, height: %d}, null);", exposureChange, DTBAdUtil.pixelsToDeviceIndependenPixels(rect.left), DTBAdUtil.pixelsToDeviceIndependenPixels(rect.top), DTBAdUtil.pixelsToDeviceIndependenPixels(width), DTBAdUtil.pixelsToDeviceIndependenPixels(height));
        this.evaluateJavascript(script);
    }

    void fireSizeChange(int width, int height) {
        if (this.lastReportedSizeChangeWidth == width && this.lastReportedSizeChangeHeight == height) {
            return;
        }
        this.lastReportedSizeChangeWidth = width;
        this.lastReportedSizeChangeHeight = height;
        if (this.jsReady) {
            this.fireEnforcedSizeChange(width, height);
        }
    }

    void fireEnforcedSizeChange(int width, int height) {
        String script = String.format("window.mraidBridge.event.sizeChange(%d, %d);", width, height);
        this.evaluateJavascript(script);
    }

    void fireMRAIDReadyEvent() {
        this.evaluateJavascript(MRAID_READY);
    }

    public void onPositionChanged(Rect rect) {
        boolean isSizeChanged;
        if (this.lastRect != null && this.lastRect.equals((Object)rect)) {
            return;
        }
        int newWidth = rect.right - rect.left;
        int newHeight = rect.bottom - rect.top;
        if (this.lastRect != null) {
            int oldWidth = this.lastRect.right - this.lastRect.left;
            int oldHeight = this.lastRect.bottom - this.lastRect.top;
            isSizeChanged = Math.abs(oldWidth - newWidth) > 1 || Math.abs(oldHeight - newHeight) > 1;
        } else {
            isSizeChanged = true;
        }
        this.setCurrentPositionProperty();
        if (isSizeChanged) {
            this.fireSizeChange(DTBAdUtil.pixelsToDeviceIndependenPixels(newWidth), DTBAdUtil.pixelsToDeviceIndependenPixels(newHeight));
        }
        this.lastRect = rect;
    }

    protected abstract void onMRAIDClose();

    void setState(MraidStateType state) {
        this.state = state;
        if (state == MraidStateType.HIDDEN) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(() -> {
                DTBAdView dtbAdView = this.getAdView();
                if (dtbAdView != null) {
                    dtbAdView.setVisibility(8);
                }
            });
        }
        this.fireStateChangeEvent();
    }

    protected void onMRAIDUnload() {
        new Handler(Looper.getMainLooper()).post(() -> this.getAdView().loadUrl("about:blank"));
    }

    protected abstract void onResize(Map<String, Object> var1);

    public void commandCompleted(String command) {
        String script = String.format("window.mraidBridge.service.acknowledgement('%s');", command);
        this.evaluateJavascript(script);
    }

    void openUrl(String urlStr) {
        this.openUrl(urlStr, false);
    }

    void openUrl(String urlStr, boolean useCustomTab) {
        Uri loadURI;
        PackageManager pm = this.adView.getContext().getPackageManager();
        try {
            loadURI = Uri.parse((String)urlStr);
        }
        catch (Exception e) {
            this.fireErrorEvent("open", "invalid url " + urlStr);
            this.commandCompleted("open");
            return;
        }
        if ("amazonmobile".equals(loadURI.getScheme()) && loadURI.getHost().equals("intent")) {
            String[] intents = urlStr.split("intent=");
            if (intents.length > 1) {
                String intent = null;
                for (int k = 1; k < intents.length; ++k) {
                    try {
                        intent = intents[k];
                        if (intent.lastIndexOf("&") == intent.length() - 1) {
                            intent = intent.substring(0, intent.length() - 1);
                        }
                        intent = URLDecoder.decode(intent, "UTF-8");
                        Intent mShopIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)intent));
                        this.getContext().startActivity(mShopIntent);
                        this.onAdLeftApplication();
                        break;
                    }
                    catch (ActivityNotFoundException notfound) {
                        DtbLog.debug("Intent:" + intent + " not found.");
                        this.fireErrorEvent("open", "requested activity not found");
                        continue;
                    }
                    catch (UnsupportedEncodingException uex) {
                        DtbLog.debug("Unsupported encoding");
                    }
                }
            }
        } else if ("com.amazon.mobile.shopping".equals(loadURI.getScheme())) {
            try {
                if (pm.getLaunchIntentForPackage("com.amazon.mShop.android.shopping") != null) {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(loadURI);
                    AdRegistration.getCurrentActivity().startActivity(intent);
                } else {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(loadURI);
                    int index = urlStr.indexOf("products/");
                    if (index > 0) {
                        String webAddress = "https://www.amazon.com/dp/" + urlStr.substring(index + "products/".length());
                        intent.setData(Uri.parse((String)webAddress));
                        AdRegistration.getCurrentActivity().startActivity(intent);
                    }
                }
                this.onAdLeftApplication();
            }
            catch (ActivityNotFoundException ex) {
                DtbLog.debug(LOG_TAG, "Activity not found com.amazon.mobile.shopping");
                this.fireErrorEvent("open", "mshop activity not found");
            }
            catch (NullPointerException ex) {
                DtbLog.debug(LOG_TAG, "Current activity from AdRegistration not found");
                this.fireErrorEvent("open", "current activity from AdRegistration not found");
            }
        } else if ("market".equals(loadURI.getScheme()) || "amzn".equals(loadURI.getScheme())) {
            try {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(loadURI);
                AdRegistration.getCurrentActivity().startActivity(intent);
                this.onAdLeftApplication();
            }
            catch (ActivityNotFoundException e) {
                try {
                    DTBAdUtil.directAppStoreLinkToBrowser(this, loadURI);
                }
                catch (ActivityNotFoundException ee) {
                    DtbLog.debug(LOG_TAG, "App stores and browsers not found");
                    this.fireErrorEvent("open", "app stores and browsers not found");
                }
                catch (NullPointerException ex) {
                    DtbLog.debug(LOG_TAG, "Current activity from AdRegistration not found");
                    this.fireErrorEvent("open", "current activity from AdRegistration not found");
                }
            }
            catch (NullPointerException ex) {
                DtbLog.debug(LOG_TAG, "Current activity from AdRegistration not found");
                this.fireErrorEvent("open", "current activity from AdRegistration not found");
            }
        } else {
            if (loadURI.getScheme() == null) {
                loadURI = Uri.parse((String)("https:" + urlStr));
            }
            if (useCustomTab) {
                try {
                    CustomTabsIntent ctIntent = new CustomTabsIntent.Builder().build();
                    ctIntent.launchUrl(this.getContext(), loadURI);
                    this.onAdLeftApplication();
                }
                catch (Exception ex) {
                    String errMessage = "Failed to execute open command: invalid url " + urlStr;
                    this.fireErrorEvent("open", errMessage);
                    APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, errMessage, ex);
                }
            } else {
                try {
                    Intent browserIntent = new Intent("android.intent.action.VIEW", loadURI);
                    browserIntent.addFlags(0x10000000);
                    this.getContext().startActivity(browserIntent);
                    this.onAdLeftApplication();
                }
                catch (Exception ex) {
                    String errMessage = "Failed to execute open command: invalid url " + urlStr;
                    this.fireErrorEvent("open", errMessage);
                    APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, errMessage, ex);
                }
            }
        }
        this.commandCompleted("open");
    }

    protected void removeCloseIndicator() {
        ViewGroup p;
        if (this.closeIndicatorRegion != null && (p = (ViewGroup)this.closeIndicatorRegion.getParent()) != null) {
            p.removeView((View)this.closeIndicatorRegion);
        }
    }

    void addCloseIndicator(int rightCornerX, int rightCornerY) {
        this.removeCloseIndicator();
        this.addCloseIndicator(rightCornerX, rightCornerY, false);
    }

    protected void addCloseIndicator(int rightCornerX, int rightCornerY, boolean useCustomClose) {
        this.removeCloseIndicator();
        this.addCloseIndicator(rightCornerX, rightCornerY, null, useCustomClose);
    }

    protected void setCloseIndicatorContent(View.OnTouchListener onTouchListener) {
        this.closeIndicatorRegion.setBackgroundColor(0);
        this.closeIndicatorRegion.setId(R.id.mraid_close_indicator);
        ImageView iv = new ImageView(this.getAdView().getContext());
        iv.setId(R.id.mraid_close_indicator);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(DTBAdUtil.sizeToDevicePixels(24), DTBAdUtil.sizeToDevicePixels(24));
        params.setMargins(DTBAdUtil.sizeToDevicePixels(14), DTBAdUtil.sizeToDevicePixels(14), 0, 0);
        this.closeIndicatorRegion.addView((View)iv, (ViewGroup.LayoutParams)params);
        if (this.getDtbOmSdkSessionManager() != null) {
            this.getDtbOmSdkSessionManager().addFriendlyObstruction(this.closeIndicatorRegion.findViewById(R.id.mraid_close_indicator), FriendlyObstructionPurpose.CLOSE_AD);
        }
        Drawable drawable2 = AppCompatResources.getDrawable((Context)this.getAdView().getContext(), (int)R.drawable.mraid_close);
        iv.setImageDrawable(drawable2);
        if (onTouchListener != null) {
            this.closeIndicatorRegion.setOnTouchListener(onTouchListener);
        } else {
            this.closeIndicatorRegion.setOnTouchListener((v, event) -> {
                if (event.getAction() == 0) {
                    this.evaluateJavascript(MRAID_CLOSE);
                    ViewGroup parent = (ViewGroup)v.getParent();
                    parent.removeView(v);
                    this.closeIndicatorRegion = null;
                }
                return true;
            });
        }
    }

    protected void createContentIndicator() {
        this.closeIndicatorRegion = new LinearLayout(this.getAdView().getContext());
        this.closeIndicatorRegion.setVisibility(this.useCustomClose ? 4 : 0);
        this.closeIndicatorRegion.setOrientation(1);
    }

    @SuppressLint(value={"ResourceType"})
    protected void addCloseIndicator(int rightCornerX, int rightCornerY, View.OnTouchListener onTouchListener, boolean useCustomClose) {
        this.createContentIndicator();
        ViewGroup rootView = DTBAdUtil.getRootView((View)this.getAdView());
        rootView.addView((View)this.closeIndicatorRegion, DTBAdUtil.sizeToDevicePixels(50), DTBAdUtil.sizeToDevicePixels(50));
        this.closeIndicatorRegion.setX((float)(rightCornerX - DTBAdUtil.sizeToDevicePixels(50)));
        this.closeIndicatorRegion.setY((float)rightCornerY);
        this.setCloseIndicatorContent(onTouchListener);
    }

    public boolean isTwoPartExpand() {
        return this.isTwoPartExpand;
    }

    void setTwoPartExpand(boolean value) {
        this.isTwoPartExpand = value;
    }

    void jsReady() {
        this.commandCompleted("jsready");
        this.jsReady = true;
        if (this.lastViewabilityState != null) {
            this.fireEnforcedViewableChange(this.lastViewabilityState);
        }
        if (this.lastReportedExposure != null) {
            this.fireEnforcedExposureChange(this.lastReportedExposure.percent, this.lastReportedExposure.rect);
        }
        if (this.lastReportedSizeChangeWidth > 0 && this.lastReportedSizeChangeHeight > 0) {
            this.fireEnforcedSizeChange(this.lastReportedSizeChangeWidth, this.lastReportedSizeChangeHeight);
        }
    }

    public void onViewabilityChanged(boolean changed) {
        DtbLog.debug("SET MRAID Visible " + changed);
        this.fireViewableChange(changed);
    }

    void closeExpandedPartTwo() {
    }

    public void onAdOpened() {
    }

    public void onAdClicked() {
    }

    public void onAdLoaded() {
    }

    public void onAdFailedToLoad() {
    }

    public abstract void onAdLeftApplication();

    @Override
    public void onActivityResumed(Activity activity) {
    }

    @Override
    public void onActivityPaused(Activity activity) {
    }

    @Override
    public void onActivityStopped(Activity activity) {
    }

    @Override
    public void onActivityDestroyed(Activity activity) {
    }

    public void onAdRemoved() {
    }

    public void impressionFired() {
        if (!this.getAdView().isVideo() && this.getDtbOmSdkSessionManager() != null) {
            this.getDtbOmSdkSessionManager().impressionOccured();
        }
        this.commandCompleted(MraidFirePixelCommand.getMraidName());
    }

    public void onVideoCompleted() {
    }

    static {
        MraidCommand.registerCommand(MraidOpenCommand.getMraidName(), MraidOpenCommand.class);
        MraidCommand.registerCommand(MraidCloseCommand.getMraidName(), MraidCloseCommand.class);
        MraidCommand.registerCommand(MraidUnloadCommand.getMraidName(), MraidUnloadCommand.class);
        MraidCommand.registerCommand(MraidResizeCommand.getMraidName(), MraidResizeCommand.class);
        MraidCommand.registerCommand(MraidExpandCommand.getMraidName(), MraidExpandCommand.class);
        MraidCommand.registerCommand(MraidUseCustomCloseCommand.getMraidName(), MraidUseCustomCloseCommand.class);
        MraidCommand.registerCommand(MraidJSReadyCommand.getMraidName(), MraidJSReadyCommand.class);
        MraidCommand.registerCommand(MraidFirePixelCommand.getMraidName(), MraidFirePixelCommand.class);
    }

    class MraidExposure {
        int percent;
        Rect rect;

        MraidExposure(int percent, Rect rect) {
            this.percent = percent;
            this.rect = new Rect(rect);
        }
    }
}

