/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import com.amazon.aps.ads.metrics.ApsMetricsBannerListenerAdapter;
import com.amazon.aps.ads.metrics.ApsMetricsInterstitialListenerAdapter;
import com.amazon.aps.ads.util.adview.ApsAdViewConstants;
import com.amazon.aps.ads.util.adview.ApsAdViewImpl;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.DTBAdBannerListener;
import com.amazon.device.ads.DTBAdExpandedListener;
import com.amazon.device.ads.DTBAdInterstitialListener;
import com.amazon.device.ads.DTBAdMRAIDBannerController;
import com.amazon.device.ads.DTBAdMRAIDController;
import com.amazon.device.ads.DTBAdMRAIDExpandedController;
import com.amazon.device.ads.DTBAdMRAIDInterstitialController;

public class DTBAdView
extends ApsAdViewImpl
implements ApsAdViewConstants {
    static final String LOG_TAG = DTBAdView.class.getSimpleName();

    protected DTBAdView(Context context) {
        super(context);
    }

    public DTBAdView(Context context, DTBAdInterstitialListener listener) {
        super(context);
        this.initAdInterstitialListener(listener);
    }

    public DTBAdView(Context context, DTBAdBannerListener listener) {
        super(context);
        this.initAdBannerListener(listener);
    }

    public DTBAdView(Context context, DTBAdExpandedListener listener) {
        this(context, listener, 0);
    }

    public DTBAdView(Context context, DTBAdExpandedListener listener, int index) {
        super(context);
        this.initAdExpandedListener(listener, index);
    }

    protected void initAdInterstitialListener(DTBAdInterstitialListener listener) {
        try {
            this.setMraidListenerAdapter(new ApsMetricsInterstitialListenerAdapter(this.getBidId(), listener));
            this.setMraidHandler(new DTBAdMRAIDInterstitialController(this, (ApsMetricsInterstitialListenerAdapter)this.getMraidListenerAdapter()));
            this.initWebView();
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to initialize DTBAdView class with DTBAdInterstitialListener", e);
        }
    }

    protected void initAdBannerListener(DTBAdBannerListener listener) {
        try {
            this.setMraidListenerAdapter(new ApsMetricsBannerListenerAdapter(this.getBidId(), listener));
            this.setMraidHandler(new DTBAdMRAIDBannerController(this, (ApsMetricsBannerListenerAdapter)this.getMraidListenerAdapter()));
            this.initWebView();
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to initialize DTBAdView class with DTBAdBannerListener", e);
        }
    }

    protected void initAdExpandedListener(DTBAdExpandedListener listener, int index) {
        try {
            DTBAdMRAIDExpandedController expandedController = new DTBAdMRAIDExpandedController(this);
            this.setMraidHandler(expandedController);
            expandedController.setMasterController(DTBAdMRAIDBannerController.findControllerByIndex(index));
            listener.onCreateExpandedController((DTBAdMRAIDExpandedController)this.getMraidHandler());
            this.initWebView();
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to initialize DTBAdView class with DTBAdExpandedListener", e);
        }
    }

    public DTBAdMRAIDController getController() {
        return super.getMraidHandler();
    }
}

