/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.app.Activity;
import android.view.View;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DTBAdResponse;
import com.amazon.device.ads.DTBAdSize;
import com.amazon.device.ads.EventDistributor;
import java.util.List;

public class DTBRenderer {
    private static final String LOG_TAG = DTBRenderer.class.getSimpleName();
    Activity activity;
    String adUnitId;
    protected boolean showOnLoad = false;
    protected DTBAdResponse dtbAdResponse;

    DTBRenderer(String adUnitId, Activity activity, DTBAdResponse response) {
        this.adUnitId = adUnitId;
        this.dtbAdResponse = response;
        this.activity = activity;
    }

    protected EventDistributor getEventDistributer() {
        return AdRegistration.getEventDistributer();
    }

    public boolean isShowOnLoad() {
        return this.showOnLoad;
    }

    public DTBAdSize getSize() {
        try {
            List<DTBAdSize> sizes;
            if (this.dtbAdResponse != null && (sizes = this.dtbAdResponse.getDTBAds()).size() > 0) {
                return sizes.get(0);
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute getSize method", e);
        }
        return null;
    }

    public void onCustomBannerFailure(View view) {
    }

    public void onCustomBannerSuccess(View view) {
    }
}

