/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DtbCommonUtils;
import com.amazon.device.ads.DtbGooglePlayServices;
import com.amazon.device.ads.DtbLog;
import com.amazon.device.ads.DtbSharedPreferences;

final class DtbAdvertisingInfo {
    private static final String LOG_TAG = DtbAdvertisingInfo.class.getSimpleName();

    public DtbAdvertisingInfo() {
        if (AdRegistration.getContext() == null) {
            DtbLog.debugError("unable to initialize advertising info without setting app context");
            throw new IllegalArgumentException("unable to initialize advertising info without setting app context");
        }
        this.initializeAdvertisingInfo();
    }

    private void setIsAdvertisingIdentifierChanged(boolean isAdvertisingIdentifierChanged) {
        DtbSharedPreferences.getInstance().saveIsAdIdChanged(isAdvertisingIdentifierChanged);
    }

    private void setIsAdvertisingIdentifierNew(boolean isAdvertisingIdentifierNew) {
        DtbSharedPreferences.getInstance().saveIsAdIdNew(isAdvertisingIdentifierNew);
    }

    private void initializeAdvertisingInfo() {
        DtbLog.debug("Initializing advertising info using Google Play Service");
        DtbGooglePlayServices gps = new DtbGooglePlayServices();
        DtbGooglePlayServices.AdvertisingInfo advertisingInfo = gps.getAdvertisingIdentifierInfo();
        String currIdfa = advertisingInfo.getAdvertisingIdentifier();
        String storedIdfa = DtbSharedPreferences.getInstance().getIdfa();
        if (advertisingInfo.hasAdvertisingIdentifier() && !DtbCommonUtils.isNullOrEmpty(currIdfa)) {
            if (DtbCommonUtils.isNullOrEmpty(storedIdfa)) {
                this.setIsAdvertisingIdentifierNew(true);
                DtbLog.debug("Advertising identifier is new. Idfa=" + currIdfa);
            } else if (!DtbCommonUtils.isNullOrEmpty(storedIdfa) && !storedIdfa.equals(currIdfa)) {
                this.setIsAdvertisingIdentifierChanged(true);
                DtbLog.debug("Advertising identifier has changed. CurrentIdfa=" + currIdfa + " storedIdfa=" + storedIdfa);
            }
        }
        if (!advertisingInfo.hasAdvertisingIdentifier() && !DtbCommonUtils.isNullOrEmpty(storedIdfa)) {
            this.setIsAdvertisingIdentifierNew(true);
        }
        if (!DtbCommonUtils.isNullOrEmpty(currIdfa)) {
            DtbSharedPreferences.getInstance().saveIdfa(currIdfa);
        }
        if (advertisingInfo.isLimitAdTrackingEnabled() != null) {
            DtbSharedPreferences.getInstance().saveOptOut(advertisingInfo.isLimitAdTrackingEnabled());
        }
        DtbLog.info(LOG_TAG, "Advertising identifier intialization process complete");
        DtbLog.debug("Google AdId intialized using Google Play Service. AdvertisingIdentifier=" + currIdfa + " isLimitAdTrackingEnabled=" + advertisingInfo.isLimitAdTrackingEnabled());
    }
}

