/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DTBAdRequest;
import com.amazon.device.ads.DtbLog;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DtbCommonUtils {
    private static String sdkFlavor;
    private static final String IAB_GPP_STRING = "gpp";
    private static final String IAB_GPP_SID = "gpp_sid";

    private DtbCommonUtils() {
    }

    static boolean isClassAvailable(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static String getURLEncodedString(String s) {
        if (DtbCommonUtils.isNullOrEmpty(s)) {
            return s;
        }
        try {
            return URLEncoder.encode(s, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            DtbLog.debugError("Unable to url encode :" + s);
            return s;
        }
    }

    public static String getSDKMRAIDVersion() {
        String flavor = DtbCommonUtils.getSDKFlavor();
        if (flavor == null) {
            return "aps-android";
        }
        return "aps-android-" + flavor;
    }

    static String getSDKVersion() {
        String flavor = DtbCommonUtils.getSDKFlavor();
        if (flavor == null) {
            return "aps-android-9.9.1";
        }
        return "aps-android-9.9.1-" + flavor;
    }

    static String getSDKFlavor() {
        String mediationName;
        Map<String, String> customDictionary;
        if (sdkFlavor != null) {
            return sdkFlavor;
        }
        for (String name : AdRegistration.serverlessMarkers) {
            try {
                Class<?> clz = Class.forName(name);
                if (name.contains("admob")) {
                    sdkFlavor = "admob";
                    break;
                }
                if (name.contains("mopub")) {
                    sdkFlavor = "mopub";
                    break;
                }
                if (!name.contains("applovin")) break;
                sdkFlavor = "MAX";
                break;
            }
            catch (Exception exception) {
            }
        }
        if (!DtbCommonUtils.isNullOrEmpty(customDictionary = AdRegistration.getCustomDictionary()) && !DtbCommonUtils.isNullOrEmpty(mediationName = customDictionary.get("mediationName"))) {
            sdkFlavor = mediationName;
        }
        return sdkFlavor;
    }

    public static String getSDKFramework() {
        String framework = "unity";
        try {
            Class.forName("com.unity3d.player.UnityPlayerActivity");
        }
        catch (ClassNotFoundException classNotFoundException) {
            framework = "native";
        }
        return framework;
    }

    static boolean isOnMainThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    static int parseInt(String string, int defaultValue) {
        int value = defaultValue;
        try {
            value = Integer.parseInt(string);
        }
        catch (NumberFormatException var4) {
            DtbLog.debugError("Exception parsing the integer from string:" + string);
        }
        return value;
    }

    static Bundle getApplicationBundle() throws PackageManager.NameNotFoundException {
        if (AdRegistration.getContext() == null) {
            throw new IllegalStateException("Application Context can't be null");
        }
        return AdRegistration.getContext().getPackageManager().getApplicationInfo((String)AdRegistration.getContext().getPackageName(), (int)128).metaData;
    }

    static InputStream getResourceAsStream(String filename) {
        return DtbCommonUtils.class.getResourceAsStream(filename);
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.equals("");
    }

    static boolean isNullOrEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    static boolean isNullOrEmpty(List list) {
        return list == null || list.size() == 0;
    }

    public static boolean isNullOrWhiteSpace(String s) {
        return DtbCommonUtils.isNullOrEmpty(s) || s.trim().equals("");
    }

    static long getMilliSeconds(String seconds) {
        long sec = Long.parseLong(seconds);
        return sec * 1000L;
    }

    @TargetApi(value=17)
    static boolean isActivityDestroyed(Activity act) {
        return Build.VERSION.SDK_INT > 16 && act.isDestroyed();
    }

    static String getParamsAsJsonString(Map<String, Object> params) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        for (String k : params.keySet()) {
            jsonObject.put(k, params.get(k));
        }
        return jsonObject.toString();
    }

    static JSONObject getParamsAsJson(Map<String, Object> params) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        for (String k : params.keySet()) {
            jsonObject.put(k, params.get(k));
        }
        return jsonObject;
    }

    static String exceptionToString(Exception e) {
        String localizedMessage = e.getLocalizedMessage();
        return localizedMessage != null ? "(" + localizedMessage + ")" : "";
    }

    @Nullable
    static String getStringFieldValue(String fqClassName, String fieldName) {
        String result = null;
        try {
            Class<?> clazz = Class.forName(fqClassName);
            Field f = clazz.getDeclaredField(fieldName);
            f.setAccessible(true);
            if (!f.isAccessible()) {
                DtbLog.debug("Field:" + fieldName + " is not accessable");
                return null;
            }
            result = (String)f.get(null);
        }
        catch (NoSuchFieldException e) {
            DtbLog.debug("Field:" + fieldName + " does not exist");
        }
        catch (SecurityException e) {
            DtbLog.debug("Field:" + fieldName + " is not accessable");
        }
        catch (IllegalArgumentException e) {
            DtbLog.debug("Illegal Argument exception:" + e.getMessage());
        }
        catch (IllegalAccessException e) {
            DtbLog.debug("Illegal Access exception:" + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            DtbLog.debug("Class not found:" + fqClassName);
        }
        return result;
    }

    @Nullable
    static Integer getIntegerFieldValue(String fqClassName, String fieldName) {
        Integer result = null;
        try {
            Class<?> clazz = Class.forName(fqClassName);
            Field f = clazz.getDeclaredField(fieldName);
            f.setAccessible(true);
            if (!f.isAccessible()) {
                DtbLog.debug("Field:" + fieldName + " is not accessable");
                return null;
            }
            result = (Integer)f.get(null);
        }
        catch (NoSuchFieldException e) {
            DtbLog.debug("Field:" + fieldName + " does not exist");
        }
        catch (SecurityException e) {
            DtbLog.debug("Field:" + fieldName + " is not accessable");
        }
        catch (IllegalArgumentException e) {
            DtbLog.debug("Illegal Argument exception:" + e.getMessage());
        }
        catch (IllegalAccessException e) {
            DtbLog.debug("Illegal Access exception:" + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            DtbLog.debug("Class notFound:" + fqClassName);
            return null;
        }
        return result;
    }

    @NonNull
    static APIVersion getAPIVersion(String versionStr) {
        APIVersion version = new APIVersion();
        if (versionStr != null) {
            StringTokenizer tok = new StringTokenizer(versionStr, ".");
            String majorVersion = versionStr;
            String minorVersion = "0";
            if (tok.hasMoreTokens()) {
                majorVersion = tok.nextToken();
            }
            if (tok.hasMoreTokens()) {
                minorVersion = tok.nextToken();
            }
            try {
                version.majorVersion = Integer.parseInt(majorVersion);
                version.minorVersion = Integer.parseInt(minorVersion);
            }
            catch (NumberFormatException e) {
                DtbLog.warn("Invalid API version:" + versionStr);
            }
        }
        return version;
    }

    static boolean isNetworkConnected() {
        if (AdRegistration.getContext() != null && AdRegistration.getContext().checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE") == 0) {
            ConnectivityManager cm = (ConnectivityManager)AdRegistration.getContext().getSystemService("connectivity");
            if (cm != null) {
                if (Build.VERSION.SDK_INT < 23) {
                    NetworkInfo ni = cm.getActiveNetworkInfo();
                    if (ni != null) {
                        return ni.isConnected() && (ni.getType() == 1 || ni.getType() == 0);
                    }
                } else {
                    NetworkCapabilities nc;
                    Network n = cm.getActiveNetwork();
                    if (n != null && (nc = cm.getNetworkCapabilities(n)) != null) {
                        return nc.hasTransport(0) || nc.hasTransport(1);
                    }
                }
            }
            return false;
        }
        return true;
    }

    static String getHostNameFromUrl(String url) {
        String fullUrl = url;
        if (!url.startsWith("https://") && !url.startsWith("http://")) {
            fullUrl = "https://" + url;
        }
        String hostname = null;
        try {
            hostname = new URI(fullUrl).getHost();
        }
        catch (Exception ex) {
            DtbLog.error(String.format("The url %s that is passed for parsing is invalid. Please check the URL", new Object[0]));
        }
        return hostname;
    }

    static DTBAdRequest createAutoRefreshAdLoader(DTBAdRequest dtbAdRequest) {
        DTBAdRequest adLoader = new DTBAdRequest();
        if (!DtbCommonUtils.isNullOrEmpty(dtbAdRequest.getAdSizes())) {
            adLoader.setAdSizes(dtbAdRequest.getAdSizes());
        }
        if (!DtbCommonUtils.isNullOrEmpty(dtbAdRequest.getSlotGroupName())) {
            adLoader.setSlotGroup(dtbAdRequest.getSlotGroupName());
        }
        if (!DtbCommonUtils.isNullOrEmpty(dtbAdRequest.getCustomTargets())) {
            adLoader.setCustomTargets(dtbAdRequest.getCustomTargets());
        }
        adLoader.setRefreshFlag(true);
        return adLoader;
    }

    public static Bundle initializeEmptyBundle() {
        return new Bundle();
    }

    static HashMap<String, Object> addGPPParametersFromPreferences(SharedPreferences preferences) {
        HashMap<String, Object> regulatoryParams = new HashMap<String, Object>();
        try {
            Object IABGPP_SID;
            Object IABGPP_GppString;
            Object v0 = IABGPP_GppString = preferences.contains("IABGPP_HDR_GppString") ? preferences.getAll().get("IABGPP_HDR_GppString") : null;
            if (IABGPP_GppString instanceof String && !DtbCommonUtils.isNullOrEmpty(IABGPP_GppString)) {
                regulatoryParams.put(IAB_GPP_STRING, IABGPP_GppString);
            }
            Object v1 = IABGPP_SID = preferences.contains("IABGPP_GppSID") ? preferences.getAll().get("IABGPP_GppSID") : null;
            if (IABGPP_SID instanceof String && !DtbCommonUtils.isNullOrEmpty(IABGPP_SID)) {
                JSONArray array = new JSONArray();
                Pattern pattern = Pattern.compile("\\d+");
                Matcher matcher = pattern.matcher(IABGPP_SID);
                while (matcher.find()) {
                    for (int i = 0; i <= matcher.groupCount(); ++i) {
                        array.put(Integer.parseInt(matcher.group(i)));
                    }
                }
                if (array.length() > 0) {
                    regulatoryParams.put(IAB_GPP_SID, array);
                }
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to get Global privacy platform params from shared preference", e);
        }
        return regulatoryParams;
    }

    static class APIVersion {
        public int majorVersion = 0;
        public int minorVersion = 0;

        APIVersion() {
        }
    }
}

