/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import androidx.annotation.NonNull;
import com.amazon.device.ads.DtbCommonUtils;
import com.amazon.device.ads.DtbLog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import org.json.JSONException;

class DtbHttpClient {
    private HashMap<String, Object> params;
    private HashMap<String, Object> headers;
    private String url;
    private int responseCode;
    private String message;
    private boolean secure = true;
    private boolean isQueryParamsEnabled = false;
    private String response = null;

    protected String getResponse() {
        return this.response;
    }

    protected String getErrorMessage() {
        return this.message;
    }

    protected int getResponseCode() {
        return this.responseCode;
    }

    protected DtbHttpClient(String url) {
        this.url = url;
        this.params = new HashMap();
        this.headers = new HashMap();
    }

    protected void addParam(String name, String value) {
        this.params.put(name, value);
    }

    protected void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    protected HashMap<String, Object> getParams() {
        return this.params;
    }

    protected void setParams(HashMap<String, Object> m_params) {
        this.params = m_params;
    }

    protected HashMap<String, Object> getHeaders() {
        return this.headers;
    }

    protected void setHeaders(HashMap<String, Object> m_headers) {
        this.headers = m_headers;
    }

    protected String getUrl() {
        return this.url;
    }

    protected void setUrl(String url) {
        this.url = url;
    }

    public void setUseSecure(boolean value) {
        this.secure = value;
    }

    public void enableQueryParams() {
        this.isQueryParamsEnabled = true;
    }

    protected void executePOST(int readTimeout) throws JSONException, IOException {
        URL url;
        String fullUrl = (this.secure ? "https://" : "http://") + this.url;
        DtbLog.debug("POST URL:" + fullUrl);
        if (this.isQueryParamsEnabled) {
            String queryParams = this.getQueryParams();
            DtbLog.debug("with query params:[" + queryParams + "]");
            url = new URL(fullUrl + queryParams);
        } else {
            url = new URL(fullUrl);
        }
        this.executeRequest(HTTPMethod.POST, url, readTimeout);
    }

    public boolean isHttpStatusCodeOK() {
        return this.responseCode == 200;
    }

    private String getQueryParams() {
        String queryParams = "";
        if (!this.params.isEmpty()) {
            queryParams = queryParams + "?";
            for (String key : this.params.keySet()) {
                if (this.params.get(key) == null) continue;
                String paramString = key + "=" + DtbCommonUtils.getURLEncodedString(this.params.get(key).toString());
                if (queryParams.length() > 1) {
                    queryParams = queryParams + "&" + paramString;
                    continue;
                }
                queryParams = queryParams + paramString;
            }
        }
        return queryParams;
    }

    private String getParamsAsJsonString() throws JSONException {
        return DtbCommonUtils.getParamsAsJsonString(this.params);
    }

    protected void executeGET(int readTimeout) throws JSONException, IOException {
        String queryParams = this.getQueryParams();
        String fullUrl = this.url;
        if (!this.url.startsWith("https://") && !this.url.startsWith("http://")) {
            fullUrl = (this.secure ? "https://" : "http://") + this.url;
        }
        DtbLog.debug("GET URL:" + fullUrl);
        DtbLog.debug("with params: " + queryParams);
        URL url = new URL(fullUrl + queryParams);
        this.executeRequest(HTTPMethod.GET, url, readTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRequest(HTTPMethod method, URL url, int readTimeout) throws JSONException, IOException {
        HttpURLConnection con = this.createDefaultConnection(url, readTimeout);
        StringBuilder headerString = new StringBuilder();
        for (String k : this.headers.keySet()) {
            String value = this.headers.get(k) != null ? this.headers.get(k).toString() : "";
            con.setRequestProperty(k, value);
            headerString.append(k + ":" + value + " ");
        }
        DtbLog.debug("with headers:[" + headerString.toString() + "]");
        if (method == HTTPMethod.POST) {
            con.setDoOutput(true);
            if (!this.isQueryParamsEnabled && !this.params.isEmpty()) {
                con.setRequestProperty("content-type", "application/json; charset=utf-8");
                String jsonParams = this.getParamsAsJsonString();
                DtbLog.debug("with json params:[" + jsonParams + "]");
                OutputStream os = con.getOutputStream();
                os.write(jsonParams.getBytes());
                os.flush();
                os.close();
            }
        }
        try {
            InputStream is = con.getInputStream();
            if (is == null) {
                return;
            }
            this.responseCode = con.getResponseCode();
            this.message = con.getResponseMessage();
            this.response = DtbHttpClient.convertStreamToString(is);
            is.close();
            DtbLog.debug("Response :" + this.response);
        }
        catch (Exception e) {
            this.response = null;
            DtbLog.debug("Error while connecting to remote server: " + con.getURL().toString() + " with error:" + e.getMessage());
        }
        finally {
            con.disconnect();
        }
    }

    private HttpURLConnection createDefaultConnection(URL url, int readTimeout) throws IOException {
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setConnectTimeout(1000);
        con.setReadTimeout(readTimeout);
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static String convertStreamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException e) {
            DtbLog.debug("Error converting stream to string. Ex=" + e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return sb.toString();
    }

    private static enum HTTPMethod {
        POST,
        GET;

    }
}

