/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.util.Log;
import com.amazon.device.ads.DTBLogLevel;
import com.amazon.device.ads.DtbLogListener;

public class DtbLog {
    private static boolean androidLogAvailable;
    private static final Object listenerLock;
    private static final String sdkName = "Amazon DTB Ads API";
    private static boolean isCallerInfoEnabled;
    private static final String DEBUG_ERROR = "DTBERROR::";
    private static DTBLogLevel logLevel;
    private static DtbLogListener logListener;

    protected static void enableCallerInfo(boolean value) {
        isCallerInfoEnabled = value;
    }

    public static void setLogLevel(DTBLogLevel level) {
        logLevel = level;
    }

    private static String getTag() {
        String tag = sdkName;
        if (isCallerInfoEnabled) {
            tag = DtbLog.getCallerInfo();
        }
        return tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void postMessageToListener(String tag, DTBLogLevel level, String message) {
        if (logListener == null) {
            return;
        }
        Object object = listenerLock;
        synchronized (object) {
            if (logListener != null && tag.equals(logListener.getTag())) {
                logListener.postMessage(level, message);
            }
        }
    }

    public static void info(String message) {
        if (logLevel.intValue() <= DTBLogLevel.Info.intValue() && androidLogAvailable) {
            Log.i((String)DtbLog.getTag(), (String)message);
        }
    }

    public static void info(String logTag, String message) {
        if (logLevel.intValue() <= DTBLogLevel.Info.intValue() && androidLogAvailable) {
            Log.i((String)logTag, (String)message);
            DtbLog.postMessageToListener(logTag, DTBLogLevel.Info, message);
        }
    }

    public static void warn(String message) {
        if (logLevel.intValue() <= DTBLogLevel.Warn.intValue() && androidLogAvailable) {
            Log.w((String)DtbLog.getTag(), (String)message);
        }
    }

    public static void warn(String logTag, String message) {
        if (logLevel.intValue() <= DTBLogLevel.Warn.intValue() && androidLogAvailable) {
            Log.w((String)logTag, (String)message);
            DtbLog.postMessageToListener(logTag, DTBLogLevel.Warn, message);
        }
    }

    public static void debug(String message) {
        if (logLevel.intValue() <= DTBLogLevel.Debug.intValue() && androidLogAvailable) {
            Log.d((String)DtbLog.getTag(), (String)message);
        }
    }

    public static void debug(String logTag, String message) {
        if (logLevel.intValue() <= DTBLogLevel.Debug.intValue() && androidLogAvailable) {
            Log.d((String)logTag, (String)message);
            DtbLog.postMessageToListener(logTag, DTBLogLevel.Debug, message);
        }
    }

    public static void debugError(String message) {
        if (logLevel.intValue() <= DTBLogLevel.Debug.intValue() && androidLogAvailable) {
            Log.d((String)DtbLog.getTag(), (String)(DEBUG_ERROR + message));
        }
    }

    public static void debugError(String logTag, String message) {
        if (logLevel.intValue() <= DTBLogLevel.Debug.intValue() && androidLogAvailable) {
            Log.d((String)logTag, (String)(DEBUG_ERROR + message));
            DtbLog.postMessageToListener(logTag, DTBLogLevel.Debug, DEBUG_ERROR + message);
        }
    }

    public static void error(String message) {
        if (logLevel.intValue() <= DTBLogLevel.Error.intValue() && androidLogAvailable) {
            Log.e((String)DtbLog.getTag(), (String)message);
        }
    }

    public static void error(String logTag, String message) {
        if (logLevel.intValue() <= DTBLogLevel.Error.intValue() && androidLogAvailable) {
            Log.e((String)logTag, (String)message);
            DtbLog.postMessageToListener(logTag, DTBLogLevel.Error, message);
        }
    }

    public static void fatal(String logTag, String message) {
        if (logLevel.intValue() <= DTBLogLevel.Fatal.intValue() && androidLogAvailable) {
            Log.e((String)logTag, (String)message);
            DtbLog.postMessageToListener(logTag, DTBLogLevel.Fatal, message);
        }
    }

    public static void fatal(String message) {
        if (logLevel.intValue() <= DTBLogLevel.Fatal.intValue() && androidLogAvailable) {
            Log.e((String)DtbLog.getTag(), (String)message);
        }
    }

    public static void fatal(String message, Exception e) {
        if (logLevel.intValue() <= DTBLogLevel.Fatal.intValue() && androidLogAvailable) {
            Log.e((String)DtbLog.getTag(), (String)message, (Throwable)e);
        }
    }

    public static void fatal(String logTag, String message, Exception e) {
        if (logLevel.intValue() <= DTBLogLevel.Fatal.intValue() && androidLogAvailable) {
            Log.e((String)logTag, (String)message, (Throwable)e);
            DtbLog.postMessageToListener(logTag, DTBLogLevel.Fatal, message);
        }
    }

    private static String getCallerInfo() {
        if (!isCallerInfoEnabled) {
            return sdkName;
        }
        StackTraceElement callerStack = null;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace != null) {
            for (int i = 0; i < stackTrace.length; ++i) {
                String className = stackTrace[i].getClassName();
                if (className.startsWith("dalvik") || className.startsWith("java")) continue;
                callerStack = stackTrace[i + 2 < stackTrace.length ? i + 2 : i];
                break;
            }
        }
        return callerStack != null ? callerStack.getClassName() + ":" + callerStack.getMethodName() + ":" + callerStack.getLineNumber() : sdkName;
    }

    static {
        try {
            Log.isLoggable((String)"1234", (int)7);
            androidLogAvailable = true;
        }
        catch (Throwable t) {
            androidLogAvailable = false;
        }
        listenerLock = new Object();
        isCallerInfoEnabled = false;
        logLevel = DTBLogLevel.Warn;
    }
}

