/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.DtbNetworkState;

enum DtbMetric {
    AAX_BID_TIME("dabtw", "dabt3", DtbMetricType.TIMER),
    AAX_PUNTED("dapw", "dap3", DtbMetricType.COUNTER),
    AAX_NETWORK_FAILURE("danfw", "danf3", DtbMetricType.COUNTER),
    BANNER_ADSERVER_TIME("dbastw", "dbast3", DtbMetricType.TIMER),
    INTERSTITIAL_ADSERVER_TIME("diastw", "diast3", DtbMetricType.TIMER),
    ADSERVER_ADLOAD_FAILURE("dasfw", "dasf3", DtbMetricType.COUNTER),
    BANNER_TOTAL_LOAD_TIME("dbtltw", "dbtlt3", DtbMetricType.TIMER),
    INTERSTITIAL_TOTAL_LOAD_TIME("ditltw", "ditlt3", DtbMetricType.TIMER),
    CONFIG_DOWNLOAD_LATENCY("acl", "acl", DtbMetricType.TIMER),
    SIS_LATENCY_UPDATE_DEVICE_INFO("sul", "sul", DtbMetricType.TIMER),
    SIS_COUNTER_IDENTIFIED_DEVICE_CHANGED("sid", "sid", DtbMetricType.COUNTER),
    SIS_LATENCY_REGISTER_EVENT("srel", "srel", DtbMetricType.TIMER);

    private final String aaxNameWifi;
    private final String aaxName3g;
    private final DtbMetricType metricType;

    private DtbMetric(String aaxNameWifi, String aaxName3g, DtbMetricType metricType) {
        this.aaxNameWifi = aaxNameWifi;
        this.aaxName3g = aaxName3g;
        this.metricType = metricType;
    }

    public String getAAXName() {
        return DtbNetworkState.INSTANCE.isWifiConnection() ? this.aaxNameWifi : this.aaxName3g;
    }

    public DtbMetricType getMetricType() {
        return this.metricType;
    }

    public String toString() {
        return "[" + this.getAAXName() + ", " + (Object)((Object)this.getMetricType()) + "]";
    }

    static enum DtbMetricType {
        COUNTER,
        TIMER;

    }
}

