/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.DTBAdMRAIDController;
import com.amazon.device.ads.MraidCommand;
import org.json.JSONException;
import org.json.JSONObject;

public class MraidOpenCommand
extends MraidCommand {
    static final String NAME = "open";

    @Override
    public String getName() {
        return NAME;
    }

    static String getMraidName() {
        return NAME;
    }

    @Override
    public void execute(JSONObject arguments, DTBAdMRAIDController controller) throws JSONException {
        if (arguments.has("options") && arguments.getJSONObject("options").has("inAppNativeBrowser")) {
            JSONObject customTabsIndicator = arguments.getJSONObject("options").getJSONObject("inAppNativeBrowser");
            try {
                if (customTabsIndicator.has("enabled") && customTabsIndicator.getBoolean("enabled")) {
                    controller.openUrl(arguments.getString("url"), customTabsIndicator.getBoolean("enabled"));
                }
            }
            catch (Exception e) {
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Failed to execute Open command with inAppNativeBrowser", e);
            }
        } else {
            controller.openUrl(arguments.getString("url"));
        }
    }
}

