/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.os.Build;
import android.telephony.TelephonyManager;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DTBAdResponse;
import com.amazon.device.ads.DTBMetricsConfiguration;
import com.amazon.device.ads.DtbCommonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SDKUtilities {
    private static final String LOG_TAG = SDKUtilities.class.getSimpleName();
    private static String amznDebugStateFlag = "false";
    static final String BID_HTML_TEMPLATE = "<div style=\"display:inline-block\"><div id=\"__dtbAd__\" style=\"overflow:hidden;\"><!--Placeholder for the Ad --></div><script type=\"text/javascript\">amzn.dtb.loadAd(\"%s\", \"%s\", \"%s\", %s, {isv: %s, dc: \"%s\", skipafter: %s, vtype: \"%s\"});</script></div>";

    public static String getBidInfo(DTBAdResponse response) {
        try {
            Map<String, List<String>> kvpDictionary;
            List<String> temp;
            Map<String, List<String>> params;
            if (response.getDTBAds().size() == 0) {
                return "";
            }
            String reply = "";
            String bidId = "";
            String hostName = "";
            String pricePoint = "";
            String dc = "";
            String videoInventoryType = "";
            if (response.isVideo()) {
                params = response.getVideoAdsRequestCustomParamsAsList();
                temp = params.get("amzn_vid");
            } else {
                params = response.getDefaultDisplayAdsRequestCustomParams();
                temp = params.get("amzn_b");
            }
            if (!DtbCommonUtils.isNullOrEmpty(temp)) {
                bidId = temp.get(0);
            }
            if (!DtbCommonUtils.isNullOrEmpty(temp = params.get("amzn_h"))) {
                hostName = temp.get(0);
            }
            if (!DtbCommonUtils.isNullOrEmpty(temp = params.get("amznslots"))) {
                pricePoint = temp.get(0);
            }
            if ((kvpDictionary = response.getKvpDictionary()).containsKey("dc") && kvpDictionary.get("dc").size() != 0) {
                dc = kvpDictionary.get("dc").get(0);
            }
            if (!DtbCommonUtils.isNullOrEmpty(response.getVideoInventoryType())) {
                videoInventoryType = response.getVideoInventoryType();
            }
            String creativeTemplate = DTBMetricsConfiguration.getClientConfigVal("creative", BID_HTML_TEMPLATE, "templates");
            reply = String.format(creativeTemplate, pricePoint, bidId, hostName, amznDebugStateFlag, response.isVideo(), dc, response.getVideoSkipAfterDurationInSeconds(), videoInventoryType);
            return reply;
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to execute getBidInfo method", e);
            return "";
        }
    }

    public static String getPricePoint(DTBAdResponse response) {
        String pricePoint = "";
        try {
            Map<String, List<String>> params = response.isVideo() ? response.getVideoAdsRequestCustomParamsAsList() : response.getDefaultDisplayAdsRequestCustomParams();
            List<String> temp = params.get("amznslots");
            if (temp != null && temp.size() > 0) {
                pricePoint = temp.get(0);
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to execute getPricePoint method", e);
        }
        return pricePoint;
    }

    static int getWidth(DTBAdResponse response) {
        if (response.getDTBAds().size() == 0) {
            return -1;
        }
        return response.getDTBAds().get(0).getWidth();
    }

    static int getHeight(DTBAdResponse response) {
        if (response.getDTBAds().size() == 0) {
            return -1;
        }
        return response.getDTBAds().get(0).getHeight();
    }

    public static boolean isTelSupported() {
        try {
            if (Build.VERSION.SDK_INT >= 23 && AdRegistration.getContext().checkSelfPermission("android.permission.CALL_PHONE") != 0) {
                return false;
            }
            TelephonyManager tm = (TelephonyManager)AdRegistration.getContext().getSystemService("phone");
            return tm.getPhoneType() != 0;
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute isTelSupported method", e);
            return false;
        }
    }

    protected static Map<String, Object> convertJSONObjectToMap(JSONObject arguments) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keys = arguments.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = arguments.get(key);
            if (value instanceof JSONObject) {
                map.put(key, SDKUtilities.convertJSONObjectToMap((JSONObject)value));
                continue;
            }
            if (value instanceof JSONArray) {
                map.put(key, SDKUtilities.convertJSONArrayToList((JSONArray)value));
                continue;
            }
            map.put(key, value);
        }
        return map;
    }

    protected static List<Object> convertJSONArrayToList(JSONArray array) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            List<Object> value = array.get(i);
            if (value instanceof JSONArray) {
                value = SDKUtilities.convertJSONArrayToList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = SDKUtilities.convertJSONObjectToMap((JSONObject)value);
            }
            list.add(value);
        }
        return list;
    }

    @Deprecated
    public static boolean isEmulator() {
        try {
            String fingerPrint = Build.FINGERPRINT;
            String model = Build.MODEL;
            String manufacturer = Build.MANUFACTURER;
            return fingerPrint.startsWith("generic") || fingerPrint.startsWith("unknown") || model.contains("google_sdk") || model.contains("Emulator") || model.contains("Android SDK built for x86") || manufacturer.contains("Genymotion") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || "google_sdk".equals(Build.PRODUCT);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute isEmulator method", e);
            return false;
        }
    }

    static void setAmznDebugStateFlagValue(String vFlag) {
        amznDebugStateFlag = vFlag;
    }

    public static class SimpleSize {
        int width;
        int height;

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public SimpleSize(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }
}

