/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.AdminDisableProviderForUserRequest;
import com.amazonaws.services.cognitoidentityprovider.model.ProviderUserIdentifierType;
import com.amazonaws.services.cognitoidentityprovider.model.transform.ProviderUserIdentifierTypeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class AdminDisableProviderForUserRequestMarshaller
implements Marshaller<Request<AdminDisableProviderForUserRequest>, AdminDisableProviderForUserRequest> {
    public Request<AdminDisableProviderForUserRequest> marshall(AdminDisableProviderForUserRequest adminDisableProviderForUserRequest) {
        if (adminDisableProviderForUserRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(AdminDisableProviderForUserRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)adminDisableProviderForUserRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.AdminDisableProviderForUser";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (adminDisableProviderForUserRequest.getUserPoolId() != null) {
                String userPoolId = adminDisableProviderForUserRequest.getUserPoolId();
                jsonWriter.name("UserPoolId");
                jsonWriter.value(userPoolId);
            }
            if (adminDisableProviderForUserRequest.getUser() != null) {
                ProviderUserIdentifierType user = adminDisableProviderForUserRequest.getUser();
                jsonWriter.name("User");
                ProviderUserIdentifierTypeJsonMarshaller.getInstance().marshall(user, jsonWriter);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

