/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentity.model.SetPrincipalTagAttributeMapRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.StringWriter;
import java.util.Map;

public class SetPrincipalTagAttributeMapRequestMarshaller
implements Marshaller<Request<SetPrincipalTagAttributeMapRequest>, SetPrincipalTagAttributeMapRequest> {
    @Override
    public Request<SetPrincipalTagAttributeMapRequest> marshall(SetPrincipalTagAttributeMapRequest setPrincipalTagAttributeMapRequest) {
        if (setPrincipalTagAttributeMapRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(SetPrincipalTagAttributeMapRequest)");
        }
        DefaultRequest<SetPrincipalTagAttributeMapRequest> request = new DefaultRequest<SetPrincipalTagAttributeMapRequest>(setPrincipalTagAttributeMapRequest, "AmazonCognitoIdentity");
        String target = "AWSCognitoIdentityService.SetPrincipalTagAttributeMap";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter(stringWriter);
            jsonWriter.beginObject();
            if (setPrincipalTagAttributeMapRequest.getIdentityPoolId() != null) {
                String identityPoolId = setPrincipalTagAttributeMapRequest.getIdentityPoolId();
                jsonWriter.name("IdentityPoolId");
                jsonWriter.value(identityPoolId);
            }
            if (setPrincipalTagAttributeMapRequest.getIdentityProviderName() != null) {
                String identityProviderName = setPrincipalTagAttributeMapRequest.getIdentityProviderName();
                jsonWriter.name("IdentityProviderName");
                jsonWriter.value(identityProviderName);
            }
            if (setPrincipalTagAttributeMapRequest.getUseDefaults() != null) {
                Boolean useDefaults = setPrincipalTagAttributeMapRequest.getUseDefaults();
                jsonWriter.name("UseDefaults");
                jsonWriter.value(useDefaults);
            }
            if (setPrincipalTagAttributeMapRequest.getPrincipalTags() != null) {
                Map<String, String> principalTags = setPrincipalTagAttributeMapRequest.getPrincipalTags();
                jsonWriter.name("PrincipalTags");
                jsonWriter.beginObject();
                for (Map.Entry<String, String> principalTagsEntry : principalTags.entrySet()) {
                    String principalTagsValue = principalTagsEntry.getValue();
                    if (principalTagsValue == null) continue;
                    jsonWriter.name(principalTagsEntry.getKey());
                    jsonWriter.value(principalTagsValue);
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

