/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.client;

import com.amazonaws.internal.keyvaluestore.AWSKeyValueStore;
import com.amazonaws.mobile.client.AWSMobileClient;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class AWSMobileClientStore {
    AWSKeyValueStore mAWSKeyValueStore;
    private ReadWriteLock mReadWriteLock = new ReentrantReadWriteLock();

    AWSMobileClientStore(AWSMobileClient client) {
        this.mAWSKeyValueStore = new AWSKeyValueStore(client.mContext, "com.amazonaws.mobile.client", client.mIsPersistenceEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, String> get(String ... keys) {
        try {
            this.mReadWriteLock.readLock().lock();
            HashMap<String, String> attributes = new HashMap<String, String>();
            for (String key : keys) {
                attributes.put(key, this.mAWSKeyValueStore.get(key));
            }
            HashMap<String, String> hashMap = attributes;
            return hashMap;
        }
        finally {
            this.mReadWriteLock.readLock().unlock();
        }
    }

    String get(String key) {
        try {
            this.mReadWriteLock.readLock().lock();
            String string = this.mAWSKeyValueStore.get(key);
            return string;
        }
        finally {
            this.mReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set(Map<String, String> attributes) {
        try {
            this.mReadWriteLock.writeLock().lock();
            for (String key : attributes.keySet()) {
                this.mAWSKeyValueStore.put(key, attributes.get(key));
            }
        }
        finally {
            this.mReadWriteLock.writeLock().unlock();
        }
    }

    void set(String key, String value) {
        try {
            this.mReadWriteLock.writeLock().lock();
            this.mAWSKeyValueStore.put(key, value);
        }
        finally {
            this.mReadWriteLock.writeLock().unlock();
        }
    }

    void clear() {
        this.mAWSKeyValueStore.clear();
    }
}

