/*
 * Decompiled with CFR 0.152.
 */
package com.amplitude.api;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDoneException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import com.amplitude.api.AmplitudeLog;
import com.amplitude.api.CursorWindowAllocationException;
import com.amplitude.api.DatabaseResetListener;
import com.amplitude.api.Utils;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class DatabaseHelper
extends SQLiteOpenHelper {
    private static final String TAG = DatabaseHelper.class.getName();
    static final Map<String, DatabaseHelper> instances = new HashMap<String, DatabaseHelper>();
    protected static final String STORE_TABLE_NAME = "store";
    protected static final String LONG_STORE_TABLE_NAME = "long_store";
    private static final String KEY_FIELD = "key";
    private static final String VALUE_FIELD = "value";
    protected static final String EVENT_TABLE_NAME = "events";
    protected static final String IDENTIFY_TABLE_NAME = "identifys";
    private static final String ID_FIELD = "id";
    private static final String EVENT_FIELD = "event";
    private static final String CREATE_STORE_TABLE = "CREATE TABLE IF NOT EXISTS store (key TEXT PRIMARY KEY NOT NULL, value TEXT);";
    private static final String CREATE_LONG_STORE_TABLE = "CREATE TABLE IF NOT EXISTS long_store (key TEXT PRIMARY KEY NOT NULL, value INTEGER);";
    private static final String CREATE_EVENTS_TABLE = "CREATE TABLE IF NOT EXISTS events (id INTEGER PRIMARY KEY AUTOINCREMENT, event TEXT);";
    private static final String CREATE_IDENTIFYS_TABLE = "CREATE TABLE IF NOT EXISTS identifys (id INTEGER PRIMARY KEY AUTOINCREMENT, event TEXT);";
    File file;
    private String instanceName;
    private boolean callResetListenerOnDatabaseReset = true;
    private DatabaseResetListener databaseResetListener;
    private static final AmplitudeLog logger = AmplitudeLog.getLogger();

    @Deprecated
    static DatabaseHelper getDatabaseHelper(Context context) {
        return DatabaseHelper.getDatabaseHelper(context, null);
    }

    static synchronized DatabaseHelper getDatabaseHelper(Context context, String instance) {
        DatabaseHelper dbHelper = instances.get(instance = Utils.normalizeInstanceName(instance));
        if (dbHelper == null) {
            dbHelper = new DatabaseHelper(context.getApplicationContext(), instance);
            instances.put(instance, dbHelper);
        }
        return dbHelper;
    }

    private static String getDatabaseName(String instance) {
        return Utils.isEmptyString(instance) || instance.equals("$default_instance") ? "com.amplitude.api" : "com.amplitude.api_" + instance;
    }

    protected DatabaseHelper(Context context) {
        this(context, null);
    }

    protected DatabaseHelper(Context context, String instance) {
        super(context, DatabaseHelper.getDatabaseName(instance), null, 3);
        this.file = context.getDatabasePath(DatabaseHelper.getDatabaseName(instance));
        this.instanceName = Utils.normalizeInstanceName(instance);
    }

    void setDatabaseResetListener(DatabaseResetListener databaseResetListener) {
        this.databaseResetListener = databaseResetListener;
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL(CREATE_STORE_TABLE);
        db.execSQL(CREATE_LONG_STORE_TABLE);
        db.execSQL(CREATE_EVENTS_TABLE);
        db.execSQL(CREATE_IDENTIFYS_TABLE);
        if (this.databaseResetListener != null && this.callResetListenerOnDatabaseReset) {
            try {
                this.callResetListenerOnDatabaseReset = false;
                this.databaseResetListener.onDatabaseReset(db);
            }
            catch (SQLiteException e) {
                logger.e(TAG, String.format("databaseReset callback failed during onCreate", new Object[0]), e);
            }
            finally {
                this.callResetListenerOnDatabaseReset = true;
            }
        }
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion > newVersion) {
            logger.e(TAG, "onUpgrade() with invalid oldVersion and newVersion");
            this.resetDatabase(db);
            return;
        }
        if (newVersion <= 1) {
            return;
        }
        switch (oldVersion) {
            case 1: {
                db.execSQL(CREATE_STORE_TABLE);
                if (newVersion <= 2) break;
            }
            case 2: {
                db.execSQL(CREATE_IDENTIFYS_TABLE);
                db.execSQL(CREATE_LONG_STORE_TABLE);
                if (newVersion <= 3) break;
            }
            case 3: {
                break;
            }
            default: {
                logger.e(TAG, "onUpgrade() with unknown oldVersion " + oldVersion);
                this.resetDatabase(db);
            }
        }
    }

    private void resetDatabase(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS store");
        db.execSQL("DROP TABLE IF EXISTS long_store");
        db.execSQL("DROP TABLE IF EXISTS events");
        db.execSQL("DROP TABLE IF EXISTS identifys");
        this.onCreate(db);
    }

    synchronized long insertOrReplaceKeyValue(String key, String value) {
        return value == null ? this.deleteKeyFromTable(STORE_TABLE_NAME, key) : this.insertOrReplaceKeyValueToTable(STORE_TABLE_NAME, key, value);
    }

    synchronized long insertOrReplaceKeyLongValue(String key, Long value) {
        return value == null ? this.deleteKeyFromTable(LONG_STORE_TABLE_NAME, key) : this.insertOrReplaceKeyValueToTable(LONG_STORE_TABLE_NAME, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized long insertOrReplaceKeyValueToTable(String table, String key, Object value) {
        long result = -1L;
        SQLiteDatabase db = null;
        try {
            db = this.getWritableDatabase();
            result = this.insertOrReplaceKeyValueToTable(db, table, key, value);
        }
        catch (SQLiteException e) {
            logger.e(TAG, String.format("insertOrReplaceKeyValue in %s failed", table), e);
            this.delete();
        }
        catch (StackOverflowError e) {
            logger.e(TAG, String.format("insertOrReplaceKeyValue in %s failed", table), e);
            this.delete();
        }
        finally {
            if (db != null && db.isOpen()) {
                this.close();
            }
        }
        return result;
    }

    synchronized long insertOrReplaceKeyValueToTable(SQLiteDatabase db, String table, String key, Object value) throws SQLiteException, StackOverflowError {
        long result = -1L;
        ContentValues contentValues = new ContentValues();
        contentValues.put(KEY_FIELD, key);
        if (value instanceof Long) {
            contentValues.put(VALUE_FIELD, (Long)value);
        } else {
            contentValues.put(VALUE_FIELD, (String)value);
        }
        result = this.insertKeyValueContentValuesIntoTable(db, table, contentValues);
        if (result == -1L) {
            logger.w(TAG, "Insert failed");
        }
        return result;
    }

    synchronized long insertKeyValueContentValuesIntoTable(SQLiteDatabase db, String table, ContentValues contentValues) throws SQLiteException, StackOverflowError {
        return db.insertWithOnConflict(table, null, contentValues, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized long deleteKeyFromTable(String table, String key) {
        long result = -1L;
        try {
            SQLiteDatabase db = this.getWritableDatabase();
            result = db.delete(table, "key=?", new String[]{key});
        }
        catch (SQLiteException e) {
            logger.e(TAG, String.format("deleteKey from %s failed", table), e);
            this.delete();
        }
        catch (StackOverflowError e) {
            logger.e(TAG, String.format("deleteKey from %s failed", table), e);
            this.delete();
        }
        finally {
            this.close();
        }
        return result;
    }

    synchronized long addEvent(String event) {
        return this.addEventToTable(EVENT_TABLE_NAME, event);
    }

    synchronized long addIdentify(String identifyEvent) {
        return this.addEventToTable(IDENTIFY_TABLE_NAME, identifyEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long addEventToTable(String table, String event) {
        long result = -1L;
        try {
            SQLiteDatabase db = this.getWritableDatabase();
            ContentValues contentValues = new ContentValues();
            contentValues.put(EVENT_FIELD, event);
            result = this.insertEventContentValuesIntoTable(db, table, contentValues);
            if (result == -1L) {
                logger.w(TAG, String.format("Insert into %s failed", table));
            }
        }
        catch (SQLiteException e) {
            logger.e(TAG, String.format("addEvent to %s failed", table), e);
            this.delete();
        }
        catch (StackOverflowError e) {
            logger.e(TAG, String.format("addEvent to %s failed", table), e);
            this.delete();
        }
        finally {
            this.close();
        }
        return result;
    }

    synchronized long insertEventContentValuesIntoTable(SQLiteDatabase db, String table, ContentValues contentValues) throws SQLiteException, StackOverflowError {
        return db.insert(table, null, contentValues);
    }

    synchronized String getValue(String key) {
        return (String)this.getValueFromTable(STORE_TABLE_NAME, key);
    }

    synchronized Long getLongValue(String key) {
        return (Long)this.getValueFromTable(LONG_STORE_TABLE_NAME, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Object getValueFromTable(String table, String key) {
        Object value = null;
        Cursor cursor = null;
        try {
            SQLiteDatabase db = this.getReadableDatabase();
            cursor = this.queryDb(db, table, new String[]{KEY_FIELD, VALUE_FIELD}, "key = ?", new String[]{key}, null, null, null, null);
            if (cursor.moveToFirst()) {
                value = table.equals(STORE_TABLE_NAME) ? cursor.getString(1) : Long.valueOf(cursor.getLong(1));
            }
        }
        catch (SQLiteException e) {
            logger.e(TAG, String.format("getValue from %s failed", table), e);
            this.delete();
        }
        catch (StackOverflowError e) {
            logger.e(TAG, String.format("getValue from %s failed", table), e);
            this.delete();
        }
        catch (IllegalStateException e) {
            this.handleIfCursorRowTooLargeException(e);
        }
        catch (RuntimeException e) {
            DatabaseHelper.convertIfCursorWindowException(e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.close();
        }
        return value;
    }

    synchronized List<JSONObject> getEvents(long upToId, long limit) throws JSONException {
        return this.getEventsFromTable(EVENT_TABLE_NAME, upToId, limit);
    }

    synchronized List<JSONObject> getIdentifys(long upToId, long limit) throws JSONException {
        return this.getEventsFromTable(IDENTIFY_TABLE_NAME, upToId, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized List<JSONObject> getEventsFromTable(String table, long upToId, long limit) throws JSONException {
        LinkedList<JSONObject> events = new LinkedList<JSONObject>();
        Cursor cursor = null;
        try {
            SQLiteDatabase db = this.getReadableDatabase();
            cursor = this.queryDb(db, table, new String[]{ID_FIELD, EVENT_FIELD}, upToId >= 0L ? "id <= " + upToId : null, null, null, null, "id ASC", limit >= 0L ? "" + limit : null);
            while (cursor.moveToNext()) {
                long eventId = cursor.getLong(0);
                String event = cursor.getString(1);
                if (Utils.isEmptyString(event)) continue;
                JSONObject obj = new JSONObject(event);
                obj.put("event_id", eventId);
                events.add(obj);
            }
        }
        catch (SQLiteException e) {
            logger.e(TAG, String.format("getEvents from %s failed", table), e);
            this.delete();
        }
        catch (StackOverflowError e) {
            logger.e(TAG, String.format("getEvents from %s failed", table), e);
            this.delete();
        }
        catch (IllegalStateException e) {
            this.handleIfCursorRowTooLargeException(e);
        }
        catch (RuntimeException e) {
            DatabaseHelper.convertIfCursorWindowException(e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.close();
        }
        return events;
    }

    synchronized long getEventCount() {
        return this.getEventCountFromTable(EVENT_TABLE_NAME);
    }

    synchronized long getIdentifyCount() {
        return this.getEventCountFromTable(IDENTIFY_TABLE_NAME);
    }

    synchronized long getTotalEventCount() {
        return this.getEventCount() + this.getIdentifyCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long getEventCountFromTable(String table) {
        long numberRows = 0L;
        SQLiteStatement statement = null;
        try {
            SQLiteDatabase db = this.getReadableDatabase();
            String query = "SELECT COUNT(*) FROM " + table;
            statement = db.compileStatement(query);
            numberRows = statement.simpleQueryForLong();
        }
        catch (SQLiteException e) {
            logger.e(TAG, String.format("getNumberRows for %s failed", table), e);
            this.delete();
        }
        catch (StackOverflowError e) {
            logger.e(TAG, String.format("getNumberRows for %s failed", table), e);
            this.delete();
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            this.close();
        }
        return numberRows;
    }

    synchronized long getNthEventId(long n) {
        return this.getNthEventIdFromTable(EVENT_TABLE_NAME, n);
    }

    synchronized long getNthIdentifyId(long n) {
        return this.getNthEventIdFromTable(IDENTIFY_TABLE_NAME, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long getNthEventIdFromTable(String table, long n) {
        long nthEventId = -1L;
        SQLiteStatement statement = null;
        try {
            SQLiteDatabase db = this.getReadableDatabase();
            String query = "SELECT id FROM " + table + " LIMIT 1 OFFSET " + (n - 1L);
            statement = db.compileStatement(query);
            nthEventId = -1L;
            try {
                nthEventId = statement.simpleQueryForLong();
            }
            catch (SQLiteDoneException e) {
                logger.w(TAG, e);
            }
        }
        catch (SQLiteException e) {
            logger.e(TAG, String.format("getNthEventId from %s failed", table), e);
            this.delete();
        }
        catch (StackOverflowError e) {
            logger.e(TAG, String.format("getNthEventId from %s failed", table), e);
            this.delete();
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            this.close();
        }
        return nthEventId;
    }

    synchronized void removeEvents(long maxId) {
        this.removeEventsFromTable(EVENT_TABLE_NAME, maxId);
    }

    synchronized void removeIdentifys(long maxId) {
        this.removeEventsFromTable(IDENTIFY_TABLE_NAME, maxId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void removeEventsFromTable(String table, long maxId) {
        try {
            SQLiteDatabase db = this.getWritableDatabase();
            db.delete(table, "id <= " + maxId, null);
        }
        catch (SQLiteException e) {
            logger.e(TAG, String.format("removeEvents from %s failed", table), e);
            this.delete();
        }
        catch (StackOverflowError e) {
            logger.e(TAG, String.format("removeEvents from %s failed", table), e);
            this.delete();
        }
        finally {
            this.close();
        }
    }

    synchronized void removeEvent(long id) {
        this.removeEventFromTable(EVENT_TABLE_NAME, id);
    }

    synchronized void removeIdentify(long id) {
        this.removeEventFromTable(IDENTIFY_TABLE_NAME, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void removeEventFromTable(String table, long id) {
        try {
            SQLiteDatabase db = this.getWritableDatabase();
            db.delete(table, "id = " + id, null);
        }
        catch (SQLiteException e) {
            logger.e(TAG, String.format("removeEvent from %s failed", table), e);
            this.delete();
        }
        catch (StackOverflowError e) {
            logger.e(TAG, String.format("removeEvent from %s failed", table), e);
            this.delete();
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void delete() {
        try {
            this.close();
            this.file.delete();
            return;
        }
        catch (SecurityException e) {
            logger.e(TAG, "delete failed", e);
            return;
        }
        finally {
            if (this.databaseResetListener != null && this.callResetListenerOnDatabaseReset) {
                this.callResetListenerOnDatabaseReset = false;
                SQLiteDatabase db = null;
                try {
                    db = this.getWritableDatabase();
                    this.databaseResetListener.onDatabaseReset(db);
                }
                catch (SQLiteException e) {
                    logger.e(TAG, String.format("databaseReset callback failed during delete", new Object[0]), e);
                }
                finally {
                    this.callResetListenerOnDatabaseReset = true;
                    if (db != null && db.isOpen()) {
                        this.close();
                    }
                }
            }
        }
    }

    boolean dbFileExists() {
        return this.file.exists();
    }

    Cursor queryDb(SQLiteDatabase db, String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        return db.query(table, columns, selection, selectionArgs, groupBy, having, orderBy, limit);
    }

    private void handleIfCursorRowTooLargeException(IllegalStateException e) {
        String message = e.getMessage();
        if (Utils.isEmptyString(message) || !message.contains("Couldn't read") || !message.contains("CursorWindow")) {
            throw e;
        }
        this.delete();
    }

    private static void convertIfCursorWindowException(RuntimeException e) {
        String message = e.getMessage();
        if (!Utils.isEmptyString(message) && message.startsWith("Cursor window allocation of")) {
            throw new CursorWindowAllocationException(message);
        }
        throw e;
    }
}

