/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.graphics;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.graphics.fonts.FontVariationAxis;
import android.net.Uri;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.RestrictTo;
import android.support.v4.content.res.FontResourcesParserCompat;
import android.support.v4.graphics.TypefaceCompatApi21Impl;
import android.support.v4.provider.FontsContractCompat;
import android.util.Log;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(value=26)
public class TypefaceCompatApi26Impl
extends TypefaceCompatApi21Impl {
    private static final String TAG = "TypefaceCompatApi26Impl";
    private static final String FONT_FAMILY_CLASS = "android.graphics.FontFamily";
    private static final String ADD_FONT_FROM_ASSET_MANAGER_METHOD = "addFontFromAssetManager";
    private static final String ADD_FONT_FROM_BUFFER_METHOD = "addFontFromBuffer";
    private static final String CREATE_FROM_FAMILIES_WITH_DEFAULT_METHOD = "createFromFamiliesWithDefault";
    private static final String FREEZE_METHOD = "freeze";
    private static final String ABORT_CREATION_METHOD = "abortCreation";
    private static final Class sFontFamily;
    private static final Constructor sFontFamilyCtor;
    private static final Method sAddFontFromAssetManager;
    private static final Method sAddFontFromBuffer;
    private static final Method sFreeze;
    private static final Method sAbortCreation;
    private static final Method sCreateFromFamiliesWithDefault;
    private static final int RESOLVE_BY_FONT_TABLE = -1;

    private static boolean isFontFamilyPrivateAPIAvailable() {
        if (sAddFontFromAssetManager == null) {
            Log.w((String)TAG, (String)"Unable to collect necessary private methods. Fallback to legacy implementation.");
        }
        return sAddFontFromAssetManager != null;
    }

    private static Object newFamily() {
        try {
            return sFontFamilyCtor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean addFontFromAssetManager(Context context, Object family, String fileName, int ttcIndex, int weight, int style) {
        try {
            Boolean result = (Boolean)sAddFontFromAssetManager.invoke(family, context.getAssets(), fileName, 0, false, ttcIndex, weight, style, null);
            return result;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean addFontFromBuffer(Object family, ByteBuffer buffer, int ttcIndex, int weight, int style) {
        try {
            Boolean result = (Boolean)sAddFontFromBuffer.invoke(family, buffer, ttcIndex, null, weight, style);
            return result;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static Typeface createFromFamiliesWithDefault(Object family) {
        try {
            Object familyArray = Array.newInstance(sFontFamily, 1);
            Array.set(familyArray, 0, family);
            return (Typeface)sCreateFromFamiliesWithDefault.invoke(null, familyArray, -1, -1);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean freeze(Object family) {
        try {
            Boolean result = (Boolean)sFreeze.invoke(family, new Object[0]);
            return result;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static void abortCreation(Object family) {
        try {
            sAbortCreation.invoke(family, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Typeface createFromFontFamilyFilesResourceEntry(Context context, FontResourcesParserCompat.FontFamilyFilesResourceEntry entry, Resources resources, int style) {
        if (!TypefaceCompatApi26Impl.isFontFamilyPrivateAPIAvailable()) {
            return super.createFromFontFamilyFilesResourceEntry(context, entry, resources, style);
        }
        Object fontFamily = TypefaceCompatApi26Impl.newFamily();
        for (FontResourcesParserCompat.FontFileResourceEntry fontFile : entry.getEntries()) {
            if (TypefaceCompatApi26Impl.addFontFromAssetManager(context, fontFamily, fontFile.getFileName(), 0, fontFile.getWeight(), fontFile.isItalic() ? 1 : 0)) continue;
            TypefaceCompatApi26Impl.abortCreation(fontFamily);
            return null;
        }
        if (!TypefaceCompatApi26Impl.freeze(fontFamily)) {
            return null;
        }
        return TypefaceCompatApi26Impl.createFromFamiliesWithDefault(fontFamily);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Typeface createFromFontInfo(Context context, @Nullable CancellationSignal cancellationSignal, @NonNull FontsContractCompat.FontInfo[] fonts, int style) {
        if (fonts.length < 1) {
            return null;
        }
        if (!TypefaceCompatApi26Impl.isFontFamilyPrivateAPIAvailable()) {
            FontsContractCompat.FontInfo bestFont = this.findBestInfo(fonts, style);
            ContentResolver resolver = context.getContentResolver();
            try (ParcelFileDescriptor pfd = resolver.openFileDescriptor(bestFont.getUri(), "r", cancellationSignal);){
                if (pfd == null) {
                    Typeface typeface2 = null;
                    return typeface2;
                }
                Typeface typeface = new Typeface.Builder(pfd.getFileDescriptor()).setWeight(bestFont.getWeight()).setItalic(bestFont.isItalic()).build();
                return typeface;
            }
            catch (IOException e) {
                return null;
            }
        }
        Map<Uri, ByteBuffer> uriBuffer = FontsContractCompat.prepareFontData(context, fonts, cancellationSignal);
        Object fontFamily = TypefaceCompatApi26Impl.newFamily();
        boolean atLeastOneFont = false;
        for (FontsContractCompat.FontInfo font : fonts) {
            ByteBuffer fontBuffer = uriBuffer.get(font.getUri());
            if (fontBuffer == null) continue;
            boolean success = TypefaceCompatApi26Impl.addFontFromBuffer(fontFamily, fontBuffer, font.getTtcIndex(), font.getWeight(), font.isItalic() ? 1 : 0);
            if (!success) {
                TypefaceCompatApi26Impl.abortCreation(fontFamily);
                return null;
            }
            atLeastOneFont = true;
        }
        if (!atLeastOneFont) {
            TypefaceCompatApi26Impl.abortCreation(fontFamily);
            return null;
        }
        if (!TypefaceCompatApi26Impl.freeze(fontFamily)) {
            return null;
        }
        Typeface typeface = TypefaceCompatApi26Impl.createFromFamiliesWithDefault(fontFamily);
        return Typeface.create((Typeface)typeface, (int)style);
    }

    @Override
    @Nullable
    public Typeface createFromResourcesFontFile(Context context, Resources resources, int id2, String path, int style) {
        if (!TypefaceCompatApi26Impl.isFontFamilyPrivateAPIAvailable()) {
            return super.createFromResourcesFontFile(context, resources, id2, path, style);
        }
        Object fontFamily = TypefaceCompatApi26Impl.newFamily();
        if (!TypefaceCompatApi26Impl.addFontFromAssetManager(context, fontFamily, path, 0, -1, -1)) {
            TypefaceCompatApi26Impl.abortCreation(fontFamily);
            return null;
        }
        if (!TypefaceCompatApi26Impl.freeze(fontFamily)) {
            return null;
        }
        return TypefaceCompatApi26Impl.createFromFamiliesWithDefault(fontFamily);
    }

    static {
        Method createFromFamiliesWithDefaultMethod;
        Method abortCreationMethod;
        Method freezeMethod;
        Method addFromBufferMethod;
        Method addFontMethod;
        Constructor<?> fontFamilyCtor;
        Class<?> fontFamilyClass;
        try {
            fontFamilyClass = Class.forName(FONT_FAMILY_CLASS);
            fontFamilyCtor = fontFamilyClass.getConstructor(new Class[0]);
            addFontMethod = fontFamilyClass.getMethod(ADD_FONT_FROM_ASSET_MANAGER_METHOD, AssetManager.class, String.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, FontVariationAxis[].class);
            addFromBufferMethod = fontFamilyClass.getMethod(ADD_FONT_FROM_BUFFER_METHOD, ByteBuffer.class, Integer.TYPE, FontVariationAxis[].class, Integer.TYPE, Integer.TYPE);
            freezeMethod = fontFamilyClass.getMethod(FREEZE_METHOD, new Class[0]);
            abortCreationMethod = fontFamilyClass.getMethod(ABORT_CREATION_METHOD, new Class[0]);
            Object familyArray = Array.newInstance(fontFamilyClass, 1);
            createFromFamiliesWithDefaultMethod = Typeface.class.getDeclaredMethod(CREATE_FROM_FAMILIES_WITH_DEFAULT_METHOD, familyArray.getClass(), Integer.TYPE, Integer.TYPE);
            createFromFamiliesWithDefaultMethod.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            Log.e((String)TAG, (String)("Unable to collect necessary methods for class " + e.getClass().getName()), (Throwable)e);
            fontFamilyClass = null;
            fontFamilyCtor = null;
            addFontMethod = null;
            addFromBufferMethod = null;
            freezeMethod = null;
            abortCreationMethod = null;
            createFromFamiliesWithDefaultMethod = null;
        }
        sFontFamilyCtor = fontFamilyCtor;
        sFontFamily = fontFamilyClass;
        sAddFontFromAssetManager = addFontMethod;
        sAddFontFromBuffer = addFromBufferMethod;
        sFreeze = freezeMethod;
        sAbortCreation = abortCreationMethod;
        sCreateFromFamiliesWithDefault = createFromFamiliesWithDefaultMethod;
    }
}

