/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig;

import com.android.apksig.JcaSignerEngine;
import com.android.apksig.KeyConfig;
import com.android.apksig.SignerEngine;
import com.android.apksig.kms.KmsException;
import com.android.apksig.kms.KmsSignerEngineProvider;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Objects;
import java.util.ServiceLoader;

public class SignerEngineFactory {
    private SignerEngineFactory() {
    }

    public static SignerEngine getImplementation(KeyConfig keyConfig, String jcaSignatureAlgorithm, AlgorithmParameterSpec algorithmParameterSpec) {
        return keyConfig.match(jca -> new JcaSignerEngine(jca.privateKey, jcaSignatureAlgorithm, algorithmParameterSpec), kms -> SignerEngineFactory.getKmsImplementation(kms, jcaSignatureAlgorithm, algorithmParameterSpec));
    }

    private static SignerEngine getKmsImplementation(KeyConfig.Kms keyConfig, String jcaSignatureAlgorithm, AlgorithmParameterSpec algorithmParameterSpec) {
        ServiceLoader<KmsSignerEngineProvider> providers = ServiceLoader.load(KmsSignerEngineProvider.class);
        for (KmsSignerEngineProvider provider : providers) {
            if (!Objects.equals(provider.getKmsType(), keyConfig.kmsType)) continue;
            return provider.getInstance(keyConfig, jcaSignatureAlgorithm, algorithmParameterSpec);
        }
        throw new KmsException(keyConfig.kmsType, "No SignerEngine implementation found on the classpath");
    }
}

