/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.utils.AbiUtils;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.collect.ImmutableSet;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.regex.Pattern;

public class BundleFilesValidator
extends SubValidator {
    private static final Pattern CLASSES_DEX_PATTERN = Pattern.compile("classes[0-9]*\\.dex");
    private static final ImmutableSet<Path> RESERVED_ROOT_APK_ENTRIES = ImmutableSet.of((Object)BundleModule.ASSETS_DIRECTORY, (Object)BundleModule.LIB_DIRECTORY, (Object)BundleModule.RESOURCES_DIRECTORY, (Object)Paths.get("AndroidManifest.xml", new String[0]), (Object)Paths.get("resources.arsc", new String[0]), (Object)Paths.get("AndroidManifest.xml", new String[0]), (Object[])new Path[]{BundleModule.RESOURCES_PROTO_PATH});

    @Override
    public void validateModuleFile(Path file) {
        String fileName = file.getFileName().toString();
        if (!file.startsWith(BundleModule.ASSETS_DIRECTORY)) {
            if (file.startsWith(BundleModule.DEX_DIRECTORY)) {
                if (!fileName.endsWith(".dex")) {
                    throw new ValidationException("Files under %s/ must have .dex extension, found '%s'.", BundleModule.DEX_DIRECTORY, file);
                }
            } else if (file.startsWith(BundleModule.LIB_DIRECTORY)) {
                if (file.getNameCount() != 3) {
                    throw new ValidationException("Native library files need to have paths in form '%s/<single-directory>/<file>.so' but found '%s'.", BundleModule.LIB_DIRECTORY, file);
                }
                if (!fileName.endsWith(".so")) {
                    throw new ValidationException("Files under %s/ must have .so extension, found '%s'.", BundleModule.LIB_DIRECTORY, file);
                }
                String subDirName = file.getName(1).toString();
                if (!BundleFilesValidator.startsWithOneOf(subDirName, AbiUtils.ABI_NAMES)) {
                    throw new ValidationException("Unrecognized native architecture for directory '%s'.", file.subpath(0, 2));
                }
            } else if (file.startsWith(BundleModule.MANIFEST_DIRECTORY)) {
                if (!fileName.equals("AndroidManifest.xml")) {
                    throw new ValidationException("Only '%s' is accepted under directory '%s' but found file '%s'.", "AndroidManifest.xml", BundleModule.MANIFEST_DIRECTORY, file);
                }
            } else if (file.startsWith(BundleModule.RESOURCES_DIRECTORY)) {
                if (file.getNameCount() == 2) {
                    throw new ValidationException("The %s/ directory cannot contain files directly, found '%s'.", BundleModule.RESOURCES_DIRECTORY, file);
                }
            } else if (file.startsWith(BundleModule.ROOT_DIRECTORY)) {
                Path nameUnderRoot = file.getName(1);
                if (BundleFilesValidator.isReservedRootApkEntry(nameUnderRoot)) {
                    throw new ValidationException("File '%s' uses reserved file or directory name '%s'.", file, nameUnderRoot);
                }
            } else {
                throw new ValidationException("Module files can be only in pre-defined directories, but found '%s'.", file);
            }
        }
    }

    private static boolean startsWithOneOf(String dir, Collection<String> prefixOptions) {
        return prefixOptions.stream().anyMatch(dir::startsWith);
    }

    private static boolean isReservedRootApkEntry(Path name) {
        return RESERVED_ROOT_APK_ENTRIES.contains((Object)name) || CLASSES_DEX_PATTERN.matcher(name.toString()).matches();
    }
}

