/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.cf.code;

import java.util.ArrayList;
import java.util.List;
import shadow.bundletool.com.android.tools.r8.cf.CfPrinter;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInstruction;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexCallSite;
import shadow.bundletool.com.android.tools.r8.graph.DexMethodHandle;
import shadow.bundletool.com.android.tools.r8.graph.DexProto;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexValue;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.graph.UseRegistry;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueType;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfSourceCode;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfState;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.Handle;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.Type;

public class CfInvokeDynamic
extends CfInstruction {
    private final DexCallSite callSite;

    public CfInvokeDynamic(DexCallSite callSite) {
        this.callSite = callSite;
    }

    @Override
    public void write(MethodVisitor visitor, NamingLens lens) {
        DexMethodHandle bootstrapMethod = this.callSite.bootstrapMethod;
        List<DexValue> bootstrapArgs = this.callSite.bootstrapArgs;
        Object[] bsmArgs = new Object[bootstrapArgs.size()];
        for (int i = 0; i < bootstrapArgs.size(); ++i) {
            bsmArgs[i] = this.decodeBootstrapArgument(bootstrapArgs.get(i), lens);
        }
        Handle bsmHandle = bootstrapMethod.toAsmHandle(lens);
        DexString methodName = lens.lookupMethodName(this.callSite);
        visitor.visitInvokeDynamicInsn(methodName.toString(), this.callSite.methodProto.toDescriptorString(lens), bsmHandle, bsmArgs);
    }

    private Object decodeBootstrapArgument(DexValue dexValue, NamingLens lens) {
        if (dexValue instanceof DexValue.DexValueInt) {
            return ((DexValue.DexValueInt)dexValue).getValue();
        }
        if (dexValue instanceof DexValue.DexValueLong) {
            return ((DexValue.DexValueLong)dexValue).getValue();
        }
        if (dexValue instanceof DexValue.DexValueFloat) {
            return Float.valueOf(((DexValue.DexValueFloat)dexValue).getValue());
        }
        if (dexValue instanceof DexValue.DexValueDouble) {
            return ((DexValue.DexValueDouble)dexValue).getValue();
        }
        if (dexValue instanceof DexValue.DexValueString) {
            return ((DexValue.DexValueString)dexValue).getValue();
        }
        if (dexValue instanceof DexValue.DexValueType) {
            return Type.getType(lens.lookupDescriptor((DexType)((DexValue.DexValueType)dexValue).value).toString());
        }
        if (dexValue instanceof DexValue.DexValueMethodType) {
            return Type.getMethodType(((DexProto)((DexValue.DexValueMethodType)dexValue).value).toDescriptorString(lens));
        }
        if (dexValue instanceof DexValue.DexValueMethodHandle) {
            return ((DexMethodHandle)((DexValue.DexValueMethodHandle)dexValue).value).toAsmHandle(lens);
        }
        throw new Unreachable("Unsupported bootstrap argument of type " + dexValue.getClass().getSimpleName());
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    public DexCallSite getCallSite() {
        return this.callSite;
    }

    @Override
    public void registerUse(UseRegistry registry, DexType clazz) {
        registry.registerCallSite(this.callSite);
    }

    @Override
    public boolean canThrow() {
        return true;
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        DexType[] parameterTypes = this.callSite.methodProto.parameters.values;
        ArrayList<Integer> registers = new ArrayList<Integer>(parameterTypes.length);
        for (int register : state.popReverse(parameterTypes.length)) {
            registers.add(register);
        }
        ArrayList<ValueType> types = new ArrayList<ValueType>(parameterTypes.length);
        for (DexType value : parameterTypes) {
            types.add(ValueType.fromDexType(value));
        }
        builder.addInvokeCustom(this.callSite, types, registers);
        if (!this.callSite.methodProto.returnType.isVoidType()) {
            builder.addMoveResult(state.push((DexType)this.callSite.methodProto.returnType).register);
        }
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext, GraphLense graphLense, AppView<?> appView) {
        return inliningConstraints.forInvokeCustom();
    }
}

