/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.Descriptor;
import shadow.bundletool.com.android.tools.r8.graph.DexDefinition;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItem;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.IndexedDexItem;

public abstract class DexReference
extends IndexedDexItem {
    @Override
    public boolean isDexReference() {
        return true;
    }

    @Override
    public DexReference asDexReference() {
        return this;
    }

    public boolean isDexType() {
        return false;
    }

    public DexType asDexType() {
        return null;
    }

    public boolean isDescriptor() {
        return false;
    }

    public Descriptor asDescriptor() {
        return null;
    }

    public boolean isDexField() {
        return false;
    }

    public DexField asDexField() {
        return null;
    }

    public boolean isDexMethod() {
        return false;
    }

    public DexMethod asDexMethod() {
        return null;
    }

    public static Stream<DexReference> filterDexReference(Stream<DexItem> stream) {
        return DexItem.filter(stream, DexReference.class);
    }

    public DexDefinition toDefinition(AppInfo appInfo) {
        if (this.isDexType()) {
            return appInfo.definitionFor(this.asDexType());
        }
        if (this.isDexField()) {
            return appInfo.definitionFor(this.asDexField());
        }
        assert (this.isDexMethod());
        return appInfo.definitionFor(this.asDexMethod());
    }

    public static Stream<DexDefinition> mapToDefinition(Stream<DexReference> references, AppInfo appInfo) {
        return references.map(r -> r.toDefinition(appInfo)).filter(Objects::nonNull);
    }

    private static <T extends DexReference> Stream<T> filter(Stream<DexReference> stream, Predicate<DexReference> pred, Function<DexReference, T> f) {
        return stream.filter(pred).map(f);
    }

    public static Stream<DexType> filterDexType(Stream<DexReference> stream) {
        return DexReference.filter(stream, DexReference::isDexType, DexReference::asDexType);
    }

    public static Stream<DexField> filterDexField(Stream<DexReference> stream) {
        return DexReference.filter(stream, DexReference::isDexField, DexReference::asDexField);
    }

    public static Stream<DexMethod> filterDexMethod(Stream<DexReference> stream) {
        return DexReference.filter(stream, DexReference::isDexMethod, DexReference::asDexMethod);
    }
}

