/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph.classmerging;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Maps;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.classmerging.MergedClasses;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;

public class VerticallyMergedClasses
implements MergedClasses {
    private final Map<DexType, DexType> mergedClasses;
    private final Map<DexType, List<DexType>> sources;

    public VerticallyMergedClasses(Map<DexType, DexType> mergedClasses) {
        IdentityHashMap<DexType, List<DexType>> sources = Maps.newIdentityHashMap();
        mergedClasses.forEach((source, target) -> sources.computeIfAbsent((DexType)target, key -> new ArrayList()).add(source));
        this.mergedClasses = mergedClasses;
        this.sources = sources;
    }

    public List<DexType> getSourcesFor(DexType type) {
        return this.sources.getOrDefault(type, ImmutableList.of());
    }

    public DexType getTargetFor(DexType type) {
        assert (this.mergedClasses.containsKey(type));
        return this.mergedClasses.get(type);
    }

    public boolean hasBeenMergedIntoSubtype(DexType type) {
        return this.mergedClasses.containsKey(type);
    }

    @Override
    public boolean verifyAllSourcesPruned(AppView<AppInfoWithLiveness> appView) {
        for (List<DexType> sourcesForTarget : this.sources.values()) {
            for (DexType source : sourcesForTarget) {
                assert (appView.appInfo().wasPruned(source)) : "Expected vertically merged class `" + source.toSourceString() + "` to be absent";
            }
        }
        return true;
    }
}

