/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.analysis.escape;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSet;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.ir.analysis.escape.DefaultEscapeAnalysisConfiguration;
import shadow.bundletool.com.android.tools.r8.ir.analysis.escape.EscapeAnalysisConfiguration;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.utils.Box;

public class EscapeAnalysis {
    private final AppView<?> appView;
    private final EscapeAnalysisConfiguration configuration;
    private final Set<Value> trackedValues = Sets.newIdentityHashSet();
    private final Deque<Value> valuesToTrack = new ArrayDeque<Value>();

    public EscapeAnalysis(AppView<?> appView) {
        this(appView, DefaultEscapeAnalysisConfiguration.getInstance());
    }

    public EscapeAnalysis(AppView<?> appView, EscapeAnalysisConfiguration configuration) {
        this.appView = appView;
        this.configuration = configuration;
    }

    public boolean isEscaping(IRCode code, Value valueOfInterest) {
        Box firstEscapeRoute = new Box();
        this.run(code, valueOfInterest, escapeRoute -> {
            firstEscapeRoute.set(escapeRoute);
            return true;
        });
        return firstEscapeRoute.isSet();
    }

    public Set<Instruction> computeEscapeRoutes(IRCode code, Value valueOfInterest) {
        ImmutableSet.Builder escapeRoutes = ImmutableSet.builder();
        this.run(code, valueOfInterest, escapeRoute -> {
            escapeRoutes.add(escapeRoute);
            return false;
        });
        return escapeRoutes.build();
    }

    private void run(IRCode code, Value valueOfInterest, Predicate<Instruction> stoppingCriterion) {
        BasicBlock block;
        assert (valueOfInterest.getTypeLattice().isReference());
        assert (this.trackedValues.isEmpty());
        assert (this.valuesToTrack.isEmpty());
        BasicBlock basicBlock = block = valueOfInterest.isPhi() ? valueOfInterest.asPhi().getBlock() : valueOfInterest.definition.getBlock();
        assert (code.blocks.contains(block));
        List<Value> arguments = code.collectArguments();
        this.addToWorklist(valueOfInterest);
        while (!this.valuesToTrack.isEmpty()) {
            Value alias = this.valuesToTrack.poll();
            assert (alias != null);
            assert (this.trackedValues.contains(alias));
            boolean stopped = this.processValue(valueOfInterest, alias, block, code, arguments, stoppingCriterion);
            if (!stopped) continue;
            break;
        }
        this.trackedValues.clear();
        this.valuesToTrack.clear();
    }

    private boolean processValue(Value root, Value alias, BasicBlock block, IRCode code, List<Value> arguments, Predicate<Instruction> stoppingCriterion) {
        for (Value value : alias.uniquePhiUsers()) {
            this.addToWorklist(value);
        }
        for (Instruction instruction : alias.uniqueUsers()) {
            Value propagatedValue;
            LinkedList<Instruction> instructions;
            if (instruction.getBlock() == block && !root.isPhi() && (instructions = block.getInstructions()).indexOf(instruction) < instructions.indexOf(root.definition)) continue;
            if (!this.configuration.isLegitimateEscapeRoute(this.appView, this, instruction, code.method.method) && this.isDirectlyEscaping(instruction, code.method.method, arguments) && stoppingCriterion.test(instruction)) {
                return true;
            }
            boolean couldIntroduceTrackedValueAlias = false;
            for (Value trackedValue : this.trackedValues) {
                if (!instruction.couldIntroduceAnAlias(this.appView, trackedValue)) continue;
                couldIntroduceTrackedValueAlias = true;
                break;
            }
            if (couldIntroduceTrackedValueAlias) {
                Value outValue = instruction.outValue();
                assert (outValue != null && outValue.getTypeLattice().isReference());
                this.addToWorklist(outValue);
            }
            if ((propagatedValue = EscapeAnalysis.getPropagatedSubject(alias, instruction)) == null || propagatedValue == alias) continue;
            assert (propagatedValue.getTypeLattice().isReference());
            this.addToWorklist(propagatedValue);
        }
        return false;
    }

    private void addToWorklist(Value value) {
        assert (value != null);
        if (this.trackedValues.add(value)) {
            this.valuesToTrack.push(value);
        }
    }

    private boolean isDirectlyEscaping(Instruction instr, DexMethod context, List<Value> arguments) {
        if (instr.isReturn()) {
            return true;
        }
        if (instr.isThrow()) {
            return true;
        }
        if (instr.isStaticPut()) {
            return true;
        }
        if (instr.isInvokeMethod()) {
            DexMethod invokedMethod = instr.asInvokeMethod().getInvokedMethod();
            if (invokedMethod == context) {
                return !instr.inValues().equals(arguments);
            }
            return true;
        }
        if (instr.isArrayPut()) {
            Value array = instr.asArrayPut().array().getAliasedValue();
            return array.isPhi() || !array.definition.isCreatingArray();
        }
        if (instr.isInstancePut()) {
            Value instance = instr.asInstancePut().object().getAliasedValue();
            return instance.isPhi() || !instance.definition.isNewInstance();
        }
        return false;
    }

    public boolean isValueOfInterestOrAlias(Value value) {
        return this.trackedValues.contains(value);
    }

    private static Value getPropagatedSubject(Value src, Instruction instr) {
        if (instr.isArrayPut()) {
            return instr.asArrayPut().array();
        }
        if (instr.isInstancePut()) {
            return instr.asInstancePut().object();
        }
        return null;
    }
}

