/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.analysis.proto;

import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.OptionalInt;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexReference;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.ProtoReferences;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.ProtoUtils;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.DeadProtoFieldObject;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.LiveProtoFieldObject;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.ProtoFieldInfo;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.ProtoFieldType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.ProtoFieldTypeFactory;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.ProtoMessageInfo;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.ProtoObject;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.ProtoObjectFromInvokeStatic;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.ProtoObjectFromStaticGet;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.ProtoTypeObject;
import shadow.bundletool.com.android.tools.r8.ir.code.ArrayPut;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstClass;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstString;
import shadow.bundletool.com.android.tools.r8.ir.code.DexItemBasedConstString;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeStatic;
import shadow.bundletool.com.android.tools.r8.ir.code.NewArrayEmpty;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticGet;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.naming.dexitembasedstring.NameComputationInfo;
import shadow.bundletool.com.android.tools.r8.utils.ThrowingCharIterator;
import shadow.bundletool.com.android.tools.r8.utils.ThrowingIntIterator;
import shadow.bundletool.com.android.tools.r8.utils.ThrowingIterator;

public class RawMessageInfoDecoder {
    private final ProtoFieldTypeFactory factory;
    private final ProtoReferences references;

    RawMessageInfoDecoder(ProtoFieldTypeFactory factory, ProtoReferences references) {
        this.factory = factory;
        this.references = references;
    }

    public ProtoMessageInfo run(DexEncodedMethod dynamicMethod, DexClass context, InvokeMethod invoke) {
        assert (this.references.isMessageInfoConstructionMethod(invoke.getInvokedMethod()));
        Value infoValue = ProtoUtils.getInfoValueFromMessageInfoConstructionInvoke(invoke, this.references);
        Value objectsValue = ProtoUtils.getObjectsValueFromMessageInfoConstructionInvoke(invoke, this.references);
        return this.run(dynamicMethod, context, infoValue, objectsValue);
    }

    public ProtoMessageInfo run(DexEncodedMethod dynamicMethod, DexClass context, Value infoValue, Value objectsValue) {
        try {
            int i;
            ProtoMessageInfo.Builder builder = ProtoMessageInfo.builder(dynamicMethod);
            ThrowingIntIterator<InvalidRawMessageInfoException> infoIterator = RawMessageInfoDecoder.createInfoIterator(infoValue);
            int flags = infoIterator.nextIntComputeIfAbsent(this::invalidInfoFailure);
            builder.setFlags(flags);
            int fieldCount = infoIterator.nextIntComputeIfAbsent(this::invalidInfoFailure);
            if (fieldCount == 0) {
                return builder.build();
            }
            int numberOfOneOfObjects = infoIterator.nextIntComputeIfAbsent(this::invalidInfoFailure);
            int numberOfHasBitsObjects = infoIterator.nextIntComputeIfAbsent(this::invalidInfoFailure);
            for (int i2 = 4; i2 < 10; ++i2) {
                infoIterator.nextIntComputeIfAbsent(this::invalidInfoFailure);
            }
            ThrowingIterator<Value, InvalidRawMessageInfoException> objectIterator = RawMessageInfoDecoder.createObjectIterator(objectsValue);
            for (i = 0; i < numberOfOneOfObjects; ++i) {
                ProtoObject oneOfObject = this.createProtoObject(objectIterator.computeNextIfAbsent(this::invalidObjectsFailure), context);
                if (!oneOfObject.isProtoFieldObject()) {
                    throw new InvalidRawMessageInfoException();
                }
                ProtoObject oneOfCaseObject = this.createProtoObject(objectIterator.computeNextIfAbsent(this::invalidObjectsFailure), context);
                if (!oneOfCaseObject.isProtoFieldObject()) {
                    throw new InvalidRawMessageInfoException();
                }
                builder.addOneOfObject(oneOfObject.asProtoFieldObject(), oneOfCaseObject.asProtoFieldObject());
            }
            for (i = 0; i < numberOfHasBitsObjects; ++i) {
                ProtoObject hasBitsObject = this.createProtoObject(objectIterator.computeNextIfAbsent(this::invalidObjectsFailure), context);
                if (!hasBitsObject.isProtoFieldObject()) {
                    throw new InvalidRawMessageInfoException();
                }
                builder.addHasBitsObject(hasBitsObject.asProtoFieldObject());
            }
            boolean isProto2 = ProtoUtils.isProto2(flags);
            for (int i3 = 0; i3 < fieldCount; ++i3) {
                int fieldNumber = infoIterator.nextIntComputeIfAbsent(this::invalidInfoFailure);
                int fieldTypeWithExtraBits = infoIterator.nextIntComputeIfAbsent(this::invalidInfoFailure);
                ProtoFieldType fieldType = this.factory.createField(fieldTypeWithExtraBits);
                OptionalInt auxData = fieldType.hasAuxData(isProto2) ? OptionalInt.of(infoIterator.nextIntComputeIfAbsent(this::invalidInfoFailure)) : OptionalInt.empty();
                int numberOfObjects = fieldType.numberOfObjects(isProto2, this.factory);
                try {
                    ArrayList<ProtoObject> objects = new ArrayList<ProtoObject>(numberOfObjects);
                    for (Value value : objectIterator.take(numberOfObjects)) {
                        objects.add(this.createProtoObject(value, context));
                    }
                    builder.addField(new ProtoFieldInfo(fieldNumber, fieldType, auxData, objects));
                    continue;
                }
                catch (NoSuchElementException e) {
                    throw new InvalidRawMessageInfoException();
                }
            }
            if (infoIterator.hasNext() || objectIterator.hasNext()) {
                throw new InvalidRawMessageInfoException();
            }
            return builder.build();
        }
        catch (InvalidRawMessageInfoException e) {
            assert (false);
            return null;
        }
    }

    private ProtoObject createProtoObject(Value value, DexClass context) throws InvalidRawMessageInfoException {
        Value root = value.getAliasedValue();
        if (!root.isPhi()) {
            Instruction definition = root.definition;
            if (definition.isConstClass()) {
                ConstClass constClass = definition.asConstClass();
                return new ProtoTypeObject(constClass.getValue());
            }
            if (definition.isConstString()) {
                ConstString constString = definition.asConstString();
                DexField field = context.lookupUniqueInstanceFieldWithName(constString.getValue());
                if (field != null) {
                    return new LiveProtoFieldObject(field);
                }
                return new DeadProtoFieldObject(context.type, constString.getValue());
            }
            if (definition.isDexItemBasedConstString()) {
                DexItemBasedConstString constString = definition.asDexItemBasedConstString();
                DexReference reference = constString.getItem();
                NameComputationInfo<?> nameComputationInfo = constString.getNameComputationInfo();
                if (reference.isDexField() && nameComputationInfo.isFieldNameComputationInfo() && nameComputationInfo.asFieldNameComputationInfo().isForFieldName()) {
                    DexField field = reference.asDexField();
                    DexEncodedField encodedField = context.lookupInstanceField(field);
                    if (encodedField != null) {
                        return new LiveProtoFieldObject(field);
                    }
                    return new DeadProtoFieldObject(context.type, field.name);
                }
            } else if (definition.isInvokeStatic()) {
                InvokeStatic invoke = definition.asInvokeStatic();
                if (invoke.arguments().isEmpty()) {
                    return new ProtoObjectFromInvokeStatic(invoke.getInvokedMethod());
                }
            } else if (definition.isStaticGet()) {
                StaticGet staticGet = definition.asStaticGet();
                return new ProtoObjectFromStaticGet(staticGet.getField());
            }
        }
        throw new InvalidRawMessageInfoException();
    }

    private int invalidInfoFailure() throws InvalidRawMessageInfoException {
        throw new InvalidRawMessageInfoException();
    }

    private Value invalidObjectsFailure() throws InvalidRawMessageInfoException {
        throw new InvalidRawMessageInfoException();
    }

    public static ThrowingIntIterator<InvalidRawMessageInfoException> createInfoIterator(Value infoValue) throws InvalidRawMessageInfoException {
        if (!infoValue.isPhi() && infoValue.definition.isConstString()) {
            return RawMessageInfoDecoder.createInfoIterator(infoValue.definition.asConstString().getValue());
        }
        throw new InvalidRawMessageInfoException();
    }

    private static ThrowingIntIterator<InvalidRawMessageInfoException> createInfoIterator(final DexString info) {
        return new ThrowingIntIterator<InvalidRawMessageInfoException>(){
            private final ThrowingCharIterator<UTFDataFormatException> charIterator;
            {
                this.charIterator = info.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.charIterator.hasNext();
            }

            @Override
            public int nextInt() throws InvalidRawMessageInfoException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int value = 0;
                int shift = 0;
                do {
                    char c;
                    try {
                        c = this.charIterator.nextChar();
                    }
                    catch (UTFDataFormatException e) {
                        throw new InvalidRawMessageInfoException();
                    }
                    if (c >= '\ud800' && c < '\ue000') {
                        throw new InvalidRawMessageInfoException();
                    }
                    if (c < '\ud800') {
                        return value | c << shift;
                    }
                    value |= (c & 0x1FFF) << shift;
                    shift += 13;
                } while (this.hasNext());
                throw new InvalidRawMessageInfoException();
            }
        };
    }

    private static ThrowingIterator<Value, InvalidRawMessageInfoException> createObjectIterator(final Value objectsValue) throws InvalidRawMessageInfoException {
        if (objectsValue.isPhi() || !objectsValue.definition.isNewArrayEmpty()) {
            throw new InvalidRawMessageInfoException();
        }
        NewArrayEmpty newArrayEmpty = objectsValue.definition.asNewArrayEmpty();
        int expectedArraySize = objectsValue.uniqueUsers().size() - 1;
        Value sizeValue = newArrayEmpty.size().getAliasedValue();
        if (sizeValue.isPhi() || !sizeValue.definition.isConstNumber() || sizeValue.definition.asConstNumber().getIntValue() != expectedArraySize) {
            throw new InvalidRawMessageInfoException();
        }
        final InstructionIterator instructionIterator = newArrayEmpty.getBlock().iterator();
        instructionIterator.nextUntil(instruction -> instruction == newArrayEmpty);
        return new ThrowingIterator<Value, InvalidRawMessageInfoException>(){
            private int expectedNextIndex = 0;

            @Override
            public boolean hasNext() {
                while (instructionIterator.hasNext()) {
                    Instruction next = instructionIterator.peekNext();
                    if (this.isArrayPutOfInterest(next)) {
                        return true;
                    }
                    if (next.isJumpInstruction()) {
                        return false;
                    }
                    instructionIterator.next();
                }
                return false;
            }

            @Override
            public Value next() throws InvalidRawMessageInfoException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ArrayPut arrayPut = ((Instruction)instructionIterator.next()).asArrayPut();
                Value indexValue = arrayPut.index().getAliasedValue();
                if (indexValue.isPhi() || !indexValue.definition.isConstNumber() || indexValue.definition.asConstNumber().getIntValue() != this.expectedNextIndex) {
                    throw new InvalidRawMessageInfoException();
                }
                ++this.expectedNextIndex;
                return arrayPut.value().getAliasedValue();
            }

            private boolean isArrayPutOfInterest(Instruction instruction) {
                return instruction.isArrayPut() && instruction.asArrayPut().array().getAliasedValue() == objectsValue;
            }
        };
    }

    private static class InvalidRawMessageInfoException
    extends Exception {
        private InvalidRawMessageInfoException() {
        }
    }
}

