/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.analysis.proto;

import java.util.ArrayList;
import java.util.List;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.ProtoFieldInfo;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.ProtoFieldType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.ProtoMessageInfo;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.ProtoObject;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.ProtoOneOfObjectPair;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArrayList;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntList;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntListIterator;

public class RawMessageInfoEncoder {
    private final DexItemFactory dexItemFactory;

    RawMessageInfoEncoder(DexItemFactory dexItemFactory) {
        this.dexItemFactory = dexItemFactory;
    }

    DexString encodeInfo(ProtoMessageInfo protoMessageInfo) {
        IntArrayList info = new IntArrayList();
        info.add(protoMessageInfo.getFlags());
        info.add(protoMessageInfo.numberOfFields());
        if (protoMessageInfo.hasFields()) {
            int minFieldNumber = Integer.MAX_VALUE;
            int maxFieldNumber = Integer.MIN_VALUE;
            int mapFieldCount = 0;
            int repeatedFieldCount = 0;
            int checkInitialized = 0;
            for (ProtoFieldInfo protoFieldInfo : protoMessageInfo.getFields()) {
                ProtoFieldType fieldType;
                int fieldNumber = protoFieldInfo.getNumber();
                if (fieldNumber < minFieldNumber) {
                    minFieldNumber = fieldNumber;
                }
                if (fieldNumber > maxFieldNumber) {
                    maxFieldNumber = fieldNumber;
                }
                if ((fieldType = protoFieldInfo.getType()).id() == 50) {
                    ++mapFieldCount;
                } else if (!fieldType.isSingular()) {
                    ++repeatedFieldCount;
                }
                if (!fieldType.needsIsInitializedCheck()) continue;
                ++checkInitialized;
            }
            info.add(protoMessageInfo.numberOfOneOfObjects());
            info.add(protoMessageInfo.numberOfHasBitsObjects());
            info.add(minFieldNumber);
            info.add(maxFieldNumber);
            info.add(protoMessageInfo.numberOfFields());
            info.add(mapFieldCount);
            info.add(repeatedFieldCount);
            info.add(checkInitialized);
            for (ProtoFieldInfo protoFieldInfo : protoMessageInfo.getFields()) {
                info.add(protoFieldInfo.getNumber());
                info.add(protoFieldInfo.getType().serialize());
                if (!protoFieldInfo.hasAuxData()) continue;
                info.add(protoFieldInfo.getAuxData());
            }
        }
        return this.encodeInfo(info);
    }

    private DexString encodeInfo(IntList info) {
        byte[] result = new byte[RawMessageInfoEncoder.countBytes(info)];
        int numberOfExtraChars = 0;
        int offset = 0;
        IntListIterator iterator2 = info.iterator();
        while (iterator2.hasNext()) {
            int value;
            for (value = iterator2.nextInt(); value >= 55296; value >>= 13) {
                char c = (char)(0xE000 | value & 0x1FFF);
                offset = DexString.encodeToMutf8(c, result, offset);
                ++numberOfExtraChars;
            }
            offset = DexString.encodeToMutf8((char)value, result, offset);
        }
        result[offset] = 0;
        return this.dexItemFactory.createString(info.size() + numberOfExtraChars, result);
    }

    List<ProtoObject> encodeObjects(ProtoMessageInfo protoMessageInfo) {
        ArrayList<ProtoObject> result = new ArrayList<ProtoObject>();
        if (protoMessageInfo.numberOfOneOfObjects() > 0) {
            for (ProtoOneOfObjectPair oneOfObjectPair : protoMessageInfo.getOneOfObjects()) {
                oneOfObjectPair.forEach(result::add);
            }
        }
        if (protoMessageInfo.numberOfHasBitsObjects() > 0) {
            result.addAll(protoMessageInfo.getHasBitsObjects());
        }
        if (protoMessageInfo.hasFields()) {
            for (ProtoFieldInfo protoFieldInfo : protoMessageInfo.getFields()) {
                result.addAll(protoFieldInfo.getObjects());
            }
        }
        return result;
    }

    private static int countBytes(IntList info) {
        int result = 1;
        IntListIterator iterator2 = info.iterator();
        while (iterator2.hasNext()) {
            int value = iterator2.nextInt();
            while (value >= 55296) {
                char c = (char)(0xE000 | value & 0x1FFF);
                value >>= 13;
                result += DexString.countBytes(c);
            }
            result += DexString.countBytes((char)value);
        }
        return result;
    }
}

