/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.analysis.value;

import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DebugLocalInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.value.SingleValue;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstString;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.TypeAndLocalInfoSupplier;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;

public class SingleStringValue
extends SingleValue {
    private final DexString string;

    SingleStringValue(DexString string) {
        this.string = string;
    }

    @Override
    public boolean isSingleStringValue() {
        return true;
    }

    @Override
    public SingleStringValue asSingleStringValue() {
        return this;
    }

    public DexString getDexString() {
        return this.string;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return this.string.hashCode();
    }

    @Override
    public String toString() {
        return "SingleStringValue(" + this.string + ")";
    }

    @Override
    public Instruction createMaterializingInstruction(AppView<? extends AppInfoWithSubtyping> appView, IRCode code, TypeAndLocalInfoSupplier info) {
        TypeLatticeElement typeLattice = info.getTypeLattice();
        DebugLocalInfo debugLocalInfo = info.getLocalInfo();
        assert (typeLattice.isClassType());
        assert (appView.isSubtype(appView.dexItemFactory().stringType, typeLattice.asClassTypeLatticeElement().getClassType()).isTrue());
        Value returnedValue = code.createValue(TypeLatticeElement.stringClassType(appView, Nullability.definitelyNotNull()), debugLocalInfo);
        ConstString instruction = new ConstString(returnedValue, this.string, BasicBlock.ThrowingInfo.defaultForConstString(appView.options()));
        assert (!instruction.instructionInstanceCanThrow());
        return instruction;
    }

    @Override
    public boolean isMaterializableInContext(AppView<?> appView, DexType context) {
        return true;
    }
}

