/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.List;
import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.cf.TypeVerificationHelper;
import shadow.bundletool.com.android.tools.r8.cf.code.CfMultiANewArray;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.AbstractError;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionVisitor;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;
import shadow.bundletool.com.android.tools.r8.optimize.MemberRebindingAnalysis;
import shadow.bundletool.com.android.tools.r8.utils.LongInterval;

public class InvokeMultiNewArray
extends Invoke {
    private final DexType type;

    public InvokeMultiNewArray(DexType type, Value result, List<Value> arguments) {
        super(result, arguments);
        this.type = type;
    }

    @Override
    public int opcode() {
        return 34;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean isInvokeMultiNewArray() {
        return true;
    }

    @Override
    public InvokeMultiNewArray asInvokeMultiNewArray() {
        return this;
    }

    @Override
    public Invoke.Type getType() {
        return Invoke.Type.MULTI_NEW_ARRAY;
    }

    public DexType getArrayType() {
        return this.type;
    }

    @Override
    public DexType getReturnType() {
        return this.getArrayType();
    }

    @Override
    protected String getTypeString() {
        return "MultiNewArray";
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isInvokeMultiNewArray() && this.type == other.asInvokeMultiNewArray().type;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forInvokeMultiNewArray(this.type, invocationContext);
    }

    @Override
    public TypeLatticeElement evaluate(AppView<?> appView) {
        return TypeLatticeElement.fromDexType(this.type, Nullability.definitelyNotNull(), appView);
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        return this.type;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfMultiANewArray(this.type, this.arguments().size()));
    }

    @Override
    public void buildDex(DexBuilder builder) {
        throw new Unreachable("InvokeNewArray (non-empty) not supported when compiling to dex files.");
    }

    @Override
    public AbstractError instructionInstanceCanThrow(AppView<?> appView, DexType context) {
        DexType baseType;
        DexType dexType = baseType = this.type.isArrayType() ? this.type.toBaseType(appView.dexItemFactory()) : this.type;
        if (baseType.isPrimitiveType()) {
            assert (!this.type.isWideType()) : "The array's contents must be single-word";
            return this.instructionInstanceCanThrowNegativeArraySizeException();
        }
        assert (baseType.isReferenceType());
        if (baseType == context) {
            return this.instructionInstanceCanThrowNegativeArraySizeException();
        }
        if (!appView.enableWholeProgramOptimizations()) {
            return AbstractError.top();
        }
        DexClass clazz = appView.definitionFor(baseType);
        if (clazz == null) {
            return AbstractError.top();
        }
        if (clazz.isLibraryClass() && !appView.dexItemFactory().libraryTypesAssumedToBePresent.contains(baseType)) {
            return AbstractError.top();
        }
        if (!MemberRebindingAnalysis.isClassTypeVisibleFromContext(appView, context, clazz)) {
            return AbstractError.top();
        }
        return this.instructionInstanceCanThrowNegativeArraySizeException();
    }

    private AbstractError instructionInstanceCanThrowNegativeArraySizeException() {
        boolean mayHaveNegativeArraySize = false;
        for (Value value : this.arguments()) {
            if (!value.hasValueRange()) {
                mayHaveNegativeArraySize = true;
                break;
            }
            LongInterval valueRange = value.getValueRange();
            if (valueRange.getMin() >= 0L) continue;
            mayHaveNegativeArraySize = true;
            break;
        }
        return mayHaveNegativeArraySize ? AbstractError.top() : AbstractError.bottom();
    }

    @Override
    public boolean instructionMayHaveSideEffects(AppView<?> appView, DexType context) {
        if (this.hasOutValue() && this.outValue().hasLocalInfo()) {
            assert (appView.options().debug);
            return true;
        }
        return this.instructionInstanceCanThrow(appView, context).isThrowing();
    }

    @Override
    public boolean canBeDeadCode(AppView<?> appView, IRCode code) {
        return !this.instructionMayHaveSideEffects(appView, code.method.method.holder);
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, DexType context) {
        return false;
    }
}

