/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.cf.code.CfMonitor;
import shadow.bundletool.com.android.tools.r8.code.MonitorEnter;
import shadow.bundletool.com.android.tools.r8.code.MonitorExit;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionVisitor;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;

public class Monitor
extends Instruction {
    private final Type type;

    public Monitor(Type type, Value object) {
        super(null, object);
        this.type = type;
    }

    @Override
    public int opcode() {
        return 41;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public Value object() {
        return (Value)this.inValues.get(0);
    }

    public boolean isEnter() {
        return this.type == Type.ENTER;
    }

    public boolean isExit() {
        return this.type == Type.EXIT;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int object = builder.argumentOrAllocateRegister(this.object(), this.getNumber());
        if (object > this.maxInValueRegister()) {
            object = builder.allocatedRegister(this.object(), this.getNumber());
        }
        if (this.type == Type.ENTER) {
            builder.add((Instruction)this, (shadow.bundletool.com.android.tools.r8.code.Instruction)new MonitorEnter(object));
        } else {
            builder.add((Instruction)this, (shadow.bundletool.com.android.tools.r8.code.Instruction)new MonitorExit(object));
        }
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isMonitor() && other.asMonitor().type == this.type;
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        assert (false) : "Monitor defines no values.";
        return 0;
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean isMonitor() {
        return true;
    }

    @Override
    public boolean isMonitorEnter() {
        return this.isEnter();
    }

    @Override
    public Monitor asMonitor() {
        return this;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forMonitor();
    }

    @Override
    public String getInstructionName() {
        switch (this.type) {
            case ENTER: {
                return "MonitorEnter";
            }
            case EXIT: {
                return "MonitorExit";
            }
        }
        throw new Unreachable("Unknown monitor type:" + (Object)((Object)this.type));
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfMonitor(this.type));
    }

    @Override
    public boolean throwsNpeIfValueIsNull(Value value, DexItemFactory dexItemFactory) {
        return this.object() == value;
    }

    @Override
    public boolean throwsOnNullInput() {
        return true;
    }

    @Override
    public Value getNonNullInput() {
        return this.object();
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, DexType context) {
        return false;
    }

    public static enum Type {
        ENTER,
        EXIT;

    }
}

