/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.Objects;
import shadow.bundletool.com.android.tools.r8.com.google.common.annotations.VisibleForTesting;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;

public class Position {
    private static final Position NO_POSITION = new Position(-1, null, null, null, false);
    private static final Position NO_POSITION_SYNTHETIC = new Position(-1, null, null, null, true);
    private static final Position TESTING_POSITION = new Position(0, null, null, null, true);
    public final int line;
    public final DexString file;
    public final boolean synthetic;
    public final DexMethod method;
    public final Position callerPosition;

    public Position(int line, DexString file, DexMethod method, Position callerPosition) {
        this(line, file, method, callerPosition, false);
        assert (line >= 0);
        assert (method != null);
    }

    private Position(int line, DexString file, DexMethod method, Position callerPosition, boolean synthetic) {
        this.line = line;
        this.file = file;
        this.synthetic = synthetic;
        this.method = method;
        this.callerPosition = callerPosition;
        assert (callerPosition == null || callerPosition.method != null);
    }

    public static Position synthetic(int line, DexMethod method, Position callerPosition) {
        assert (line >= 0);
        assert (method != null);
        return new Position(line, null, method, callerPosition, true);
    }

    public static Position none() {
        return NO_POSITION;
    }

    public static Position syntheticNone() {
        return NO_POSITION_SYNTHETIC;
    }

    @VisibleForTesting
    public static Position testingPosition() {
        return TESTING_POSITION;
    }

    public static Position noneWithMethod(DexMethod method, Position callerPosition) {
        assert (method != null);
        return new Position(-1, null, method, callerPosition, false);
    }

    public static Position getPositionForInlining(AppView<?> appView, InvokeMethod invoke, DexEncodedMethod context) {
        Position position = invoke.getPosition();
        if (position.method == null) {
            assert (position.isNone());
            position = Position.noneWithMethod(context.method, null);
        }
        assert (position.callerPosition == null || position.getOutermostCaller().method == appView.graphLense().getOriginalMethodSignature(context.method));
        return position;
    }

    public boolean isNone() {
        return this.line == -1;
    }

    public boolean isSyntheticNone() {
        return this == NO_POSITION_SYNTHETIC;
    }

    public boolean isSome() {
        return !this.isNone();
    }

    public Position getOutermostCaller() {
        Position lastPosition = this;
        while (lastPosition.callerPosition != null) {
            lastPosition = lastPosition.callerPosition;
        }
        return lastPosition;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Position) {
            Position o = (Position)other;
            return this.line == o.line && this.file == o.file && this.method == o.method && this.synthetic == o.synthetic && Objects.equals(this.callerPosition, o.callerPosition);
        }
        return false;
    }

    public int hashCode() {
        int result = this.line;
        result = 31 * result + Objects.hashCode(this.file);
        result = 31 * result + (this.synthetic ? 1 : 0);
        result = 31 * result + Objects.hashCode(this.method);
        result = 31 * result + Objects.hashCode(this.callerPosition);
        return result;
    }

    private String toString(boolean forceMethod) {
        if (this.isNone()) {
            return "--";
        }
        StringBuilder builder = new StringBuilder();
        if (this.file != null) {
            builder.append(this.file).append(":");
        }
        builder.append("#").append(this.line);
        if (this.method != null && (forceMethod || this.callerPosition != null)) {
            builder.append(":").append(this.method.name);
        }
        if (this.callerPosition != null) {
            Position caller = this.callerPosition;
            while (caller != null) {
                builder.append(";").append(caller.line).append(":").append(caller.method.name);
                caller = caller.callerPosition;
            }
        }
        return builder.toString();
    }

    public String toString() {
        return this.toString(false);
    }
}

