/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.function.Consumer;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.JumpInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;

public abstract class Switch
extends JumpInstruction {
    private final int[] targetBlockIndices;
    private int fallthroughBlockIndex;

    public Switch(Value in, int[] targetBlockIndices, int fallthroughBlockIndex) {
        super(in);
        this.targetBlockIndices = targetBlockIndices;
        this.fallthroughBlockIndex = fallthroughBlockIndex;
    }

    public Value value() {
        return (Value)this.inValues.get(0);
    }

    public boolean valid() {
        for (int i = 0; i < this.numberOfKeys(); ++i) {
            assert (this.getTargetBlockIndex(i) != this.getFallthroughBlockIndex());
        }
        return true;
    }

    public BasicBlock targetBlock(int index) {
        return this.getBlock().getSuccessors().get(this.targetBlockIndices()[index]);
    }

    public int getTargetBlockIndex(int index) {
        return this.targetBlockIndices[index];
    }

    public int[] targetBlockIndices() {
        return this.targetBlockIndices;
    }

    public void forEachTarget(Consumer<BasicBlock> fn) {
        for (int i = 0; i < this.targetBlockIndices.length; ++i) {
            fn.accept(this.targetBlock(i));
        }
    }

    @Override
    public BasicBlock fallthroughBlock() {
        return this.getBlock().getSuccessors().get(this.fallthroughBlockIndex);
    }

    public int getFallthroughBlockIndex() {
        return this.fallthroughBlockIndex;
    }

    public void setFallthroughBlockIndex(int i) {
        this.fallthroughBlockIndex = i;
    }

    @Override
    public void setFallthroughBlock(BasicBlock block) {
        this.getBlock().getMutableSuccessors().set(this.fallthroughBlockIndex, block);
    }

    public int numberOfKeys() {
        return this.targetBlockIndices.length;
    }

    @Override
    public boolean isSwitch() {
        return true;
    }

    @Override
    public Switch asSwitch() {
        return this;
    }
}

